/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import org.eclipse.egit.ui.internal.commit.LogicalLineNumberRulerColumn;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.themes.ColorUtil;

public class OldNewLogicalLineNumberRulerColumn
extends LineNumberRulerColumn {
    private final CompositeRuler composite = new CompositeRuler(0);
    private final LineNumberRulerColumn plainLines = new LineNumberRulerColumn(){

        public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
            return OldNewLogicalLineNumberRulerColumn.this.addMenuListener(super.createControl(parentRuler, parentControl));
        }
    };
    private final LineNumberRulerColumn oldLines = new LogicalLineNumberRulerColumn(DiffEntry.Side.OLD){
        private ResourceManager resourceManager;
        private Color lineColor;

        public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
            return OldNewLogicalLineNumberRulerColumn.this.addMenuListener(super.createControl(parentRuler, parentControl));
        }

        public int getWidth() {
            return super.getWidth() + 3;
        }

        protected void paintLine(int line, int y, int lineHeight, GC gc, Display display) {
            super.paintLine(line, y, lineHeight, gc, display);
            int x = super.getWidth() + 1;
            if (this.lineColor == null) {
                if (this.resourceManager == null) {
                    this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
                }
                this.lineColor = this.resourceManager.createColor(ColorUtil.blend((RGB)gc.getForeground().getRGB(), (RGB)gc.getBackground().getRGB(), (int)60));
            }
            Color foreground = gc.getForeground();
            Rectangle bounds = super.getControl().getBounds();
            gc.setForeground(this.lineColor);
            gc.drawLine(x * this.zoom / 100, 0, x * this.zoom / 100, bounds.height * this.zoom / 100);
            gc.setForeground(foreground);
        }

        public void setForeground(Color foreground) {
            this.lineColor = null;
            super.setForeground(foreground);
        }

        public void setBackground(Color background) {
            this.lineColor = null;
            super.setBackground(background);
        }

        protected void handleDispose() {
            super.handleDispose();
            if (this.resourceManager != null) {
                this.resourceManager.dispose();
                this.resourceManager = null;
            }
            this.lineColor = null;
        }
    };
    private final LineNumberRulerColumn newLines = new LogicalLineNumberRulerColumn(DiffEntry.Side.NEW){

        public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
            return OldNewLogicalLineNumberRulerColumn.this.addMenuListener(super.createControl(parentRuler, parentControl));
        }
    };
    private boolean plain;
    private Listener menuListener;

    public OldNewLogicalLineNumberRulerColumn() {
        this(false);
    }

    public OldNewLogicalLineNumberRulerColumn(boolean plain) {
        this.plain = plain;
        if (!plain) {
            this.composite.addDecorator(0, (IVerticalRulerColumn)this.oldLines);
            this.composite.addDecorator(1, (IVerticalRulerColumn)this.newLines);
        } else {
            this.composite.addDecorator(0, (IVerticalRulerColumn)this.plainLines);
        }
    }

    public void setModel(IAnnotationModel model) {
        this.composite.setModel(model);
    }

    public void redraw() {
        this.composite.immediateUpdate();
    }

    public Control createControl(final CompositeRuler parentRuler, Composite parentControl) {
        this.menuListener = event -> {
            Menu contextMenu;
            if (event.type == 35 && (contextMenu = parentControl.getMenu()) != null) {
                contextMenu.setLocation(event.x, event.y);
                contextMenu.setVisible(true);
            }
        };
        parentControl.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                parentRuler.relayout();
            }
        });
        return this.composite.createControl(parentControl, parentRuler.getTextViewer());
    }

    private Control addMenuListener(Control control) {
        if (this.menuListener != null) {
            control.addListener(35, this.menuListener);
        }
        return control;
    }

    public Control getControl() {
        return this.composite.getControl();
    }

    public int getWidth() {
        return this.composite.getWidth();
    }

    public void setFont(Font font) {
        this.plainLines.setFont(font);
        this.oldLines.setFont(font);
        this.newLines.setFont(font);
    }

    public void setForeground(Color foreground) {
        super.setForeground(foreground);
        this.plainLines.setForeground(foreground);
        this.oldLines.setForeground(foreground);
        this.newLines.setForeground(foreground);
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        this.plainLines.setBackground(background);
        this.oldLines.setBackground(background);
        this.newLines.setBackground(background);
    }

    public boolean isPlain() {
        return this.plain;
    }

    public void setPlain(boolean plain) {
        if (this.plain != plain) {
            this.plain = plain;
            if (!plain) {
                this.composite.removeDecorator((IVerticalRulerColumn)this.plainLines);
                this.composite.addDecorator(0, (IVerticalRulerColumn)this.oldLines);
                this.composite.addDecorator(1, (IVerticalRulerColumn)this.newLines);
            } else {
                this.composite.removeDecorator((IVerticalRulerColumn)this.oldLines);
                this.composite.removeDecorator((IVerticalRulerColumn)this.newLines);
                this.composite.addDecorator(0, (IVerticalRulerColumn)this.plainLines);
            }
        }
    }
}

