/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.mediawiki.internal.block;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class ListBlock
extends Block {
    private static final int LINE_REMAINDER_GROUP_OFFSET = 2;
    static final Pattern startPattern = Pattern.compile("((?:(?:\\*)|(?:#)|(?:\\;)|(?:\\:))+)\\s?(.+)");
    static final Pattern definitionPattern = Pattern.compile("(\\s+\\:\\s+)(.*)");
    private int blockLineCount = 0;
    private Matcher matcher;
    private Stack<ListState> listState;

    public int processLineContent(String line, int offset) {
        char lastChar;
        String listSpec;
        boolean continuation = false;
        if (this.blockLineCount == 0) {
            this.listState = new Stack();
            Attributes attributes = new Attributes();
            listSpec = this.matcher.group(1);
            lastChar = listSpec.charAt(listSpec.length() - 1);
            int level = this.calculateLevel(listSpec);
            DocumentBuilder.BlockType type = this.calculateType(lastChar);
            DocumentBuilder.BlockType itemType = this.calculateItemType(lastChar);
            if (type == DocumentBuilder.BlockType.BULLETED_LIST && '-' == lastChar) {
                attributes.setCssStyle("list-style: square");
            }
            offset = this.matcher.start(2);
            this.listState.push(new ListState(1, type, itemType));
            this.builder.beginBlock(type, attributes);
            this.adjustLevel(lastChar, level, type, itemType);
        } else {
            Matcher matcher = startPattern.matcher(line);
            if (!matcher.matches()) {
                this.setClosed(true);
                return 0;
            }
            listSpec = matcher.group(1);
            lastChar = listSpec.charAt(listSpec.length() - 1);
            int lineLevel = this.calculateLevel(listSpec);
            DocumentBuilder.BlockType type = this.calculateType(lastChar);
            DocumentBuilder.BlockType itemType = this.calculateItemType(lastChar);
            offset = matcher.start(2);
            continuation = this.adjustLevel(lastChar, lineLevel, type, itemType);
        }
        ++this.blockLineCount;
        ListState listState = this.listState.peek();
        if (!continuation && listState.openItem) {
            listState.openItem = false;
            this.builder.endBlock();
        }
        if (!listState.openItem) {
            listState.openItem = true;
            this.builder.beginBlock(listState.itemType, new Attributes());
        }
        String definition = null;
        int definitionOffset = -1;
        if (listState.itemType == DocumentBuilder.BlockType.DEFINITION_TERM) {
            Matcher definitionMatcher = definitionPattern.matcher(line);
            if (offset > 0) {
                definitionMatcher.region(offset, line.length());
            }
            if (definitionMatcher.find()) {
                line = line.substring(offset, definitionMatcher.start(1));
                offset = 0;
                definition = definitionMatcher.group(2);
                definitionOffset = definitionMatcher.start(2);
            }
        }
        if (definition == null) {
            this.markupLanguage.emitMarkupLine(this.getParser(), this.state, line, offset);
        } else {
            this.markupLanguage.emitMarkupLine(this.getParser(), this.state, offset, line, 0);
        }
        if (definition != null) {
            listState.openItem = false;
            this.builder.endBlock();
            this.adjustLevel(' ', listState.level, DocumentBuilder.BlockType.DEFINITION_LIST, DocumentBuilder.BlockType.DEFINITION_ITEM);
            listState = this.listState.peek();
            if (listState.openItem) {
                this.builder.endBlock();
            }
            listState.openItem = true;
            this.builder.beginBlock(listState.itemType, new Attributes());
            this.markupLanguage.emitMarkupLine(this.parser, this.state, definitionOffset, definition, 0);
        }
        return -1;
    }

    private boolean adjustLevel(char lastChar, int lineLevel, DocumentBuilder.BlockType type, DocumentBuilder.BlockType itemType) {
        boolean continuation = false;
        ListState previousState = this.listState.peek();
        while (lineLevel != previousState.level || previousState.type != type || previousState.itemType != itemType) {
            Attributes blockAttributes;
            if (lineLevel > previousState.level) {
                if (!previousState.openItem) {
                    this.builder.beginBlock(previousState.itemType, new Attributes());
                    previousState.openItem = true;
                }
                blockAttributes = new Attributes();
                if (type == DocumentBuilder.BlockType.BULLETED_LIST && '-' == lastChar) {
                    blockAttributes.setCssStyle("list-style: square");
                }
                this.listState.push(new ListState(previousState.level + 1, type, itemType));
                this.builder.beginBlock(type, blockAttributes);
            } else if (lineLevel == previousState.level && previousState.type == type && previousState.itemType != itemType) {
                if (previousState.openItem) {
                    this.builder.endBlock();
                    previousState.openItem = false;
                }
                previousState.itemType = itemType;
            } else {
                if (lineLevel == previousState.level && lastChar == ':' && previousState.itemType != DocumentBuilder.BlockType.DEFINITION_ITEM && previousState.itemType != DocumentBuilder.BlockType.DEFINITION_TERM) {
                    continuation = true;
                    break;
                }
                this.closeOne();
                if (this.listState.isEmpty()) {
                    blockAttributes = new Attributes();
                    if (type == DocumentBuilder.BlockType.BULLETED_LIST && '-' == lastChar) {
                        blockAttributes.setCssStyle("list-style: square");
                    }
                    this.listState.push(new ListState(1, type, itemType));
                    this.builder.beginBlock(type, blockAttributes);
                }
            }
            previousState = this.listState.peek();
        }
        return continuation;
    }

    private int calculateLevel(String listSpec) {
        return listSpec.length();
    }

    private DocumentBuilder.BlockType calculateType(char lastChar) {
        switch (lastChar) {
            case '#': {
                return DocumentBuilder.BlockType.NUMERIC_LIST;
            }
            case ':': 
            case ';': {
                return DocumentBuilder.BlockType.DEFINITION_LIST;
            }
        }
        return DocumentBuilder.BlockType.BULLETED_LIST;
    }

    private DocumentBuilder.BlockType calculateItemType(char lastChar) {
        switch (lastChar) {
            case ';': {
                return DocumentBuilder.BlockType.DEFINITION_TERM;
            }
            case ':': {
                return DocumentBuilder.BlockType.DEFINITION_ITEM;
            }
        }
        return DocumentBuilder.BlockType.LIST_ITEM;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        this.listState = null;
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            while (this.listState != null && !this.listState.isEmpty()) {
                this.closeOne();
            }
            this.listState = null;
        }
        super.setClosed(closed);
    }

    private void closeOne() {
        ListState e = this.listState.pop();
        if (e.openItem) {
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    private static class ListState {
        int level;
        DocumentBuilder.BlockType type;
        DocumentBuilder.BlockType itemType;
        boolean openItem;

        private ListState(int level, DocumentBuilder.BlockType type, DocumentBuilder.BlockType itemType) {
            this.level = level;
            this.type = type;
            this.itemType = itemType;
        }
    }
}

