/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.markdown.marked;

import org.eclipse.tm4e.markdown.marked.Helpers;
import org.eclipse.tm4e.markdown.marked.IRenderer;

public class HTMLRenderer
implements IRenderer {
    protected final StringBuilder html;

    public HTMLRenderer() {
        this(new StringBuilder());
    }

    public HTMLRenderer(StringBuilder html) {
        this.html = html;
    }

    @Override
    public void code(String code, String lang, boolean escaped) {
        if (lang == null) {
            this.html.append("<pre><code>");
            this.html.append(escaped ? code : Helpers.escape(code, true));
            this.html.append("\n</code></pre>");
        } else {
            this.html.append("<pre><code>");
            this.html.append(escaped ? code : Helpers.escape(code, true));
            this.html.append("\n</code></pre>");
        }
    }

    @Override
    public void blockquote(String quote) {
    }

    @Override
    public void html(String html) {
    }

    @Override
    public void heading(String text, int level, String raw) {
        this.html.append("<h");
        this.html.append(level);
        this.html.append(" id=\"");
        this.html.append("\">");
        this.html.append(text);
        this.html.append("</h");
        this.html.append(level);
        this.html.append(">\n");
    }

    @Override
    public void hr() {
        this.html.append("<hr />\n");
    }

    @Override
    public void list(String body, boolean ordered) {
    }

    @Override
    public void listitem(String text) {
    }

    @Override
    public void startParagraph() {
        this.html.append("<p>");
    }

    @Override
    public void endParagraph() {
        this.html.append("</p>\n");
    }

    @Override
    public void table(String header, String body) {
    }

    @Override
    public void tablerow(String content) {
    }

    @Override
    public void tablecell(String content, String flags) {
    }

    @Override
    public void startEm() {
        this.html.append("<em>");
    }

    @Override
    public void endEm() {
        this.html.append("</em>");
    }

    @Override
    public void startStrong() {
        this.html.append("<strong>");
    }

    @Override
    public void endStrong() {
        this.html.append("</strong>");
    }

    @Override
    public void codespan(String text) {
        this.html.append("<code>");
        this.html.append(text);
        this.html.append("</code>");
    }

    @Override
    public void br() {
    }

    @Override
    public void del(String text) {
    }

    @Override
    public void link(String href, String title, String text) {
    }

    @Override
    public void image(String href, String title, String text) {
    }

    @Override
    public void text(String text) {
        this.html.append(text);
    }

    public String toString() {
        return this.html.toString();
    }
}

