/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.linkedediting;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.operations.linkedediting.LSPLinkedEditingBase;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Range;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class LSPLinkedEditingReconcilingStrategy
extends LSPLinkedEditingBase
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
IDocumentListener {
    private ISourceViewer sourceViewer;
    private IDocument fDocument;
    private EditorSelectionChangedListener editorSelectionChangedListener;
    private Job highlightJob;
    private LinkedModeModel linkedModel;

    public void install(ITextViewer viewer) {
        if (!(viewer instanceof ISourceViewer)) {
            return;
        }
        super.install();
        this.sourceViewer = (ISourceViewer)viewer;
        this.editorSelectionChangedListener = new EditorSelectionChangedListener();
        this.editorSelectionChangedListener.install(this.sourceViewer.getSelectionProvider());
    }

    @Override
    public void uninstall() {
        if (this.sourceViewer != null) {
            this.editorSelectionChangedListener.uninstall(this.sourceViewer.getSelectionProvider());
        }
        super.uninstall();
    }

    @Override
    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        super.preferenceChange(event);
        if (event.getKey().equals("org.eclipse.ui.genericeditor.linkedediting") && this.fEnabled) {
            this.initialReconcile();
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        if (this.sourceViewer != null) {
            ISelectionProvider selectionProvider = this.sourceViewer.getSelectionProvider();
            StyledText textWidget = this.sourceViewer.getTextWidget();
            if (textWidget != null && selectionProvider != null) {
                textWidget.getDisplay().asyncExec(() -> {
                    if (!textWidget.isDisposed()) {
                        this.updateLinkedEditing(selectionProvider.getSelection());
                    }
                });
            }
        }
    }

    public void setDocument(IDocument document) {
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener((IDocumentListener)this);
        }
        this.fDocument = document;
        if (this.fDocument != null) {
            this.fDocument.addDocumentListener((IDocumentListener)this);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
    }

    public void reconcile(IRegion partition) {
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.updateLinkedEditing(event.getOffset());
    }

    private void updateLinkedEditing(ISelection selection) {
        if (selection instanceof ITextSelection) {
            this.updateLinkedEditing(((ITextSelection)selection).getOffset());
        }
    }

    private void updateLinkedEditing(int offset) {
        if (this.sourceViewer != null && this.fDocument != null && this.fEnabled && this.linkedModel == null || !this.linkedModel.anyPositionContains(offset)) {
            this.collectLinkedEditingRanges(this.fDocument, offset).thenAcceptAsync(this::applyLinkedEdit);
        }
    }

    private void applyLinkedEdit(final LinkedEditingRanges ranges) {
        if (this.highlightJob != null) {
            this.highlightJob.cancel();
        }
        if (ranges == null) {
            return;
        }
        this.highlightJob = new UIJob("LSP4E Linked Editing"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                LSPLinkedEditingReconcilingStrategy.this.linkedModel = new LinkedModeModel();
                try {
                    LSPLinkedEditingReconcilingStrategy.this.linkedModel.addGroup(LSPLinkedEditingReconcilingStrategy.this.toJFaceGroup(ranges));
                    LSPLinkedEditingReconcilingStrategy.this.linkedModel.forceInstall();
                    ITextSelection selectionBefore = (ITextSelection)LSPLinkedEditingReconcilingStrategy.this.sourceViewer.getSelectionProvider().getSelection();
                    EditorLinkedModeUI linkedMode = new EditorLinkedModeUI(LSPLinkedEditingReconcilingStrategy.this.linkedModel, (ITextViewer)LSPLinkedEditingReconcilingStrategy.this.sourceViewer);
                    linkedMode.setExitPolicy((model, event, offset, length) -> {
                        Pattern pattern;
                        Matcher matcher;
                        String valuee;
                        if (event.character == '\u0000' || event.character == '\b') {
                            return null;
                        }
                        if (ranges != null && ranges.getWordPattern() != null ? (valuee = LSPLinkedEditingReconcilingStrategy.this.getValueInRange(ranges, event, offset, length)) != null && (matcher = (pattern = Pattern.compile(ranges.getWordPattern())).matcher(valuee)).matches() : Character.isUnicodeIdentifierPart(event.character) || event.character == '_') {
                            return null;
                        }
                        return new LinkedModeUI.ExitFlags(1, true);
                    });
                    linkedMode.enter();
                    LSPLinkedEditingReconcilingStrategy.this.sourceViewer.getSelectionProvider().setSelection((ISelection)selectionBefore);
                    return Status.OK_STATUS;
                }
                catch (BadLocationException ex) {
                    return new Status(4, "org.eclipse.lsp4e", ex.getMessage(), (Throwable)ex);
                }
            }
        };
        this.highlightJob.schedule();
    }

    String getValueInRange(LinkedEditingRanges ranges, VerifyEvent event, int offset, int length) {
        try {
            for (Range range : ranges.getRanges()) {
                int start = LSPEclipseUtils.toOffset(range.getStart(), this.fDocument);
                int end = LSPEclipseUtils.toOffset(range.getEnd(), this.fDocument);
                if (start > offset || offset > end) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(this.fDocument.get(start, end - start));
                String newChars = event.character == '\u0000' ? "" : Character.toString(event.character);
                sb.replace(offset - start, offset - start + length, newChars);
                return sb.toString();
            }
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
        return null;
    }

    private LinkedPositionGroup toJFaceGroup(LinkedEditingRanges ranges) throws BadLocationException {
        LinkedPositionGroup res = new LinkedPositionGroup();
        for (Range range : ranges.getRanges()) {
            int startOffset = LSPEclipseUtils.toOffset(range.getStart(), this.fDocument);
            int length = LSPEclipseUtils.toOffset(range.getEnd(), this.fDocument) - startOffset;
            res.addPosition(new LinkedPosition(this.fDocument, startOffset, length));
        }
        return res;
    }

    class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        EditorSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            LSPLinkedEditingReconcilingStrategy.this.updateLinkedEditing(event.getSelection());
        }
    }
}

