/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dartboard.Messages;
import org.eclipse.dartboard.util.PlatformUIUtil;
import org.eclipse.dartboard.util.StatusUtil;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class LaunchShortcut
implements ILaunchShortcut {
    private static final ILog LOG = Platform.getLog(LaunchShortcut.class);

    public void launch(ISelection selection, String mode) {
        Object firstElement;
        IProject selected = null;
        if (selection instanceof StructuredSelection && (firstElement = ((StructuredSelection)selection).getFirstElement()) instanceof IResource) {
            selected = ((IResource)firstElement).getProject();
        }
        this.launchProject(selected, mode);
    }

    public void launch(IEditorPart editor, String mode) {
        IProject project = null;
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            project = ((IFileEditorInput)editorInput).getFile().getProject();
        }
        this.launchProject(project, mode);
    }

    private void launchProject(IProject project, String mode) {
        if (project == null) {
            MessageDialog.openError((Shell)PlatformUIUtil.getActiveShell(), (String)Messages.Launch_ConfigurationRequired_Title, (String)Messages.Launch_ConfigurationRequired_Body);
            return;
        }
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.dartboard.launch");
        try {
            ILaunchConfiguration launchConfiguration = null;
            ILaunchConfiguration[] iLaunchConfigurationArray = manager.getLaunchConfigurations(type);
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration conf = iLaunchConfigurationArray[n2];
                if (conf.getAttribute("selected_project", "").equalsIgnoreCase(project.getName())) {
                    launchConfiguration = conf;
                }
                ++n2;
            }
            if (launchConfiguration != null) {
                DebugUITools.launch(launchConfiguration, (String)mode);
            } else {
                ILaunchConfigurationWorkingCopy copy = type.newInstance(null, manager.generateLaunchConfigurationName(LaunchConfigurationsMessages.CreateLaunchConfigurationAction_New_configuration_2));
                copy.setAttribute("selected_project", project.getName());
                int result = DebugUITools.openLaunchConfigurationDialog((Shell)PlatformUIUtil.getActiveShell(), (ILaunchConfiguration)copy, (String)"org.eclipse.dartboard.launchGroup", null);
                if (result == 0) {
                    copy.doSave();
                }
            }
        }
        catch (CoreException e) {
            LOG.log(StatusUtil.createError("Could not save new launch configuration", e));
        }
    }
}

