/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.preference;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.dartboard.Messages;
import org.eclipse.dartboard.util.DartPreferences;
import org.eclipse.dartboard.util.DartUtil;
import org.eclipse.dartboard.util.StatusUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class DartPreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final ILog LOG = Platform.getLog(DartPreferenceInitializer.class);
    private static boolean warned;

    public void initializeDefaultPreferences() {
        ScopedPreferenceStore scopedPreferenceStore = DartPreferences.getPreferenceStore();
        if (scopedPreferenceStore.getString("sdk_location").isEmpty()) {
            Optional<Object> binLocation = Optional.empty();
            try {
                binLocation = DartUtil.getDartLocation();
            }
            catch (IOException | InterruptedException e) {
                LOG.log(StatusUtil.createError("Could not retrieve Dart location", e));
            }
            if (binLocation.isPresent()) {
                Path sdkPath = ((Path)binLocation.get()).getParent();
                scopedPreferenceStore.setDefault("sdk_location", sdkPath.toString());
            } else if (!warned) {
                MessageDialog.openError(null, (String)Messages.Preference_SDKNotFound_Title, (String)Messages.Preference_SDKNotFound_Body);
            }
        }
        scopedPreferenceStore.setDefault("auto_pub_sync", true);
        scopedPreferenceStore.setDefault("offline_pub", false);
    }
}

