/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.preference;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dartboard.Messages;
import org.eclipse.dartboard.preference.DartSDKLocationFieldEditor;
import org.eclipse.dartboard.util.DartPreferences;
import org.eclipse.dartboard.util.StatusUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DartPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final ILog LOG = Platform.getLog(DartPreferencePage.class);
    private DartSDKLocationFieldEditor dartSDKLocationEditor;

    public DartPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)DartPreferences.getPreferenceStore());
    }

    public boolean performOk() {
        String sdkLocation = this.dartSDKLocationEditor.getStringValue();
        String oldValue = this.getPreferenceStore().getString("sdk_location");
        boolean ok = super.performOk();
        if (sdkLocation.equals(oldValue)) {
            return true;
        }
        Path path = this.getPath(sdkLocation);
        if (path == null) {
            this.setValid(false);
            return false;
        }
        this.dartSDKLocationEditor.setStringValue(path.toAbsolutePath().toString());
        boolean result = MessageDialog.openQuestion(null, (String)Messages.Preference_RestartRequired_Title, (String)Messages.Preference_RestartRequired_Message);
        if (result) {
            try {
                this.save();
            }
            catch (IOException e) {
                LOG.log(StatusUtil.createError("Could not save IDE preferences", e));
            }
            Display.getDefault().asyncExec(() -> PlatformUI.getWorkbench().restart(true));
        }
        return ok;
    }

    private Path getPath(String location) {
        if (this.dartSDKLocationEditor.isValid()) {
            Path path = null;
            try {
                boolean isWindows = "win32".equals(Platform.getOS());
                path = Paths.get(String.valueOf(location) + "bin" + File.separator + (isWindows ? "dart.exe" : "dart"), new String[0]);
                path = path.toRealPath(new LinkOption[0]).toAbsolutePath().getParent().getParent();
            }
            catch (IOException e) {
                LOG.log(StatusUtil.createError("Couldn't follow symlink", e));
            }
            return path;
        }
        return null;
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.dartSDKLocationEditor = new DartSDKLocationFieldEditor("sdk_location", Messages.Preference_SDKLocation, parent);
        this.addField((FieldEditor)this.dartSDKLocationEditor);
        this.dartSDKLocationEditor.addModifyListener(event -> this.setValid(this.dartSDKLocationEditor.doCheckState()));
        BooleanFieldEditor autoPubSyncEditor = new BooleanFieldEditor("auto_pub_sync", Messages.Preference_PubAutoSync_Label, parent);
        this.addField((FieldEditor)autoPubSyncEditor);
        BooleanFieldEditor useOfflinePub = new BooleanFieldEditor("offline_pub", Messages.Preference_PubOffline_Label, parent);
        this.addField((FieldEditor)useOfflinePub);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("field_editor_value".equals(event.getProperty())) {
            this.setValid(this.dartSDKLocationEditor.doCheckState());
        }
        super.propertyChange(event);
    }

    private void save() throws IOException {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.needsSaving() && store instanceof IPersistentPreferenceStore) {
            ((IPersistentPreferenceStore)store).save();
        }
    }
}

