/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.project;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dartboard.util.StatusUtil;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class DartProjectConfigurator
implements ProjectConfigurator {
    private static final ILog LOG = Platform.getLog(DartProjectConfigurator.class);

    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        final HashSet<File> files = new HashSet<File>();
        try {
            Files.walkFileTree(root.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.endsWith("pubspec.yaml")) {
                        files.add(file.toFile().getParentFile());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOG.log(StatusUtil.createError("Couldn't walk children directories", e));
        }
        return files;
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        return true;
    }

    public Set<IFolder> getFoldersToIgnore(IProject project, IProgressMonitor monitor) {
        return Collections.emptySet();
    }

    public boolean canConfigure(IProject project, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
        return false;
    }

    public void configure(IProject project, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
    }
}

