/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.project;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dartboard.Messages;
import org.eclipse.dartboard.project.DartProjectPage;
import org.eclipse.dartboard.stagehand.StagehandGenerator;
import org.eclipse.dartboard.util.StatusUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class DartProjectWizard
extends Wizard
implements INewWizard {
    private static final ILog LOG = Platform.getLog(DartProjectWizard.class);
    private DartProjectPage dartProjectPage;
    private IProject newProject;
    private IWorkbench workbench;
    private IStructuredSelection selection;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.NewProject_WindowTitle);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.dartProjectPage = new DartProjectPage(DartProjectPage.class.getSimpleName());
        this.dartProjectPage.setTitle(Messages.NewProject_Title);
        this.dartProjectPage.setDescription(Messages.NewProject_Description);
        this.addPage((IWizardPage)this.dartProjectPage);
    }

    private IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        IProject newProjectHandle = this.dartProjectPage.getProjectHandle();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        if (!this.dartProjectPage.useDefaults()) {
            description.setLocationURI(this.dartProjectPage.getLocationURI());
        }
        IRunnableWithProgress operation = monitor -> {
            CreateProjectOperation projectOperation = new CreateProjectOperation(description, Messages.NewProject_WindowTitle);
            try {
                projectOperation.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
            }
            catch (ExecutionException e) {
                throw new InvocationTargetException(e);
            }
        };
        try {
            this.getContainer().run(true, true, operation);
        }
        catch (InterruptedException e) {
            LOG.log(StatusUtil.createError(e.getMessage()));
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ExecutionException && t.getCause() instanceof CoreException) {
                CoreException cause = (CoreException)t.getCause();
                StatusAdapter status = cause.getStatus().getCode() == 275 ? new StatusAdapter(StatusUtil.newStatus(2, NLS.bind((String)Messages.NewProject_CaseVariantExistsError, (Object)newProjectHandle.getName()), cause)) : new StatusAdapter(StatusUtil.newStatus(cause.getStatus().getSeverity(), Messages.NewProject_ErrorMessage, cause));
                status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.NewProject_ErrorMessage);
                StatusManager.getManager().handle(status, 4);
            } else {
                StatusAdapter status = new StatusAdapter((IStatus)new Status(2, "org.eclipse.dartboard", 0, NLS.bind((String)Messages.NewProject_InternalError, (Object)t.getMessage()), t));
                status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.NewProject_ErrorMessage);
                StatusManager.getManager().handle(status, 5);
            }
            return null;
        }
        this.newProject = newProjectHandle;
        StagehandGenerator.generate(this.dartProjectPage.getGenerator(), this.newProject);
        return this.newProject;
    }

    public boolean performFinish() {
        this.createNewProject();
        if (this.newProject == null) {
            return false;
        }
        BasicNewResourceWizard.selectAndReveal((IResource)this.newProject, (IWorkbenchWindow)this.getWorkbench().getActiveWorkbenchWindow());
        return true;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }
}

