/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.ddl;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.core.rte.fe.GenericDdlGenerator;
import org.eclipse.datatools.enablement.ingres.internal.ddl.IngresDdlBuilder;
import org.eclipse.datatools.enablement.ingres.internal.ddl.IngresDdlScript;
import org.eclipse.datatools.enablement.ingres.models.ingressqlmodel.IngresDBEvent;
import org.eclipse.datatools.enablement.ingres.models.ingressqlmodel.IngresSynonym;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;

public class IngresDdlGenerator
extends GenericDdlGenerator {
    private IngresDdlBuilder builder;

    protected String[] dropStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        IngresDdlScript script = new IngresDdlScript();
        if (this.builder == null) {
            this.builder = new IngresDdlBuilder();
        }
        EngineeringOption[] options = this.getSelectedOptions(elements);
        for (Object o : this.getAllContainedDisplayableElementSet(elements)) {
            String statement;
            if (o instanceof PersistentTable) {
                if (!this.generateTables(options) || (statement = this.builder.dropTable((BaseTable)((PersistentTable)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTableStatement(statement);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!this.generateViews(options) || (statement = this.builder.dropView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropViewStatement(statement);
                continue;
            }
            if (o instanceof Trigger) {
                if (!this.generateTriggers(options) || (statement = this.builder.dropTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTriggerStatement(statement);
                continue;
            }
            if (o instanceof Procedure) {
                statement = this.builder.dropProcedures((Procedure)o, quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addDropProcedureStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                if (!this.generateCKConstraints(options) || (statement = this.builder.dropTableConstraint((TableConstraint)((CheckConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropConstraintStatement(statement);
                continue;
            }
            if (o instanceof UniqueConstraint) {
                if (!this.generatePKConstraints(options) || (statement = this.builder.dropTableConstraint((TableConstraint)((UniqueConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropConstraintStatement(statement);
                continue;
            }
            if (o instanceof ForeignKey) {
                if (!this.generateFKConstraints(options) || (statement = this.builder.dropTableConstraint((TableConstraint)((ForeignKey)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropForeignKeyStatement(statement);
                continue;
            }
            if (o instanceof Index) {
                if (!this.generateIndexes(options) || (statement = this.builder.dropIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropIndexStatement(statement);
                continue;
            }
            if (o instanceof IngresSynonym) {
                statement = this.builder.dropSynonym((IngresSynonym)o, quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addDropSynonymStatement(statement);
                continue;
            }
            if (o instanceof IngresDBEvent) {
                statement = this.builder.dropDBEvent((IngresDBEvent)o, quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addDropDBEventStatement(statement);
                continue;
            }
            if (!(o instanceof Sequence) || (statement = this.builder.dropSequence((Sequence)o, quoteIdentifiers, qualifyNames)) == null) continue;
            script.addDropSequenceStatement(statement);
        }
        return script.getStatements();
    }

    protected String[] createStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        IngresDdlScript script = new IngresDdlScript();
        if (this.builder == null) {
            this.builder = new IngresDdlBuilder();
        }
        EngineeringOption[] options = this.getSelectedOptions(elements);
        Set allObjectss = this.getAllContainedDisplayableElementSet(elements);
        boolean singleObject = true;
        if (allObjectss.size() > 1) {
            singleObject = false;
        }
        for (Object o : allObjectss) {
            String statement;
            if (o instanceof PersistentTable) {
                if (!this.generateTables(options) || (statement = this.builder.createTable((BaseTable)((PersistentTable)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTableStatement(statement);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!this.generateViews(options) || (statement = this.builder.createView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateViewStatement(statement);
                continue;
            }
            if (o instanceof Trigger) {
                if (!this.generateTriggers(options) || (statement = this.builder.createTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTriggerStatement(statement);
                continue;
            }
            if (o instanceof Procedure) {
                String stmtEmpty = null;
                String stmtDrop = null;
                if (!singleObject) {
                    stmtEmpty = this.builder.createProcedureEmptyBody((Procedure)o, quoteIdentifiers, qualifyNames);
                    stmtDrop = this.builder.dropProcedure((Procedure)o, quoteIdentifiers, qualifyNames);
                }
                String statement2 = this.builder.createProcedures((Procedure)o, quoteIdentifiers, qualifyNames);
                if (stmtEmpty != null) {
                    script.addCreateEmptyProcedureStatement(stmtEmpty);
                }
                if (stmtDrop != null) {
                    script.addCreateProcedureStatement(stmtDrop);
                }
                if (statement2 == null) continue;
                script.addCreateProcedureStatement(statement2);
                continue;
            }
            if (o instanceof CheckConstraint) {
                if (!this.generateCKConstraints(options) || (statement = this.builder.addCheckConstraint((CheckConstraint)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof UniqueConstraint) {
                if (!this.generatePKConstraints(options) || (statement = this.builder.addUniqueConstraint((UniqueConstraint)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof ForeignKey) {
                if (!this.generateFKConstraints(options) || (statement = this.builder.addForeignKey((ForeignKey)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddForeignKeyStatement(statement);
                continue;
            }
            if (o instanceof Index) {
                if (!this.generateIndexes(options) || (statement = this.builder.createIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateIndexStatement(statement);
                continue;
            }
            if (o instanceof IngresSynonym) {
                statement = this.builder.createSynonym((IngresSynonym)o, quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addCreateSynonymStatement(statement);
                continue;
            }
            if (o instanceof IngresDBEvent) {
                statement = this.builder.createDBEvent((IngresDBEvent)o, quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addCreateDBEventStatement(statement);
                continue;
            }
            if (!(o instanceof Sequence) || (statement = this.builder.createSequence((Sequence)o, quoteIdentifiers, qualifyNames)) == null) continue;
            script.addCreateSequenceStatement(statement);
        }
        return script.getStatements();
    }
}

