/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages.intropage;

import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages.intropage.IIntroHyperAction;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages.intropage.IntroductionPage;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PlatformUI;

public class DisplayHelpAction
extends Action
implements IIntroHyperAction {
    String _contextHelpId = null;
    String _pluginId = null;

    public DisplayHelpAction() {
    }

    public DisplayHelpAction(String text) {
        super(text);
    }

    public DisplayHelpAction(String text, String contextHelpId) {
        super(text);
        this._contextHelpId = contextHelpId;
    }

    private void displayHelp() {
        String contextId = null;
        if (this._contextHelpId != null && this._pluginId != null) {
            contextId = HelpUtil.getContextId((String)this._contextHelpId, (String)this._pluginId);
        }
        if (contextId != null && contextId.length() > 0) {
            IContext context = HelpSystem.getContext((String)contextId);
            if (context == null || context.getRelatedTopics().length == 0 || context.getRelatedTopics()[0].getHref() == null) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp();
            } else if (context.getRelatedTopics().length > 1) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp(contextId);
            } else {
                PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(context.getRelatedTopics()[0].getHref());
            }
        } else {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp();
        }
    }

    public void run() {
        this.displayHelp();
    }

    public void setPage(ISchemaObjectEditorPage page) {
        if (this._contextHelpId == null && page instanceof IntroductionPage) {
            this._contextHelpId = ((IntroductionPage)page).getContextHelpId();
            this._pluginId = page.getEditorDescriptor().getPluginId();
        }
    }
}

