/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.constant;

import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.constant.ConstantOptionsPage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.constant.NumericConstantBuilderPage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.constant.StringConstantBuilderPage;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.StringUtility;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ConstantExpressionWizard
extends Wizard
implements INewWizard {
    protected NumericConstantBuilderPage numericConstantBuilderPage;
    protected StringConstantBuilderPage stringConstantBuilderPage;
    protected ConstantOptionsPage constantOptionsPage;
    private SQLQueryObject sqlStatement;
    private QueryValueExpression inputSQLExpression;
    private QueryValueExpression updatedSQLExpression;
    public static String NUMERICCONSTANT = Messages._UI_NUMERIC_CONSTANT;
    private SQLDomainModel domainModel;

    public ConstantExpressionWizard(SQLQueryObject sqlStatementArg, QueryValueExpression sqlExpr, SQLDomainModel model) {
        this.sqlStatement = sqlStatementArg;
        this.updatedSQLExpression = this.inputSQLExpression = sqlExpr;
        this.setWindowTitle(Messages._UI_WIZARD_CONSTANT_TITLE);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)SQLBuilderPlugin.getPlugin())).getClass(), (String)"icons/expressionbuilder_wiz.gif"));
        this.domainModel = model;
    }

    public ConstantExpressionWizard(QueryStatement sqlStatementArg, QueryValueExpression sqlExpr) {
        this.sqlStatement = sqlStatementArg;
        this.updatedSQLExpression = this.inputSQLExpression = sqlExpr;
        this.setWindowTitle(Messages._UI_WIZARD_CONSTANT_TITLE);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)SQLBuilderPlugin.getPlugin())).getClass(), (String)"icons/expressionbuilder_wiz.gif"));
    }

    public void addPages() {
        if (this.inputSQLExpression == null) {
            this.constantOptionsPage = new ConstantOptionsPage(this.sqlStatement, null);
            this.stringConstantBuilderPage = new StringConstantBuilderPage(this.sqlStatement, null, this.domainModel);
            this.numericConstantBuilderPage = new NumericConstantBuilderPage(this.sqlStatement, null);
            this.addPage((IWizardPage)this.constantOptionsPage);
            this.addPage((IWizardPage)this.numericConstantBuilderPage);
            this.addPage((IWizardPage)this.stringConstantBuilderPage);
        } else if (this.inputSQLExpression != null) {
            if (this.inputSQLExpression.toString().equals("*") || this.inputSQLExpression.toString().toUpperCase().equals("NULL") || this.inputSQLExpression.toString().toUpperCase().equals("IS NOT NULL")) {
                this.constantOptionsPage = new ConstantOptionsPage(this.sqlStatement, null);
                this.stringConstantBuilderPage = new StringConstantBuilderPage(this.sqlStatement, null, this.domainModel);
                this.numericConstantBuilderPage = new NumericConstantBuilderPage(this.sqlStatement, null);
                this.addPage((IWizardPage)this.constantOptionsPage);
                this.addPage((IWizardPage)this.numericConstantBuilderPage);
                this.addPage((IWizardPage)this.stringConstantBuilderPage);
            } else if (StringUtility.lastIndexOfAnyBut(this.inputSQLExpression.toString(), NUMERICCONSTANT) == -1 && !this.inputSQLExpression.toString().equals("")) {
                this.numericConstantBuilderPage = new NumericConstantBuilderPage(this.sqlStatement, this.inputSQLExpression);
                this.addPage((IWizardPage)this.numericConstantBuilderPage);
            } else if (this.inputSQLExpression.toString().equals("") || this.inputSQLExpression.toString().equals("NULL")) {
                this.constantOptionsPage = new ConstantOptionsPage(this.sqlStatement, null);
                this.stringConstantBuilderPage = new StringConstantBuilderPage(this.sqlStatement, null, this.domainModel);
                this.numericConstantBuilderPage = new NumericConstantBuilderPage(this.sqlStatement, null);
                this.addPage((IWizardPage)this.constantOptionsPage);
                this.addPage((IWizardPage)this.numericConstantBuilderPage);
                this.addPage((IWizardPage)this.stringConstantBuilderPage);
            } else {
                this.stringConstantBuilderPage = new StringConstantBuilderPage(this.sqlStatement, this.inputSQLExpression, this.domainModel);
                this.addPage((IWizardPage)this.stringConstantBuilderPage);
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setSQLExpression(QueryValueExpression sqlExpr) {
        this.updatedSQLExpression = sqlExpr;
    }

    public QueryValueExpression getSQLExpression() {
        return this.updatedSQLExpression;
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        WizardPage nextPage = null;
        if (currentPage instanceof ConstantOptionsPage) {
            Object type = ((ConstantOptionsPage)currentPage).getConstantType();
            if (type.equals(ConstantOptionsPage.NUMERIC_CONSTANT)) {
                nextPage = this.numericConstantBuilderPage;
            } else if (type.equals(ConstantOptionsPage.STRING_CONSTANT)) {
                nextPage = this.stringConstantBuilderPage;
            }
            return nextPage;
        }
        return null;
    }

    public void setConstantOptionsPageComplete(boolean bComplete) {
        if (this.constantOptionsPage != null) {
            this.constantOptionsPage.setPageComplete(bComplete);
        }
    }

    public boolean performFinish() {
        if (this.numericConstantBuilderPage != null && this.numericConstantBuilderPage.currentPage()) {
            this.numericConstantBuilderPage.performOk();
        } else if (this.stringConstantBuilderPage != null && this.stringConstantBuilderPage.currentPage()) {
            this.stringConstantBuilderPage.performOk();
        }
        return true;
    }
}

