/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectEditModel;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectEditorModelListener;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorInput;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SchemaObjectEditorModelListenersNotifier
extends AdapterImpl {
    private ListenerList _listeners = new ListenerList();

    public void addModelListener(ISchemaObjectEditorModelListener listener) {
        if (listener != null) {
            this._listeners.add((Object)listener);
        }
    }

    public void removeModelListener(ISchemaObjectEditorModelListener listener) {
        if (listener != null) {
            this._listeners.remove((Object)listener);
        }
    }

    public void removeAllListeners() {
        this._listeners.clear();
    }

    private void registerListenerForObject(EObject obj) {
        if (!obj.eAdapters().contains((Object)this)) {
            obj.eAdapters().add((Object)this);
        }
        Iterator containments = obj.eClass().getEAllContainments().iterator();
        while (containments.hasNext()) {
            Object containmentObj = obj.eGet((EStructuralFeature)containments.next());
            if (containmentObj instanceof EList) {
                Iterator iter = ((EList)containmentObj).iterator();
                while (iter.hasNext()) {
                    this.registerListenerForObject((EObject)iter.next());
                }
                continue;
            }
            if (!(containmentObj instanceof EObject)) continue;
            this.registerListenerForObject((EObject)containmentObj);
        }
    }

    public void registerListener(ISchemaObjectEditorInput input) {
        ISchemaObjectEditModel model = input.getEditModelObject();
        if (model == null) {
            return;
        }
        this.registerListenerForObject((EObject)model.getMainSQLObject());
        Map additionalObjs = model.getAdditionalSQLObjects();
        for (Object value : additionalObjs.values()) {
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                if (col == null) continue;
                for (Object item : col) {
                    if (!(item instanceof EObject)) continue;
                    this.registerListenerForObject((EObject)item);
                }
                continue;
            }
            if (!(value instanceof EObject)) continue;
            this.registerListenerForObject((EObject)value);
        }
    }

    public void notifyChanged(Notification msg) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            try {
                ((ISchemaObjectEditorModelListener)listeners[i]).notifyChanged(msg);
            }
            catch (Exception exception) {}
            ++i;
        }
    }
}

