/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.indent;

import java.util.Arrays;
import org.eclipse.datatools.sqltools.sqleditor.internal.indent.StopCondition;
import org.eclipse.datatools.sqltools.sqleditor.internal.indent.Symbols;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;

public class SQLHeuristicScanner
implements Symbols {
    public static final int NOT_FOUND = -1;
    public static final int UNBOUND = -2;
    private IDocument _document;
    private String _partitioning;
    private String _partition;
    private char _char;
    private int _pos;
    private final StopCondition _nonWSDefaultPart = new NonWhitespaceDefaultPartition();
    private static final StopCondition _nonWS = new NonWhitespace();
    private final StopCondition _nonIdent = new NonSQLIdentifierPartDefaultPartition();

    public SQLHeuristicScanner(IDocument document, String partitioning, String partition) {
        Assert.isNotNull((Object)document);
        Assert.isNotNull((Object)partitioning);
        Assert.isNotNull((Object)partition);
        this._document = document;
        this._partitioning = partitioning;
        this._partition = partition;
    }

    public SQLHeuristicScanner(IDocument document) {
        this(document, "___sql_partitioning", "__dftl_partition_content_type");
    }

    public int getPosition() {
        return this._pos;
    }

    public int nextToken(int start, int bound) {
        int pos = this.scanForward(start, bound, this._nonWSDefaultPart);
        if (pos == -1) {
            return -1;
        }
        ++this._pos;
        if (Character.isJavaIdentifierPart(this._char)) {
            String identOrKeyword;
            int from = pos;
            int to = (pos = this.scanForward(pos + 1, bound, this._nonIdent)) == -1 ? (bound == -2 ? this._document.getLength() : bound) : pos;
            try {
                identOrKeyword = this._document.get(from, to - from);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            return this.getToken(identOrKeyword);
        }
        return 0;
    }

    public int previousToken(int start, int bound) {
        int pos = this.scanBackward(start, bound, this._nonWSDefaultPart);
        if (pos == -1) {
            return -1;
        }
        --this._pos;
        if (Character.isJavaIdentifierPart(this._char)) {
            String identOrKeyword;
            int to = pos + 1;
            int from = (pos = this.scanBackward(pos - 1, bound, this._nonIdent)) == -1 ? (bound == -2 ? 0 : bound + 1) : pos + 1;
            try {
                identOrKeyword = this._document.get(from, to - from);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            return this.getToken(identOrKeyword);
        }
        return 0;
    }

    private int getToken(String s) {
        Assert.isNotNull((Object)s);
        switch (s.length()) {
            case 3: {
                if ("end".equals(s)) {
                    return 1002;
                }
                if ("END".equalsIgnoreCase(s)) {
                    return 1003;
                }
            }
            case 5: {
                if ("begin".equals(s)) {
                    return 1000;
                }
                if (!"BEGIN".equalsIgnoreCase(s)) break;
                return 1001;
            }
        }
        return 0;
    }

    public int findNonWhitespaceForward(int position, int bound) {
        return this.scanForward(position, bound, this._nonWSDefaultPart);
    }

    public int findNonWhitespaceForwardInAnyPartition(int position, int bound) {
        return this.scanForward(position, bound, _nonWS);
    }

    public int findNonWhitespaceBackward(int position, int bound) {
        return this.scanBackward(position, bound, this._nonWSDefaultPart);
    }

    public int scanForward(int start, int bound, StopCondition condition) {
        Assert.isTrue((start >= 0 ? 1 : 0) != 0);
        if (bound == -2) {
            bound = this._document.getLength();
        }
        Assert.isTrue((bound <= this._document.getLength() ? 1 : 0) != 0);
        try {
            this._pos = start;
            while (this._pos < bound) {
                this._char = this._document.getChar(this._pos);
                if (condition.stop(this._char, this._pos, true)) {
                    return this._pos;
                }
                ++this._pos;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int scanForward(int position, int bound, char ch) {
        return this.scanForward(position, bound, new CharacterMatch(ch));
    }

    public int scanForward(int position, int bound, char[] chars) {
        return this.scanForward(position, bound, new CharacterMatch(chars));
    }

    public int scanBackward(int start, int bound, StopCondition condition) {
        if (bound == -2) {
            bound = -1;
        }
        Assert.isTrue((bound >= -1 ? 1 : 0) != 0);
        Assert.isTrue((start < this._document.getLength() ? 1 : 0) != 0);
        try {
            this._pos = start;
            while (this._pos > bound) {
                this._char = this._document.getChar(this._pos);
                if (condition.stop(this._char, this._pos, false)) {
                    return this._pos;
                }
                --this._pos;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int scanBackward(int position, int bound, char ch) {
        return this.scanBackward(position, bound, new CharacterMatch(ch));
    }

    public int scanBackward(int position, int bound, char[] chars) {
        return this.scanBackward(position, bound, new CharacterMatch(chars));
    }

    public boolean isDefaultPartition(int position) {
        Assert.isTrue((position >= 0 ? 1 : 0) != 0);
        Assert.isTrue((position <= this._document.getLength() ? 1 : 0) != 0);
        try {
            ITypedRegion region = TextUtilities.getPartition((IDocument)this._document, (String)this._partitioning, (int)position, (boolean)false);
            return region.getType().equals(this._partition);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public int findOpeningPeer(int start, int openingPeer, int closingPeer) {
        Assert.isTrue((start < this._document.getLength() ? 1 : 0) != 0);
        int depth = 1;
        int token = -1;
        int offset = ++start;
        do {
            token = this.previousToken(offset, -2);
            offset = this.getPosition();
            if (token == -1) {
                return -1;
            }
            if (this.isSameToken(token, closingPeer)) {
                ++depth;
                continue;
            }
            if (!this.isSameToken(token, openingPeer)) continue;
            --depth;
        } while (depth != 0);
        if (offset == -1) {
            return 0;
        }
        return offset;
    }

    public int findClosingPeer(int start, int openingPeer, int closingPeer) {
        Assert.isTrue((start <= this._document.getLength() ? 1 : 0) != 0);
        int depth = 1;
        int token = -1;
        int offset = ++start;
        do {
            token = this.nextToken(offset, this._document.getLength());
            offset = this.getPosition();
            if (token == -1) {
                return -1;
            }
            if (this.isSameToken(token, openingPeer)) {
                ++depth;
                continue;
            }
            if (!this.isSameToken(token, closingPeer)) continue;
            --depth;
        } while (depth != 0);
        return offset;
    }

    private String getTokenName(int token) {
        switch (token) {
            case 1001: {
                return "BEGIN";
            }
            case 1000: {
                return "begin";
            }
            case 1003: {
                return "END ";
            }
            case 1002: {
                return "end ";
            }
        }
        return null;
    }

    public boolean isSameToken(int firstToken, int secondToken) {
        String firstTokenName = this.getTokenName(firstToken);
        String secondTokenName = this.getTokenName(secondToken);
        return firstTokenName != null && firstTokenName.equalsIgnoreCase(secondTokenName);
    }

    private class CharacterMatch
    implements StopCondition {
        private final char[] _chars;

        public CharacterMatch(char ch) {
            this(new char[]{ch});
        }

        public CharacterMatch(char[] chars) {
            Assert.isNotNull((Object)chars);
            Assert.isTrue((chars.length > 0 ? 1 : 0) != 0);
            this._chars = chars;
            Arrays.sort(chars);
        }

        public boolean stop(char ch, int position, boolean forward) {
            return Arrays.binarySearch(this._chars, ch) >= 0 && SQLHeuristicScanner.this.isDefaultPartition(position);
        }
    }

    private static class NonSQLIdentifierPart
    implements StopCondition {
        private NonSQLIdentifierPart() {
        }

        public boolean stop(char ch, int position, boolean forward) {
            return !Character.isJavaIdentifierPart(ch);
        }
    }

    private class NonSQLIdentifierPartDefaultPartition
    extends NonSQLIdentifierPart {
        private NonSQLIdentifierPartDefaultPartition() {
        }

        public boolean stop(char ch, int position, boolean forward) {
            return super.stop(ch, position, true) || !SQLHeuristicScanner.this.isDefaultPartition(position);
        }
    }

    private static class NonWhitespace
    implements StopCondition {
        private NonWhitespace() {
        }

        public boolean stop(char ch, int position, boolean forward) {
            return !Character.isWhitespace(ch);
        }

        /* synthetic */ NonWhitespace(NonWhitespace nonWhitespace, NonWhitespace nonWhitespace2) {
            this();
        }
    }

    private class NonWhitespaceDefaultPartition
    extends NonWhitespace {
        private NonWhitespaceDefaultPartition() {
            super(null, null);
        }

        public boolean stop(char ch, int position, boolean forward) {
            return super.stop(ch, position, true) && SQLHeuristicScanner.this.isDefaultPartition(position);
        }
    }

    protected class SkippingScopeMatch
    extends CharacterMatch {
        private char _opening;
        private char _closing;
        private int _depth;

        public SkippingScopeMatch(char ch) {
            super(ch);
            this._depth = 0;
        }

        public SkippingScopeMatch(char[] chars) {
            super(chars);
            this._depth = 0;
        }

        public boolean stop(char ch, int position, boolean forward) {
            if (this._depth == 0 && super.stop(ch, position, true)) {
                return true;
            }
            if (ch == this._opening) {
                ++this._depth;
            } else if (ch == this._closing) {
                --this._depth;
                if (this._depth == 0) {
                    this._opening = '\u0000';
                    this._closing = '\u0000';
                }
            } else if (this._depth == 0) {
                this._depth = 1;
            }
            return false;
        }
    }
}

