/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.internal.ui.drivers;

import java.io.File;
import org.eclipse.datatools.enablement.ibm.internal.ui.drivers.IIBMJDBCDriverProvider;
import org.eclipse.datatools.enablement.ibm.internal.ui.drivers.Messages;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class IBMJDBCDriverTracingOptionsPane
extends Composite
implements Listener {
    private Button disableTracingCheckbox;
    private Label traceDirectoryLabel;
    private Text traceDirectoryText;
    private Button browseDirectory;
    private Label traceFileLabel;
    private Text traceFileText;
    private Button appendCheckbox;
    private Group traceLevelGroup;
    private Button connectionCallsCheckbox;
    private Button statementCallsCheckbox;
    private Button resultSetCallsCheckbox;
    private Button driverConfigurationCheckbox;
    private Button connectsCheckbox;
    private Button drdaFlowsCheckbox;
    private Button resultsetMetadataCheckbox;
    private Button parameterMetadataCheckbox;
    private Button diagnosticsCheckbox;
    private Button sqlJCheckbox;
    private Button xaCallsCheckbox;
    private Button allButton;
    private Button noneButton;
    private IIBMJDBCDriverProvider parentDriverProvider;
    private static final String TRACE_DIRECTORY_PROPERTY_NAME = "traceDirectory";
    private static final String TRACE_FILE_PROPERTY_NAME = "traceFile";
    private static final String TRACE_FILE_APPEND_PROPERTY_NAME = "traceFileAppend";
    private static final String TRACE_LEVEL_PROPERTY_NAME = "traceLevel";
    private static final String TRACE_FILE_APPEND_FALSE_PROPERTY_VALUE = "false";
    private static final String TRACE_FILE_APPEND_TRUE_PROPERTY_VALUE = "true";
    private static final String TRACE_LEVEL_TRACE_NONE_PROPERTY_VALUE = "0";
    private static final String CUI_NEWCW_DISABLE_TRACING_CHECKBOX_UI_ = Messages.getString("CUI_NEWCW_DISABLE_TRACING_CHECKBOX_UI_");
    private static final String CUI_NEWCW_TRACE_DIRECTORY_LABEL_UI_ = Messages.getString("CUI_NEWCW_TRACE_DIRECTORY_LABEL_UI_");
    private static final String CUI_NEWCW_TRACE_DIRECTORY_BROWSE_BUTTON_UI_ = Messages.getString("CUI_NEWCW_TRACE_DIRECTORY_BROWSE_BUTTON_UI_");
    private static final String CUI_NEWCW_TRACE_FILE_LABEL_UI_ = Messages.getString("CUI_NEWCW_TRACE_FILE_LABEL_UI_");
    private static final String CUI_NEWCW_DEFAULT_TRACE_FILE_NAME_UI_ = Messages.getString("CUI_NEWCW_DEFAULT_TRACE_FILE_NAME_UI_");
    private static final String CUI_NEWCW_APPEND_CHECKBOX_UI_ = Messages.getString("CUI_NEWCW_APPEND_CHECKBOX_UI_");
    private static final String CUI_NEWCW_TRACE_LEVELS_GROUPBOX_UI_ = Messages.getString("CUI_NEWCW_TRACE_LEVELS_GROUPBOX_UI_");
    private static final String CUI_NEWCW_CONNECTION_CALLS_CHECKBOX_UI_ = Messages.getString("CUI_NEWCW_CONNECTION_CALLS_CHECKBOX_UI_");
    private static final String CUI_NEWCW_STATEMENT_CALLS_CHECKBOX_UI_ = Messages.getString("CUI_NEWCW_STATEMENT_CALLS_CHECKBOX_UI_");
    private static final String CUI_NEWCW_RESULT_SET_CALLS_CHECKBOX_UI_ = Messages.getString("CUI_NEWCW_RESULT_SET_CALLS_CHECKBOX_UI_");
    private static final String CUI_NEWCW_DRIVER_CONFIGURATION_CHECKBOX_UI_ = Messages.getString("CUI_NEWCW_DRIVER_CONFIGURATION_CHECKBOX_UI_");
    private static final String CUI_NEWCW_CONNECTS_CHECKBOX_UI_ = Messages.getString("CUI_NEWCW_CONNECTS_CHECKBOX_UI_");
    private static final String CUI_NEWCW_DRDA_FLOWS_CHECKBOX_UI_ = Messages.getString("CUI_NEWCW_DRDA_FLOWS_CHECKBOX_UI_");
    private static final String CUI_NEWCW_RESULT_SET_METADATA_CHECKBOX_UI_ = Messages.getString("CUI_NEWCW_RESULT_SET_METADATA_CHECKBOX_UI_");
    private static final String CUI_NEWCW_PARAMETER_METADATA_CHECKBOX_UI_ = Messages.getString("CUI_NEWCW_PARAMETER_METADATA_CHECKBOX_UI_");
    private static final String CUI_NEWCW_DIAGNOSTICS_CHECKBOX_UI_ = Messages.getString("CUI_NEWCW_DIAGNOSTICS_CHECKBOX_UI_");
    private static final String CUI_NEWCW_SQLJ_CHECKBOX_UI_ = Messages.getString("CUI_NEWCW_SQLJ_CHECKBOX_UI_");
    private static final String CUI_NEWCW_XA_CALLS_CHECKBOX_UI_ = Messages.getString("CUI_NEWCW_XA_CALLS_CHECKBOX_UI_");
    private static final String CUI_NEWCW_SELECT_ALL_BUTTON_UI_ = Messages.getString("CUI_NEWCW_SELECT_ALL_BUTTON_UI_");
    private static final String CUI_NEWCW_DESELECT_ALL_BUTTON_UI_ = Messages.getString("CUI_NEWCW_DESELECT_ALL_BUTTON_UI_");
    private static final String CUI_NEWCW_ENTER_DIRECTORY_MESSAGE_UI_ = Messages.getString("CUI_NEWCW_ENTER_DIRECTORY_MESSAGE_UI_");
    private static final String CUI_NEWCW_ENTER_VALID_DIRECTORY_MESSAGE_UI_ = Messages.getString("CUI_NEWCW_ENTER_VALID_DIRECTORY_MESSAGE_UI_");
    private static final String CUI_NEWCW_ENTER_FILE_MESSAGE_UI_ = Messages.getString("CUI_NEWCW_ENTER_FILE_MESSAGE_UI_");
    private static final String CUI_NEWCW_SELECT_TRACE_LEVEL_MESSAGE_UI_ = Messages.getString("CUI_NEWCW_SELECT_TRACE_LEVEL_MESSAGE_UI_");
    private boolean isReadOnly = false;

    public IBMJDBCDriverTracingOptionsPane(Composite parent, int style, IIBMJDBCDriverProvider parentDriverProvider, boolean isReadOnly) {
        super(parent, style);
        this.parentDriverProvider = parentDriverProvider;
        IBMJDBCDriverTracingOptionsPane parentComposite = this;
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        parentComposite.setLayout((Layout)layout);
        this.isReadOnly = isReadOnly;
        int additionalStyles = 0;
        if (isReadOnly) {
            additionalStyles = 8;
        }
        this.disableTracingCheckbox = new Button((Composite)parentComposite, 32);
        this.disableTracingCheckbox.setText(CUI_NEWCW_DISABLE_TRACING_CHECKBOX_UI_);
        this.disableTracingCheckbox.setSelection(true);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        this.disableTracingCheckbox.setLayoutData((Object)gd);
        this.traceDirectoryLabel = new Label((Composite)parentComposite, 0);
        this.traceDirectoryLabel.setText(CUI_NEWCW_TRACE_DIRECTORY_LABEL_UI_);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.traceDirectoryLabel.setLayoutData((Object)gd);
        this.traceDirectoryText = new Text((Composite)parentComposite, 0x804 | additionalStyles);
        gd = new GridData();
        gd.widthHint = 180;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.traceDirectoryText.setLayoutData((Object)gd);
        this.browseDirectory = new Button((Composite)parentComposite, 8);
        this.browseDirectory.setText(CUI_NEWCW_TRACE_DIRECTORY_BROWSE_BUTTON_UI_);
        this.browseDirectory.setEnabled(!isReadOnly);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.browseDirectory.setLayoutData((Object)gd);
        this.traceFileLabel = new Label((Composite)parentComposite, 0);
        this.traceFileLabel.setText(CUI_NEWCW_TRACE_FILE_LABEL_UI_);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.traceFileLabel.setLayoutData((Object)gd);
        this.traceFileText = new Text((Composite)parentComposite, 0x804 | additionalStyles);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.traceFileText.setLayoutData((Object)gd);
        this.traceFileText.setText(CUI_NEWCW_DEFAULT_TRACE_FILE_NAME_UI_);
        this.appendCheckbox = new Button((Composite)parentComposite, 32);
        this.appendCheckbox.setText(CUI_NEWCW_APPEND_CHECKBOX_UI_);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        this.appendCheckbox.setLayoutData((Object)gd);
        this.traceLevelGroup = new Group((Composite)parentComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        this.traceLevelGroup.setLayout((Layout)layout);
        this.traceLevelGroup.setText(CUI_NEWCW_TRACE_LEVELS_GROUPBOX_UI_);
        this.traceLevelGroup.setEnabled(false);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 3;
        this.traceLevelGroup.setLayoutData((Object)gd);
        this.connectionCallsCheckbox = new Button((Composite)this.traceLevelGroup, 32);
        this.connectionCallsCheckbox.setText(CUI_NEWCW_CONNECTION_CALLS_CHECKBOX_UI_);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.connectionCallsCheckbox.setLayoutData((Object)gd);
        this.statementCallsCheckbox = new Button((Composite)this.traceLevelGroup, 32);
        this.statementCallsCheckbox.setText(CUI_NEWCW_STATEMENT_CALLS_CHECKBOX_UI_);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.statementCallsCheckbox.setLayoutData((Object)gd);
        this.resultSetCallsCheckbox = new Button((Composite)this.traceLevelGroup, 32);
        this.resultSetCallsCheckbox.setText(CUI_NEWCW_RESULT_SET_CALLS_CHECKBOX_UI_);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.resultSetCallsCheckbox.setLayoutData((Object)gd);
        this.driverConfigurationCheckbox = new Button((Composite)this.traceLevelGroup, 32);
        this.driverConfigurationCheckbox.setText(CUI_NEWCW_DRIVER_CONFIGURATION_CHECKBOX_UI_);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.driverConfigurationCheckbox.setLayoutData((Object)gd);
        this.connectsCheckbox = new Button((Composite)this.traceLevelGroup, 32);
        this.connectsCheckbox.setText(CUI_NEWCW_CONNECTS_CHECKBOX_UI_);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.connectsCheckbox.setLayoutData((Object)gd);
        this.drdaFlowsCheckbox = new Button((Composite)this.traceLevelGroup, 32);
        this.drdaFlowsCheckbox.setText(CUI_NEWCW_DRDA_FLOWS_CHECKBOX_UI_);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.drdaFlowsCheckbox.setLayoutData((Object)gd);
        this.resultsetMetadataCheckbox = new Button((Composite)this.traceLevelGroup, 32);
        this.resultsetMetadataCheckbox.setText(CUI_NEWCW_RESULT_SET_METADATA_CHECKBOX_UI_);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.resultsetMetadataCheckbox.setLayoutData((Object)gd);
        this.parameterMetadataCheckbox = new Button((Composite)this.traceLevelGroup, 32);
        this.parameterMetadataCheckbox.setText(CUI_NEWCW_PARAMETER_METADATA_CHECKBOX_UI_);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.parameterMetadataCheckbox.setLayoutData((Object)gd);
        this.diagnosticsCheckbox = new Button((Composite)this.traceLevelGroup, 32);
        this.diagnosticsCheckbox.setText(CUI_NEWCW_DIAGNOSTICS_CHECKBOX_UI_);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.diagnosticsCheckbox.setLayoutData((Object)gd);
        this.sqlJCheckbox = new Button((Composite)this.traceLevelGroup, 32);
        this.sqlJCheckbox.setText(CUI_NEWCW_SQLJ_CHECKBOX_UI_);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.sqlJCheckbox.setLayoutData((Object)gd);
        this.xaCallsCheckbox = new Button((Composite)this.traceLevelGroup, 32);
        this.xaCallsCheckbox.setText(CUI_NEWCW_XA_CALLS_CHECKBOX_UI_);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        this.xaCallsCheckbox.setLayoutData((Object)gd);
        this.allButton = new Button((Composite)this.traceLevelGroup, 0);
        this.allButton.setEnabled(!isReadOnly);
        this.allButton.setLayoutData((Object)new GridData(258));
        this.allButton.setText(CUI_NEWCW_SELECT_ALL_BUTTON_UI_);
        this.noneButton = new Button((Composite)this.traceLevelGroup, 0);
        this.noneButton.setEnabled(!isReadOnly);
        this.noneButton.setLayoutData((Object)new GridData(258));
        this.noneButton.setText(CUI_NEWCW_DESELECT_ALL_BUTTON_UI_);
        this.restoreDefaultSettings();
        this.enableTracingUI(false);
        this.addListeners();
    }

    private void enableTracingUI(boolean enable) {
        this.traceDirectoryLabel.setEnabled(enable);
        this.traceDirectoryText.setEnabled(enable);
        this.traceFileLabel.setEnabled(enable);
        this.traceFileText.setEnabled(enable);
        this.appendCheckbox.setEnabled(enable);
        this.traceLevelGroup.setEnabled(enable);
        this.connectionCallsCheckbox.setEnabled(enable);
        this.statementCallsCheckbox.setEnabled(enable);
        this.resultSetCallsCheckbox.setEnabled(enable);
        this.driverConfigurationCheckbox.setEnabled(enable);
        this.connectsCheckbox.setEnabled(enable);
        this.drdaFlowsCheckbox.setEnabled(enable);
        this.resultsetMetadataCheckbox.setEnabled(enable);
        this.parameterMetadataCheckbox.setEnabled(enable);
        this.diagnosticsCheckbox.setEnabled(enable);
        this.sqlJCheckbox.setEnabled(enable);
        this.xaCallsCheckbox.setEnabled(enable);
        if (!this.isReadOnly) {
            this.browseDirectory.setEnabled(enable);
            this.allButton.setEnabled(enable);
            this.noneButton.setEnabled(enable);
        }
    }

    private void addListeners() {
        this.disableTracingCheckbox.addListener(13, (Listener)this);
        this.traceDirectoryText.addListener(24, (Listener)this);
        this.browseDirectory.addListener(13, (Listener)this);
        this.traceFileText.addListener(24, (Listener)this);
        this.appendCheckbox.addListener(13, (Listener)this);
        this.connectionCallsCheckbox.addListener(13, (Listener)this);
        this.statementCallsCheckbox.addListener(13, (Listener)this);
        this.resultSetCallsCheckbox.addListener(13, (Listener)this);
        this.driverConfigurationCheckbox.addListener(13, (Listener)this);
        this.connectsCheckbox.addListener(13, (Listener)this);
        this.drdaFlowsCheckbox.addListener(13, (Listener)this);
        this.resultsetMetadataCheckbox.addListener(13, (Listener)this);
        this.parameterMetadataCheckbox.addListener(13, (Listener)this);
        this.diagnosticsCheckbox.addListener(13, (Listener)this);
        this.sqlJCheckbox.addListener(13, (Listener)this);
        this.xaCallsCheckbox.addListener(13, (Listener)this);
        this.allButton.addListener(13, (Listener)this);
        this.noneButton.addListener(13, (Listener)this);
    }

    private void removeListeners() {
        this.disableTracingCheckbox.removeListener(13, (Listener)this);
        this.traceDirectoryText.removeListener(24, (Listener)this);
        this.browseDirectory.removeListener(13, (Listener)this);
        this.traceFileText.removeListener(24, (Listener)this);
        this.appendCheckbox.removeListener(13, (Listener)this);
        this.connectionCallsCheckbox.removeListener(13, (Listener)this);
        this.statementCallsCheckbox.removeListener(13, (Listener)this);
        this.resultSetCallsCheckbox.removeListener(13, (Listener)this);
        this.driverConfigurationCheckbox.removeListener(13, (Listener)this);
        this.connectsCheckbox.removeListener(13, (Listener)this);
        this.drdaFlowsCheckbox.removeListener(13, (Listener)this);
        this.resultsetMetadataCheckbox.removeListener(13, (Listener)this);
        this.parameterMetadataCheckbox.removeListener(13, (Listener)this);
        this.diagnosticsCheckbox.removeListener(13, (Listener)this);
        this.sqlJCheckbox.removeListener(13, (Listener)this);
        this.xaCallsCheckbox.removeListener(13, (Listener)this);
        this.allButton.removeListener(13, (Listener)this);
        this.noneButton.removeListener(13, (Listener)this);
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (this.isReadOnly) {
            if (source == this.disableTracingCheckbox || source == this.appendCheckbox || source == this.connectionCallsCheckbox || source == this.statementCallsCheckbox || source == this.resultSetCallsCheckbox || source == this.driverConfigurationCheckbox || source == this.connectsCheckbox || source == this.drdaFlowsCheckbox || source == this.resultsetMetadataCheckbox || source == this.parameterMetadataCheckbox || source == this.diagnosticsCheckbox || source == this.sqlJCheckbox || source == this.xaCallsCheckbox) {
                ((Button)source).setSelection(!((Button)source).getSelection());
            }
        } else {
            if (source == this.disableTracingCheckbox) {
                this.enableTracingUI(!this.disableTracingCheckbox.getSelection());
            } else if (source == this.allButton) {
                this.setAllLevelsChecked(true);
            } else if (source == this.noneButton) {
                this.setAllLevelsChecked(false);
            } else if (source == this.browseDirectory) {
                DirectoryDialog dialog = new DirectoryDialog(this.browseDirectory.getShell(), 4096);
                dialog.setFilterPath(this.traceDirectoryText.getText().trim());
                String directory = dialog.open();
                if (directory != null) {
                    this.traceDirectoryText.setText(directory);
                }
            }
            this.parentDriverProvider.updateURL();
            this.parentDriverProvider.setConnectionInformation();
        }
    }

    private void setAllLevelsChecked(boolean check) {
        this.connectionCallsCheckbox.setSelection(check);
        this.statementCallsCheckbox.setSelection(check);
        this.resultSetCallsCheckbox.setSelection(check);
        this.driverConfigurationCheckbox.setSelection(check);
        this.connectsCheckbox.setSelection(check);
        this.drdaFlowsCheckbox.setSelection(check);
        this.resultsetMetadataCheckbox.setSelection(check);
        this.parameterMetadataCheckbox.setSelection(check);
        this.diagnosticsCheckbox.setSelection(check);
        this.sqlJCheckbox.setSelection(check);
        this.xaCallsCheckbox.setSelection(check);
    }

    public boolean validateControl(DialogPage page) {
        boolean isValid = true;
        if (!this.disableTracingCheckbox.getSelection()) {
            if (this.traceDirectoryText.getText() == null || this.traceDirectoryText.getText().trim().length() < 1) {
                page.setErrorMessage(CUI_NEWCW_ENTER_DIRECTORY_MESSAGE_UI_);
                isValid = false;
            } else if (!this.isDirectoryValid(this.traceDirectoryText.getText().trim())) {
                page.setErrorMessage(CUI_NEWCW_ENTER_VALID_DIRECTORY_MESSAGE_UI_);
                isValid = false;
            } else if (this.traceFileText.getText() == null || this.traceFileText.getText().trim().length() < 1) {
                page.setErrorMessage(CUI_NEWCW_ENTER_FILE_MESSAGE_UI_);
                isValid = false;
            } else if (!this.isTraceLevelSelected()) {
                page.setErrorMessage(CUI_NEWCW_SELECT_TRACE_LEVEL_MESSAGE_UI_);
                isValid = false;
            }
        }
        return isValid;
    }

    private boolean isDirectoryValid(String directory) {
        boolean isDirectoryValid = false;
        File file = new File(directory);
        if (file.exists() && file.isDirectory()) {
            isDirectoryValid = true;
        }
        return isDirectoryValid;
    }

    public boolean isTraceLevelSelected() {
        boolean isSelected = false;
        if (!this.getTraceLevel().equals(TRACE_LEVEL_TRACE_NONE_PROPERTY_VALUE)) {
            isSelected = true;
        }
        return isSelected;
    }

    public String getTracingURLProperties() {
        String properties = "";
        if (!this.disableTracingCheckbox.getSelection()) {
            String traceDirectory = this.traceDirectoryText.getText().trim();
            String traceFile = this.traceFileText.getText().trim();
            String append = this.appendCheckbox.getSelection() ? TRACE_FILE_APPEND_TRUE_PROPERTY_VALUE : TRACE_FILE_APPEND_FALSE_PROPERTY_VALUE;
            String traceLevel = this.getTraceLevel();
            properties = "traceFile=" + traceFile + ";" + TRACE_FILE_APPEND_PROPERTY_NAME + "=" + append + ";" + TRACE_LEVEL_PROPERTY_NAME + "=" + traceLevel + ";" + TRACE_DIRECTORY_PROPERTY_NAME + "=" + traceDirectory + ";";
        }
        return properties;
    }

    private String getTraceLevel() {
        String traceLevelString = TRACE_LEVEL_TRACE_NONE_PROPERTY_VALUE;
        int traceLevel = 0;
        if (this.connectionCallsCheckbox.getSelection()) {
            ++traceLevel;
        }
        if (this.statementCallsCheckbox.getSelection()) {
            traceLevel += 2;
        }
        if (this.resultSetCallsCheckbox.getSelection()) {
            traceLevel += 4;
        }
        if (this.driverConfigurationCheckbox.getSelection()) {
            traceLevel += 16;
        }
        if (this.connectsCheckbox.getSelection()) {
            traceLevel += 32;
        }
        if (this.drdaFlowsCheckbox.getSelection()) {
            traceLevel += 64;
        }
        if (this.resultsetMetadataCheckbox.getSelection()) {
            traceLevel += 128;
        }
        if (this.parameterMetadataCheckbox.getSelection()) {
            traceLevel += 256;
        }
        if (this.diagnosticsCheckbox.getSelection()) {
            traceLevel += 512;
        }
        if (this.sqlJCheckbox.getSelection()) {
            traceLevel += 1024;
        }
        if (this.xaCallsCheckbox.getSelection()) {
            traceLevel += 2048;
        }
        if (traceLevel == 4087) {
            traceLevel = -1;
        }
        traceLevelString = Integer.toString(traceLevel);
        return traceLevelString;
    }

    private void setTraceLevel(String traceLevelString) {
        int traceLevel = Integer.parseInt(traceLevelString);
        if (traceLevel == -1) {
            this.setAllLevelsChecked(true);
        } else {
            this.connectionCallsCheckbox.setSelection((traceLevel & 1) != 0);
            this.statementCallsCheckbox.setSelection((traceLevel & 2) != 0);
            this.resultSetCallsCheckbox.setSelection((traceLevel & 4) != 0);
            this.driverConfigurationCheckbox.setSelection((traceLevel & 0x10) != 0);
            this.connectsCheckbox.setSelection((traceLevel & 0x20) != 0);
            this.drdaFlowsCheckbox.setSelection((traceLevel & 0x40) != 0);
            this.resultsetMetadataCheckbox.setSelection((traceLevel & 0x80) != 0);
            this.parameterMetadataCheckbox.setSelection((traceLevel & 0x100) != 0);
            this.diagnosticsCheckbox.setSelection((traceLevel & 0x200) != 0);
            this.sqlJCheckbox.setSelection((traceLevel & 0x400) != 0);
            this.xaCallsCheckbox.setSelection((traceLevel & 0x800) != 0);
        }
    }

    public void loadProperties(String properties) {
        this.removeListeners();
        URLPropertiesParser propertyParser = new URLPropertiesParser(properties);
        if (propertyParser.isTracingEnabled()) {
            this.disableTracingCheckbox.setSelection(false);
            this.enableTracingUI(true);
            this.traceDirectoryText.setText(propertyParser.getTraceDirectory());
            this.traceFileText.setText(propertyParser.getTraceFile());
            this.appendCheckbox.setSelection(propertyParser.getTraceFileAppend().equals(TRACE_FILE_APPEND_TRUE_PROPERTY_VALUE));
            this.setTraceLevel(propertyParser.getTraceLevel());
        } else {
            this.disableTracingCheckbox.setSelection(true);
            this.enableTracingUI(false);
            this.traceDirectoryText.setText("");
            this.traceFileText.setText("");
            this.restoreDefaultSettings();
        }
        this.addListeners();
    }

    private void restoreDefaultSettings() {
        this.setAllLevelsChecked(false);
        this.connectionCallsCheckbox.setSelection(true);
        this.traceDirectoryText.setText(System.getProperty("user.home"));
        this.traceFileText.setText(CUI_NEWCW_DEFAULT_TRACE_FILE_NAME_UI_);
    }

    private class URLPropertiesParser {
        private String properties = "";

        public URLPropertiesParser(String properties) {
            this.properties = properties;
        }

        public String getTraceDirectory() {
            String traceDirectory = "";
            int beginningIndex = this.properties.lastIndexOf(IBMJDBCDriverTracingOptionsPane.TRACE_DIRECTORY_PROPERTY_NAME) + IBMJDBCDriverTracingOptionsPane.TRACE_DIRECTORY_PROPERTY_NAME.length() + 1;
            int endingIndex = this.properties.indexOf(";", beginningIndex);
            traceDirectory = this.properties.substring(beginningIndex, endingIndex);
            return traceDirectory;
        }

        public String getTraceFile() {
            String traceFile = "";
            int beginningIndex = this.properties.lastIndexOf("traceFile=") + IBMJDBCDriverTracingOptionsPane.TRACE_FILE_PROPERTY_NAME.length() + 1;
            int endingIndex = this.properties.indexOf(";", beginningIndex);
            traceFile = this.properties.substring(beginningIndex, endingIndex);
            return traceFile;
        }

        public String getTraceFileAppend() {
            String traceFile = "";
            int beginningIndex = this.properties.lastIndexOf(IBMJDBCDriverTracingOptionsPane.TRACE_FILE_APPEND_PROPERTY_NAME) + IBMJDBCDriverTracingOptionsPane.TRACE_FILE_APPEND_PROPERTY_NAME.length() + 1;
            int endingIndex = this.properties.indexOf(";", beginningIndex);
            traceFile = this.properties.substring(beginningIndex, endingIndex);
            return traceFile;
        }

        public String getTraceLevel() {
            String traceLevel = "";
            int beginningIndex = this.properties.lastIndexOf(IBMJDBCDriverTracingOptionsPane.TRACE_LEVEL_PROPERTY_NAME) + IBMJDBCDriverTracingOptionsPane.TRACE_LEVEL_PROPERTY_NAME.length() + 1;
            int endingIndex = this.properties.indexOf(";", beginningIndex);
            traceLevel = this.properties.substring(beginningIndex, endingIndex);
            return traceLevel;
        }

        public boolean isTracingEnabled() {
            boolean isTracingEnabled = false;
            if (this.properties.indexOf(IBMJDBCDriverTracingOptionsPane.TRACE_LEVEL_PROPERTY_NAME) >= 0) {
                isTracingEnabled = true;
            }
            return isTracingEnabled;
        }
    }
}

