/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.ui.explorer.providers.content.virtual;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.providers.content.virtual.ICreationInfoProvider;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;

public class CreationInfoRegistry {
    public static CreationInfoRegistry INSTANCE = new CreationInfoRegistry();
    private Map providers = new HashMap();
    private ICreationInfoProvider nullProvider = new ICreationInfoProvider(){

        public boolean isCreateActionSupported(IVirtualNode virtualNode) {
            return true;
        }

        public boolean isCreateDistinctType() {
            return true;
        }

        public boolean isCreateRowTypeSupported() {
            return true;
        }
    };

    public ICreationInfoProvider getProvider(DatabaseDefinition definition) {
        if (!this.providers.containsKey(definition)) {
            this.providers.put(definition, this.loadProvider(definition));
        }
        return (ICreationInfoProvider)this.providers.get(definition);
    }

    private Object loadProvider(DatabaseDefinition def) {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.sqm.core.ui", "creationInfoProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String version;
                String product;
                if (configElements[j].getName().equals("provider") && (product = configElements[j].getAttribute("product")).equals(def.getProduct()) && (version = configElements[j].getAttribute("version")).equals(def.getVersion())) {
                    try {
                        return (ICreationInfoProvider)configElements[j].createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++j;
            }
            ++i;
        }
        return this.nullProvider;
    }
}

