/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.source;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.IDBContext;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLCompletionEngine;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLCompletionProposalFactory;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLEditorDocumentProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class SQLCompletionProcessor
implements IContentAssistProcessor {
    private char[] fProposalAutoActivationSet;
    protected IContextInformationValidator fValidator = new Validator();
    private IDBContext fDBContext = null;
    private SQLCompletionEngine fCompletionEngine = null;
    private SQLCompletionProposalFactory fProposalFactory = null;

    public SQLCompletionProcessor() {
        char[] completionChars = new char[]{'.'};
        this.setCompletionProposalAutoActivationCharacters(completionChars);
        this.fCompletionEngine = new SQLCompletionEngine();
        this.fProposalFactory = new SQLCompletionProposalFactory();
    }

    public ICompletionProposal[] computeCompletionProposals(String stmt, int stmtOffset) {
        IDocument doc = null;
        try {
            doc = SQLEditorDocumentProvider.createDocument(stmt);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return this.computeCompletionProposals(doc, stmtOffset);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int docOffset) {
        IDocument doc = viewer.getDocument();
        return this.computeCompletionProposals(doc, docOffset);
    }

    public ICompletionProposal[] computeCompletionProposals(IDocument doc, int docOffset) {
        ICompletionProposal[] proposalArray = null;
        try {
            ITypedRegion partition = null;
            partition = docOffset > 0 ? (doc.getChar(docOffset - 1) == ';' ? doc.getPartition(docOffset) : doc.getPartition(docOffset - 1)) : doc.getPartition(docOffset);
            ICompletionProposal[] dbProposalArray = this.fCompletionEngine.computeDBProposals(doc, partition, docOffset, this.getDBContext());
            ICompletionProposal[] syntaxProposalArray = this.fCompletionEngine.computeSyntaxProposals(doc, partition, docOffset);
            int dbProposalArrayLength = 0;
            if (dbProposalArray != null) {
                dbProposalArrayLength = dbProposalArray.length;
            }
            int syntaxProposalArrayLength = 0;
            if (syntaxProposalArray != null) {
                syntaxProposalArrayLength = syntaxProposalArray.length;
            }
            proposalArray = new ICompletionProposal[dbProposalArrayLength + syntaxProposalArrayLength];
            int proposalArrayIndex = 0;
            int i = 0;
            while (i < dbProposalArrayLength) {
                proposalArray[proposalArrayIndex] = dbProposalArray[i];
                ++proposalArrayIndex;
                ++i;
            }
            i = 0;
            while (i < syntaxProposalArrayLength) {
                proposalArray[proposalArrayIndex] = syntaxProposalArray[i];
                ++proposalArrayIndex;
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        return proposalArray;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int docOffset) {
        IDocument doc = viewer.getDocument();
        return this.computeContextInformation(doc, docOffset);
    }

    public IContextInformation[] computeContextInformation(String stmt, int stmtOffset) {
        IDocument doc = null;
        try {
            doc = SQLEditorDocumentProvider.createDocument(stmt);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return this.computeContextInformation(doc, stmtOffset);
    }

    public IContextInformation[] computeContextInformation(IDocument doc, int docOffset) {
        String partitionId = null;
        String[] proposals = this.fProposalFactory.getStatementTemplateProposals();
        IContextInformation[] result = null;
        ITypedRegion partition = null;
        try {
            partition = docOffset > 0 ? (doc.getChar(docOffset - 1) == ';' ? doc.getPartition(docOffset) : doc.getPartition(docOffset - 1)) : doc.getPartition(docOffset);
            partitionId = partition.getType();
        }
        catch (BadLocationException badLocationException) {}
        if (partitionId == "__sql__select__statement__") {
            result = new IContextInformation[]{new ContextInformation("e.g.", "e.g.: " + proposals[0])};
        } else if (partitionId == "__sql__insert__statement__") {
            result = new IContextInformation[]{new ContextInformation("e.g.", "e.g.: " + proposals[1])};
        } else if (partitionId == "__sql__update__statement__") {
            result = new IContextInformation[]{new ContextInformation("e.g.", "e.g.: " + proposals[2])};
        } else if (partitionId == "__sql__delete__statement__") {
            result = new IContextInformation[]{new ContextInformation("e.g.", "e.g.: " + proposals[3])};
        } else if (partitionId == "__sql__create__statement__") {
            if (SQLCompletionEngine.showContextInformation(doc, partition, docOffset, "CREATE ")) {
                result = new IContextInformation[]{new ContextInformation("e.g.", "e.g.: " + proposals[5])};
            }
        } else if (partitionId == "__sql__drop__statement__") {
            if (SQLCompletionEngine.showContextInformation(doc, partition, docOffset, "DROP ")) {
                result = new IContextInformation[]{new ContextInformation("e.g.", "e.g.: " + proposals[10])};
            }
        } else if (partitionId == "__sql__alter__statement__") {
            if (SQLCompletionEngine.showContextInformation(doc, partition, docOffset, "ALTER ")) {
                result = new IContextInformation[]{new ContextInformation("e.g.", "e.g.: " + proposals[4])};
            }
        } else if (partitionId == "__sql__grant__statement__") {
            if (SQLCompletionEngine.showContextInformation(doc, partition, docOffset, "GRANT ")) {
                result = new IContextInformation[]{new ContextInformation("e.g.", "e.g.: " + proposals[18])};
            }
        } else if (partitionId == "__sql__revoke__statement__") {
            if (SQLCompletionEngine.showContextInformation(doc, partition, docOffset, "REVOKE ")) {
                result = new IContextInformation[]{new ContextInformation("e.g.", "e.g.: " + proposals[19])};
            }
        } else if (partitionId == "__sql__commit__statement__") {
            result = new IContextInformation[]{new ContextInformation("e.g.", "e.g.: " + proposals[15])};
        } else if (partitionId == "__sql__rollback__statement__") {
            result = new IContextInformation[]{new ContextInformation("e.g.", "e.g.: " + proposals[16])};
        } else if (partitionId == "__sql__set__statement__") {
            if (SQLCompletionEngine.showContextInformation(doc, partition, docOffset, "SET ")) {
                result = new IContextInformation[]{new ContextInformation("e.g.", "e.g.: " + proposals[17])};
            }
        } else if (partitionId == "__sql__connect__statement__") {
            result = new IContextInformation[]{new ContextInformation("e.g.", "e.g.: " + proposals[20])};
        } else if (partitionId == "__sql__disconnect__statement__") {
            result = new IContextInformation[]{new ContextInformation("e.g.", "e.g.: " + proposals[21])};
        } else if (partitionId == "__sql__comment__statement__") {
            if (SQLCompletionEngine.showContextInformation(doc, partition, docOffset, "COMMENT ON ")) {
                result = new IContextInformation[]{new ContextInformation("e.g.", "e.g.: " + proposals[24])};
            }
        } else if (partitionId == "__sql__catalog__statement__") {
            result = new IContextInformation[]{new ContextInformation("e.g.", "e.g.: " + proposals[22])};
        } else if (partitionId == "__sql__uncatalog__statement__") {
            result = new IContextInformation[]{new ContextInformation("e.g.", "e.g.: " + proposals[23])};
        } else {
            String[] displayString = this.fProposalFactory.getStatementProposals();
            String[] context = this.fProposalFactory.getContextInformation();
            result = new IContextInformation[context.length];
            int i = 0;
            while (i < context.length) {
                result[i] = new ContextInformation(displayString[i], "e.g.: " + context[i]);
                ++i;
            }
        }
        return result;
    }

    public SQLCompletionEngine getCompletionEngine() {
        return this.fCompletionEngine;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[]{'#'};
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public IDBContext getDBContext() {
        return this.fDBContext;
    }

    public String getErrorMessage() {
        return null;
    }

    public void setCompletionEngine(SQLCompletionEngine completionEngine) {
        this.fCompletionEngine = completionEngine;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    public void setDBContext(IDBContext newDBContext) {
        this.fDBContext = newDBContext;
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int fInstallOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.fInstallOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.fInstallOffset = offset;
        }

        public boolean updatePresentation(int position, TextPresentation presentation) {
            return true;
        }
    }
}

