/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.ManagedConnection;

public class CloseManagedConnectionJob
extends Job {
    private Object mFamily;
    private ManagedConnection mConnection;

    public CloseManagedConnectionJob(ManagedConnection connection, Object family) {
        super(ConnectivityPlugin.getDefault().getResourceString("CloseManagedConnectionJob.name", new Object[]{connection.getConnectionProfile().getProvider().getConnectionFactory(connection.getFactoryID()).getName(), connection.getConnectionProfile().getName()}));
        this.setUser(true);
        this.mConnection = connection;
        this.mFamily = family;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        monitor.beginTask(this.getName(), -1);
        try {
            this.mConnection.close();
        }
        catch (Exception e) {
            status = new Status(4, ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), -1, ConnectivityPlugin.getDefault().getResourceString("CloseManagedConnectionJob.error", new Object[]{this.mConnection.getConnectionProfile().getProvider().getConnectionFactory(this.mConnection.getFactoryID()).getName(), this.mConnection.getConnectionProfile().getName(), e.getMessage()}), (Throwable)e);
        }
        monitor.done();
        return status;
    }

    public boolean belongsTo(Object family) {
        return this.mFamily != null && family == this.mFamily;
    }
}

