/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards;

import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.ui.dse.dialogs.ConnectionDisplayProperty;
import org.eclipse.datatools.connectivity.ui.dse.dialogs.ExistingConnectionProfilesDialogPage;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.util.ResourceLoader;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards.FESpecifyExistingConnectionsWizardPage;
import org.eclipse.swt.widgets.Event;

public class FESpecifyExistingConnectionsDialogPage
extends ExistingConnectionProfilesDialogPage {
    private String allowedVendor = null;
    private String allowedVersion = null;
    private FESpecifyExistingConnectionsWizardPage page;

    public FESpecifyExistingConnectionsDialogPage(FESpecifyExistingConnectionsWizardPage page, boolean isShowProperties, boolean isPropertiesSectionExpanded) {
        super(isShowProperties, isPropertiesSectionExpanded);
        this.page = page;
    }

    public void setAllowedVendor(String allowedVendor) {
        this.allowedVendor = allowedVendor;
        this.initializeValues();
    }

    public void setAllowedVersion(String allowedVersion) {
        this.allowedVersion = allowedVersion;
        this.initializeValues();
    }

    protected ConnectionDisplayProperty[] updateConnectionDisplayProperties(IConnectionProfile connectionProfile, ConnectionDisplayProperty[] defaultDisplayProperties) {
        ConnectionDisplayProperty[] properties = null;
        Vector<ConnectionDisplayProperty> propertiesCollection = new Vector<ConnectionDisplayProperty>();
        propertiesCollection.addAll(Arrays.asList(defaultDisplayProperties));
        Properties baseProperties = connectionProfile.getBaseProperties();
        propertiesCollection.add(new ConnectionDisplayProperty(ResourceLoader.INSTANCE.queryString("FEWizard.SpecifyExistingConnectionPage.databasePropertyName"), (String)baseProperties.get("org.eclipse.datatools.connectivity.db.databaseName")));
        propertiesCollection.add(new ConnectionDisplayProperty(ResourceLoader.INSTANCE.queryString("FEWizard.SpecifyExistingConnectionPage.jdbcDriverClassPropertyName"), (String)baseProperties.get("org.eclipse.datatools.connectivity.db.driverClass")));
        propertiesCollection.add(new ConnectionDisplayProperty(ResourceLoader.INSTANCE.queryString("FEWizard.SpecifyExistingConnectionPage.classLocationPropertyName"), this.getJarList(connectionProfile)));
        propertiesCollection.add(new ConnectionDisplayProperty(ResourceLoader.INSTANCE.queryString("FEWizard.SpecifyExistingConnectionPage.connectionURLPropertyName"), (String)baseProperties.get("org.eclipse.datatools.connectivity.db.URL")));
        propertiesCollection.add(new ConnectionDisplayProperty(ResourceLoader.INSTANCE.queryString("FEWizard.SpecifyExistingConnectionPage.userIDPropertyName"), (String)baseProperties.get("org.eclipse.datatools.connectivity.db.username")));
        properties = new ConnectionDisplayProperty[propertiesCollection.size()];
        propertiesCollection.toArray(properties);
        return properties;
    }

    public void handleEvent(Event event) {
        super.handleEvent(event);
        this.page.handleEvent(event);
    }

    private String getJarList(IConnectionProfile connectionProfile) {
        String jarList = "";
        DriverInstance driverInstance = null;
        String driverID = connectionProfile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
        if (driverID != null && (driverInstance = DriverManager.getInstance().getDriverInstanceByID(driverID)) != null) {
            jarList = driverInstance.getJarList();
        }
        return jarList;
    }

    protected IConnectionProfile[] getConnectionsToDisplay() {
        Vector<IConnectionProfile> filteredProfilesCollection = new Vector<IConnectionProfile>();
        Object[] filteredProfiles = new IConnectionProfile[]{};
        IConnectionProfile[] allProfiles = ProfileManager.getInstance().getProfiles(false);
        int infoLength = allProfiles.length;
        if (infoLength > 0) {
            int index = 0;
            while (index < infoLength) {
                Map factories = allProfiles[index].getProvider().getConnectionFactories();
                if (factories != null && factories.containsKey("java.sql.Connection")) {
                    Properties properties = allProfiles[index].getBaseProperties();
                    String vendor = properties.getProperty("org.eclipse.datatools.connectivity.db.vendor");
                    String version = properties.getProperty("org.eclipse.datatools.connectivity.db.version");
                    if (vendor != null && version != null && vendor.equals(this.allowedVendor)) {
                        filteredProfilesCollection.add(allProfiles[index]);
                    }
                }
                filteredProfiles = new IConnectionProfile[filteredProfilesCollection.size()];
                filteredProfilesCollection.copyInto(filteredProfiles);
                ++index;
            }
        }
        return filteredProfiles;
    }
}

