/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import java.util.Observable;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IOmitSchemaInfo;
import org.eclipse.jface.preference.IPreferenceStore;

public class OmitSchemaInfo
extends Observable
implements IOmitSchemaInfo {
    protected boolean _omitCurrentSchema = false;
    protected boolean _useAUIDAsCurrentSchema = true;
    protected String _currentSchema = "";

    public boolean getOmitCurrentSchema() {
        return this._omitCurrentSchema;
    }

    public void setOmitCurrentSchema(boolean omitCurrentSchema) {
        if (omitCurrentSchema != this._omitCurrentSchema) {
            this._omitCurrentSchema = omitCurrentSchema;
            this.setChanged();
        }
    }

    public boolean getUseAUIDAsCurrentSchema() {
        return this._useAUIDAsCurrentSchema;
    }

    public void setUseAUIDAsCurrentSchema(boolean useAUIDAsCurrentSchema) {
        if (useAUIDAsCurrentSchema != this._useAUIDAsCurrentSchema) {
            this._useAUIDAsCurrentSchema = useAUIDAsCurrentSchema;
            this.setChanged();
        }
    }

    public String getCurrentSchema() {
        return this._currentSchema;
    }

    public void setCurrentSchema(String currentSchema) {
        if (!this._currentSchema.equals(currentSchema)) {
            this._currentSchema = currentSchema == null ? "" : currentSchema;
            this.setChanged();
        }
    }

    public String encode() {
        StringBuffer code = new StringBuffer("");
        code.append(Boolean.toString(this._omitCurrentSchema)).append(":");
        code.append(Boolean.toString(this._useAUIDAsCurrentSchema)).append(":");
        code.append(this._currentSchema == null ? "" : this._currentSchema);
        return code.toString();
    }

    public static OmitSchemaInfo decode(String code) {
        OmitSchemaInfo omitSchemaInfo = new OmitSchemaInfo();
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{code});
        }
        if (code == null || !code.matches(".*:.*:.*")) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Cannot decode OmitSchemaInfo <" + code + ">");
            omitSchemaInfo.initFromPreferences();
        } else {
            int i = 0;
            int j = code.indexOf(58);
            String sOmitCurrentSchema = code.substring(i, j);
            omitSchemaInfo._omitCurrentSchema = Boolean.valueOf(sOmitCurrentSchema);
            i = j + 1;
            j = code.indexOf(58, i);
            String sUseAUIDAsCurrentSchema = code.substring(i, j);
            omitSchemaInfo._useAUIDAsCurrentSchema = Boolean.valueOf(sUseAUIDAsCurrentSchema);
            i = j + 1;
            omitSchemaInfo._currentSchema = code.substring(i);
        }
        return (OmitSchemaInfo)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)omitSchemaInfo);
    }

    public void setChanged() {
        super.setChanged();
        this.notifyObservers(null);
    }

    public boolean equals(IOmitSchemaInfo iOmitSchemaInfo) {
        boolean equals = true;
        if (iOmitSchemaInfo.getOmitCurrentSchema() != this._omitCurrentSchema) {
            equals = false;
        } else if (iOmitSchemaInfo.getUseAUIDAsCurrentSchema() != this._useAUIDAsCurrentSchema) {
            equals = false;
        } else if (this._currentSchema == null) {
            if (iOmitSchemaInfo.getCurrentSchema() != null && iOmitSchemaInfo.getCurrentSchema().length() > 0) {
                equals = false;
            }
        } else if (this._currentSchema != null && !this._currentSchema.equals(iOmitSchemaInfo.getCurrentSchema())) {
            equals = false;
        }
        return equals;
    }

    public void copy(IOmitSchemaInfo iOmitSchemaInfo) {
        this._omitCurrentSchema = iOmitSchemaInfo.getOmitCurrentSchema();
        this._useAUIDAsCurrentSchema = iOmitSchemaInfo.getUseAUIDAsCurrentSchema();
        this._currentSchema = iOmitSchemaInfo.getCurrentSchema() == null ? "" : iOmitSchemaInfo.getCurrentSchema();
    }

    public void initFromPreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        this._omitCurrentSchema = store.getBoolean("omit.current.schema.in.sql");
        this._useAUIDAsCurrentSchema = store.getBoolean("omit.current.schema.use.auid");
        this._currentSchema = store.getString("omit.current.schema.current.schema");
    }

    protected IPreferenceStore getPreferenceStore() {
        return SQLBuilderPlugin.getPlugin().getPreferenceStore();
    }
}

