/*******************************************************************************
 * Copyright (c) 2006, 2007 Ingres Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Ingres Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.enablement.ingres.internal.ui.sql;

import org.eclipse.datatools.sqltools.sql.ISQLSyntax;

/**
 * Ingres SQL Syntax description
 * 
 * @author enrico.schenk@ingres.com
 */
public class IngresSQLSyntax implements ISQLSyntax {

	protected static final String[] EMPTY = new String[0];

	// Keywords
	private static final String[] _unreservedwords = {
//		"ABSOLUTE",
//		"ACTION",
//		"ALLOCATE",
//		"ARE",
//		"ASENSITIVE",
//		"ASSERTION",
//		"SYMMETRIC",
//		"ATOMIC",
//		"BIT",
//		"BIT_LENGTH",
//		"BOTH",
//		"CALLED",
//		"CARDINALITY",
//		"CASCADED",
//		"CAST",
//		"CATALOG",
//		"CHAR",
//		"CHAR_LENGTH",
//		"CHARACTER",
//		"CHARACTER_LENGTH",
//		"COALESCE",
//		"COLLATE",
//		"COLLATION",
//		"COLLECT",
//		"CONDITION",
//		"CONNECTION",
//		"CONSTRAINTS",
//		"CONVERT",
//		"CORR",
//		"CORRESPONDING",
//		"CROSS",
//		"CUBE",
//		"CURRENT_DATE",
//		"CURRENT_DEFAULT_TRANSFORM_GROUP",
//		"CURRENT_PATH",
//		"CURRENT_ROLE",
//		"CURRENT_TIME",
//		"CURRENT_TIMESTAMP",
//		"DATE",
//		"DAY",
//		"DEALLOCATE",
//		"DEC",
//		"DECIMAL",
//		"DEFERRABLE",
//		"DEFERRED",
//		"DEREF",
//		"DETERMINISTIC",
//		"DIAGNOSTICS",
//		"DOMAIN",
//		"DOUBLE",
//		"DYNAMIC",
//		"EACH",
//		"ELEMENT",
//		"EVERY",
//		"EXCEPT",
//		"EXCEPTION",
//		"EXEC",
//		"EXTERNAL",
//		"EXTRACT",
//		"FALSE",
//		"FILTER",
//		"FLOAT",
//		"FOUND",
//		"FREE",
//		"FUNCTION",
//		"FUSION",
//		"GO",
//		"GROUPING",
//		"HOLD",
//		"HOUR",
//		"IDENTITY",
//		"INITIALLY",
//		"INOUT",
//		"INPUT",
//		"INSENSITIVE",
//		"INT",
//		"INTEGER",
//		"INTERSECT",
//		"INTERSECTION",
//		"INTERSECTS",
//		"INTERVAL",
//		"LANGUAGE",
//		"LARGE",
//		"LAST",
//		"LATERAL",
//		"LEADING",
//		"LN",
//		"LOCALTIME",
//		"LOCALTIMESTAMP",
//		"LOWER",
//		"MATCH",
//		"MEMBER",
//		"MERGE",
//		"METHOD",
//		"MINUTE",
//		"MOD",
//		"MODIFIES",
//		"MONTH",
//		"MULTISET",
//		"NAMES",
//		"NATIONAL",
//		"NCHAR",
//		"NEW",
//		"NO",
//		"NONE",
//		"NORMALIZE",
//		"NULLIF",
//		"NUMERIC",
//		"OCTET_LENGTH",
//		"OLD",
//		"OUTPUT",
//		"OVER",
//		"OVERLAPS",
//		"OVERLAY",
//		"PAD",
//		"PARAMETER",
//		"PARTIAL",
//		"PARTITION",
//		"POSITION",
//		"PRECISION",
//		"PRIOR",
//		"RANK",
//		"READS",
//		"REAL",
//		"RECURSIVE",
//		"REF",
//		"RELATIVE",
//		"RELEASE",
//		"RETURNS",
//		"ROLLUP",
//		"ROW_NUMBER",
//		"SCOPE",
//		"SEARCH",
//		"SECOND",
//		"SENSITIVE",
//		"SIMILAR",
//		"SIZE",
//		"SMALLINT",
//		"SPACE",
//		"SPECIFIC",
//		"SPECIFICTYPE",
//		"SQLCODE",
//		"SQLERROR",
//		"SQLEXCEPTION",
//		"SQLSTATE",
//		"SQLWARNING",
//		"STATIC",
//		"SUBMULTISET",
//		"SYMMETRIC",
//		"TABLESAMPLE",
//		"TIME",
//		"TIMESTAMP",
//		"TIMEZONE_HOUR",
//		"TIMEZONE_MINUTE",
//		"TRAILING",
//		"TRANSACTION",
//		"TRANSLATE",
//		"TRANSLATION",
//		"TREAT",
//		"TRIGGER",
//		"TRIM",
//		"TRUE",
//		"UESCAPE",
//		"UNKNOWN",
//		"UNNEST",
//		"UPPER",
//		"USAGE",
//		"VALUE",
//		"VARCHAR",
//		"VARYING",
//		"WIDTH_BUCKET",
//		"WINDOW",
//		"WITHIN",
//		"WITHOUT",
//		"YEAR",
//		"ZONE",
	};

	// Keywords
	private static final String[] reservedwords = {
		"ABORT", // sql_isql, sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"ACTIVATE", // sql_esql, quel_equel, 
		"ADD", // sql_esql, sql_4gl, 
		"ADDFORM", // sql_esql, quel_equel, 
		"AFTER", // sql_esql, sql_4gl, quel_4gl, 
		"AGGREGATE", // sql_isql, quel_iquel, 
		"ALL", // sql_esql, quel_iquel, quel_equel, 
		"ALTER", // sql_esql, sql_4gl, 
		"AND", // sql_isql, sql_esql, quel_iquel, quel_equel, 
		"ANY", // sql_isql, sql_esql, sql_4gl, quel_iquel, quel_equel, 
		// "APPEND", // quel_iquel, quel_equel, quel_4gl, 
		"ARRAY", // sql_esql, sql_4gl, 
		"AS", // sql_isql, sql_esql, quel_iquel, quel_equel, quel_4gl, 
		"ASC", // sql_isql, sql_4gl, 
		"ASYMMETRIC", // sql_isql, sql_esql, 
		"AT", // sql_isql, sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"ATTRIBUTE", // sql_esql, 
		"AUTHORIZATION", // sql_esql, sql_4gl, 
		"AUTOCOMMIT", // sql_isql, quel_iquel, 
		"AUTOMATIC", // sql_isql, 
		"AVG", // sql_isql, sql_esql, sql_4gl, quel_iquel, quel_equel, 
		"AVGU", // sql_esql, quel_iquel, quel_equel, 
		"BASE", // sql_isql, 
		"BEFORE", // sql_esql, sql_4gl, quel_4gl, 
		"BEGIN", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"BETWEEN", // sql_isql, sql_esql, sql_4gl, 
		"BREAKDISPLAY", // sql_esql, quel_equel, 
		"BY", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"BYREF", // sql_isql, sql_4gl, quel_4gl, 
		"CACHE", // sql_esql, sql_4gl, 
		"CALL", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		// "CALLFRAME", // sql_4gl, quel_4gl, 
		"CALLPROC", // sql_isql, sql_4gl, quel_4gl, 
		"CASCADE", // sql_isql, sql_esql, 
		"CASE", // sql_isql, sql_esql, sql_4gl, 
		"CAST", // sql_isql, 
		"CHECK", // sql_isql, sql_esql, sql_4gl, 
		// "CLASS", // sql_4gl, 
		"CLEAR", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"CLEARROW", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"CLOSE", // sql_esql, quel_iquel, quel_equel, 
		"COALESCE", // sql_isql, 
		"COLLATE", // sql_isql, sql_esql, 
		"COLUMN", // sql_isql, sql_esql, sql_4gl, quel_equel, 
		"COMMAND", // sql_esql, quel_equel, 
		"COMMENT", // sql_esql, sql_4gl, 
		"COMMIT", // sql_esql, sql_4gl, 
		"COMMITED", // sql_isql, sql_esql, sql_4gl, 
		"CONNECT", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"CONSTRAINT", // sql_isql, sql_esql, sql_4gl, 
		"CONTINUE", // sql_isql, sql_esql, 
		"COPY", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"COPY_FROM", // sql_isql, 
		"COPY_INTO", // sql_isql, 
		"COUNT", // sql_isql, sql_esql, sql_4gl, quel_iquel, quel_equel, 
		"COUNTU", // sql_esql, quel_iquel, quel_equel, 
		"CPUFACTOR", // sql_isql, quel_iquel, 
		"CREATE", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"CROSS", // sql_isql, sql_esql, sql_4gl, 
		"CURR", // sql_isql, 
		"CURRENT", // sql_esql, sql_4gl, 
		"CURRENT_USER", // sql_isql, 
		"CURRVAL", // sql_isql, sql_esql, sql_4gl, 
		"CURSOR", // sql_esql, quel_iquel, quel_equel, quel_4gl, 
		"CYCLE", // sql_esql, sql_4gl, 
		"DATA", // sql_esql, 
		"DATABASE", // sql_isql, sql_4gl, 
		// "DATAHANDLER", // quel_iquel, 
		"DATE_FORMAT", // sql_isql, quel_iquel, 
		"DBEVENT", // sql_esql, sql_4gl, 
		"DDL_CONCURRENCY", // sql_isql, 
		"DECIMAL", // sql_isql, quel_iquel, 
		"DECLARE", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"DEFAULT", // sql_esql, sql_4gl, quel_4gl, 
		"DEFERRED", // sql_isql, quel_iquel, 
		// "DEFINE", // quel_iquel, quel_equel, quel_4gl, 
		"DELETE", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"DELETEROW", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		// "DESC", // sql_4gl, 
		"DESCRIBE", // sql_esql, 
		"DESCRIPTOR", // sql_esql, 
		"DESTROY", // sql_esql, quel_iquel, quel_equel, quel_4gl, 
		"DIRECT", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"DISABLE", // sql_esql, sql_4gl, 
		"DISCONNECT", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"DISPLAY", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"DISTINCT", // sql_isql, sql_esql, sql_4gl, 
		// "DISTRIBUTE", // quel_iquel, 
		"DO", // sql_isql, sql_4gl, quel_4gl, 
		"DOMAIN", // sql_esql, 
		"DOWN", // sql_esql, quel_equel, 
		"DROP", // sql_esql, sql_4gl, 
		"EACH", // sql_esql, 
		"ELSE", // sql_isql, sql_4gl, quel_4gl, 
		"ELSEIF", // sql_isql, sql_4gl, quel_4gl, 
		"ENABLE", // sql_esql, sql_4gl, 
		"END", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"END-EXEC", // sql_esql, 
		"ENDDATA", // sql_esql, quel_equel, 
		"ENDDISPLAY", // sql_esql, quel_equel, 
		"ENDFOR", // sql_isql, sql_esql, sql_4gl, 
		"ENDFORMS", // sql_esql, quel_equel, 
		"ENDIF", // sql_isql, sql_4gl, quel_4gl, 
		"ENDLOOP", // sql_isql, sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"ENDREPEAT", // sql_isql, sql_esql, sql_4gl, 
		// "ENDRETRIEVE", // quel_equel, 
		"ENDSELECT", // sql_esql, 
		"ENDWHILE", // sql_isql, sql_4gl, quel_4gl, 
		// "ENTRY", // sql_4gl, quel_4gl, 
		"ERROR", // sql_isql, 
		"ESCAPE", // sql_isql, sql_esql, 
		"EXCEPT", // sql_isql, 
		"EXCLUDE", // sql_esql, quel_iquel, 
		"EXCLUDING", // sql_isql, quel_iquel, 
		"EXEC", // sql_esql, 
		"EXECUTE", // sql_esql, sql_4gl, quel_iquel, quel_4gl, 
		"EXISTS", // sql_isql, sql_esql, sql_4gl, 
		// "EXIT", // sql_4gl, quel_equel, quel_4gl, 
		"FETCH", // sql_isql, sql_esql, 
		"FIELD", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"FINALIZE", // sql_esql, quel_equel, 
		"FIRST", // sql_isql, sql_esql, sql_4gl, 
		"FLATTEN", // sql_isql, 
		"FOR", // sql_esql, sql_4gl, quel_iquel, quel_equel, 
		"FOREIGN", // sql_esql, sql_4gl, 
		"FORM", // sql_esql, 
		"FORMDATA", // sql_esql, quel_equel, 
		"FORMINIT", // sql_esql, quel_equel, 
		"FORMS", // sql_esql, quel_equel, 
		"FROM", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"FULL", // sql_esql, sql_4gl, 
		"GET", // sql_esql, sql_4gl, 
		"GETFORM", // sql_esql, quel_equel, 
		"GETOPER", // sql_esql, quel_equel, 
		"GETROW", // sql_esql, quel_equel, 
		"GLOBAL", // sql_esql, sql_4gl, 
		"GOTO", // sql_esql, 
		"GRANT", // sql_isql, sql_esql, sql_4gl, 
		"GRANTED", // sql_esql, sql_4gl, 
		"GROUP", // sql_esql, sql_4gl, 
		// "HASH", // 
		"HAVING", // sql_isql, sql_esql, sql_4gl, 
		"HELP", // sql_esql, quel_iquel, quel_equel, 
		// "HELP_FORMS", // sql_4gl, quel_4gl, 
		"HELP_FRS", // sql_esql, quel_equel, 
		"HELPFILE", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"IDENTIFIED", // sql_esql, sql_4gl, 
		"IF", // sql_isql, sql_4gl, quel_4gl, 
		"IIMESSAGE", // sql_esql, quel_equel, 
		"IIPRINTF", // sql_esql, quel_equel, 
		"IIPROMPT", // sql_esql, quel_equel, 
		// "IISTATEMENT", // quel_equel, 
		"IMMEDIATE", // sql_esql, sql_4gl, quel_4gl, 
		"IMPORT", // sql_isql, 
		"IN", // sql_isql, sql_esql, sql_4gl, quel_iquel, quel_equel, 
		"INCLUDE", // sql_esql, quel_iquel, 
		"INCREMENT", // sql_isql, sql_esql, sql_4gl, 
		"INDEX", // sql_isql, sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"INDICATOR", // sql_esql, 
		// "INGRES", // quel_equel, 
		"INITIAL_USER", // sql_isql, quel_iquel, 
		"INITIALIZE", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"INITTABLE", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"INNER", // sql_esql, sql_4gl, 
		// "INQUIRE_EQUEL", // quel_equel, 
		// "INQUIRE_FORMS", // sql_4gl, quel_4gl, 
		"INQUIRE_FRS", // sql_esql, quel_equel, 
		"INQUIRE_INGRES", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"INQUIRE_SQL", // sql_esql, sql_4gl, 
		"INSERT", // sql_isql, sql_esql, sql_4gl, 
		"INSERTROW", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		// "INSTALLATION", // sql_4gl, 
		"INTEGRITY", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"INTERSECT", // sql_isql, 
		"INTO", // sql_isql, sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"IO_TRACE", // sql_isql, quel_iquel, 
		"IS", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"ISOLATION", // sql_esql, sql_4gl, quel_iquel, 
		// "JCPUFACTOR", // quel_iquel, 
		"JOIN", // sql_esql, sql_4gl, 
		"JOINOP", // sql_isql, quel_iquel, 
		"JOURNALING", // sql_isql, quel_iquel, 
		"KEY", // sql_esql, sql_4gl, quel_4gl, 
		"LEAVE", // sql_isql, sql_esql, sql_4gl, 
		"LEFT", // sql_esql, sql_4gl, 
		"LEVEL", // sql_esql, quel_iquel, quel_equel, 
		"LIKE", // sql_esql, sql_4gl, quel_4gl, 
		"LINK", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"LIST", // sql_isql, 
		"LOADTABLE", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"LOCAL", // sql_isql, 
		"LOCATION", // sql_esql, sql_4gl, quel_iquel, 
		"LOCK_TRACE", // sql_isql, quel_iquel, 
		"LOCKMODE", // sql_isql, quel_iquel, 
		"LOG_TRACE", // sql_isql, quel_iquel, 
		"LOGDBEVENTS", // sql_isql, 
		"LOGGING", // sql_isql, quel_iquel, 
		"MAX", // sql_isql, sql_esql, sql_4gl, quel_iquel, quel_equel, 
		"MAXCONNECT", // sql_isql, 
		"MAXCOST", // sql_isql, quel_iquel, 
		"MAXCPU", // sql_isql, quel_iquel, 
		"MAXIDLE", // sql_isql, 
		"MAXIO", // sql_isql, quel_iquel, 
		"MAXPAGE", // sql_isql, quel_iquel, 
		"MAXQUERY", // sql_isql, quel_iquel, 
		"MAXROW", // sql_isql, quel_iquel, 
		"MAXVALUE", // sql_esql, sql_4gl, 
		// "MENU", // sql_4gl, quel_4gl, 
		"MENUITEM", // sql_esql, quel_equel, 
		"MESSAGE", // sql_isql, sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"MIN", // sql_isql, sql_esql, sql_4gl, quel_iquel, quel_equel, 
		"MINVALUE", // sql_esql, sql_4gl, 
		// "MODE", // sql_4gl, quel_4gl, 
		"MODIFY", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"MODULE", // sql_isql, 
		"MONEY_FORMAT", // sql_isql, quel_iquel, 
		"MONEY_PREC", // sql_isql, quel_iquel, 
		// "MOVE", // quel_iquel, 
		"NATURAL", // sql_isql, sql_esql, 
		"NEXT", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		// "NEXTFIELD", // sql_4gl, 
		"NEXTVAL", // sql_isql, sql_esql, sql_4gl, 
		"NO", // sql_esql, sql_4gl, 
		"NOCACHE", // sql_isql, sql_esql, sql_4gl, 
		"NOCYCLE", // sql_isql, sql_esql, sql_4gl, 
		// "NOECHO", // sql_4gl, quel_4gl, 
		"NOFLATTEN", // sql_isql, 
		"NOHASH", // sql_isql, 
		"NOIO_TRACE", // sql_isql, quel_iquel, 
		"NOJOINOP", // sql_isql, quel_iquel, 
		"NOJOURNALING", // sql_isql, quel_iquel, 
		"NOLOCK_TRACE", // sql_isql, quel_iquel, 
		"NOLOG_TRACE", // sql_isql, quel_iquel, 
		"NOLOGDBEVENTS", // sql_isql, 
		"NOLOGGING", // sql_isql, quel_iquel, 
		"NOMAXCONNECT", // sql_isql, 
		"NOMAXCOST", // sql_isql, quel_iquel, 
		"NOMAXCPU", // sql_isql, quel_iquel, 
		"NOMAXIDLE", // sql_isql, 
		"NOMAXIO", // sql_isql, quel_iquel, 
		"NOMAXPAGE", // sql_isql, quel_iquel, 
		"NOMAXQUERY", // sql_isql, quel_iquel, 
		"NOMAXROW", // sql_isql, quel_iquel, 
		"NOMAXVALUE", // sql_isql, sql_esql, sql_4gl, 
		"NOMINVALUE", // sql_isql, sql_esql, sql_4gl, 
		"NOOJFLATTEN", // sql_isql, 
		"NOOPTIMIZEONLY", // sql_isql, quel_iquel, 
		"NOORDER", // sql_isql, sql_esql, sql_4gl, 
		"NOPARALLEL", // sql_isql, 
		"NOPRINTDBEVENTS", // sql_isql, 
		"NOPRINTQRY", // sql_isql, quel_iquel, 
		"NOPRINTRULES", // sql_isql, 
		"NOQEP", // sql_isql, quel_iquel, 
		"NORULES", // sql_isql, 
		// "NOSQL", // quel_iquel, 
		"NOSTATISTICS", // sql_isql, quel_iquel, 
		"NOT", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"NOTRACE", // sql_isql, quel_iquel, 
		"NOTRIM", // sql_esql, quel_equel, 
		"NOUNICODE_SUBSTITUTION", // sql_isql, 
		"NULL", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"NULLIF", // sql_isql, 
		"OF", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"OJFLATTEN", // sql_isql, 
		"ON", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"ONLY", // sql_esql, sql_4gl, quel_iquel, quel_4gl, 
		"OPEN", // sql_esql, quel_iquel, quel_equel, 
		"OPTIMIZEONLY", // sql_isql, quel_iquel, 
		"OPTION", // sql_isql, 
		"OR", // sql_isql, sql_esql, quel_iquel, quel_equel, 
		"ORDER", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"OUT", // sql_esql, 
		"OUTER", // sql_esql, sql_4gl, 
		"PARALLEL", // sql_isql, 
		// "PARAM", // quel_equel, 
		"PARTITION", // sql_esql, 
		"PERMIT", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"PREPARE", // sql_isql, sql_esql, 
		"PRESERVE", // sql_isql, sql_esql, 
		// "PREVIOUSFIELD", // sql_4gl, 
		"PRIMARY", // sql_esql, sql_4gl, 
		"PRINT", // sql_esql, quel_iquel, quel_equel, 
		"PRINTDBEVENTS", // sql_isql, 
		"PRINTQRY", // sql_isql, quel_iquel, 
		"PRINTRULES", // sql_isql, 
		"PRINTSCREEN", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		// "PRIVILEGES", // sql_4gl, 
		"PROCEDURE", // sql_esql, sql_4gl, quel_4gl, 
		// "PROFILE", // 
		"PROMPT", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"PUBLIC", // sql_isql, sql_esql, 
		"PURGETABLE", // sql_esql, sql_4gl, quel_4gl, 
		"PUT", // sql_esql, 
		"PUTFORM", // sql_esql, quel_equel, 
		"PUTOPER", // sql_esql, quel_equel, 
		"PUTROW", // sql_esql, quel_equel, 
		"QEP", // sql_isql, quel_iquel, 
		"QRY", // sql_isql, quel_iquel, quel_4gl, 
		// "QUALIFICATION", // sql_4gl, quel_4gl, 
		"QUERY", // sql_isql, quel_iquel, 
		"RAISE", // sql_esql, sql_4gl, 
		"RANDOM_SEED", // sql_isql, 
		// "RANGE", // quel_iquel, quel_equel, quel_4gl, 
		"RAWPCT", // sql_isql, sql_esql, sql_4gl, 
		"READ", // sql_esql, 
		"READONLY", // sql_isql, quel_iquel, 
		"REDISPLAY", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"REFERENCES", // sql_isql, sql_esql, sql_4gl, 
		"REFERENCING", // sql_isql, sql_4gl, 
		"REGISTER", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"RELOCATE", // sql_isql, sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"REMOTE", // sql_esql, 
		"REMOVE", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		// "RENAME", // quel_iquel, 
		"REPEAT", // sql_isql, sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"REPEATABLE", // sql_isql, sql_esql, sql_4gl, 
		"REPEATED", // sql_esql, sql_4gl, 
		"REPLACE", // sql_esql, quel_iquel, quel_equel, quel_4gl, 
		// "REPLICATE", // quel_iquel, 
		"RESTART", // sql_isql, sql_esql, sql_4gl, 
		"RESTRICT", // sql_isql, sql_esql, 
		"RESULT", // sql_esql, sql_4gl, 
		"RESULT_STRUCTURE", // sql_isql, quel_iquel, 
		"RESUME", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"RET_INTO", // sql_isql, quel_iquel, 
		"RETRIEVE", // sql_esql, quel_iquel, quel_equel, quel_4gl, 
		"RETURN", // sql_isql, sql_4gl, quel_4gl, 
		// "RETURNING", // sql_4gl, quel_4gl, 
		"REVOKE", // sql_isql, sql_esql, sql_4gl, 
		"RIGHT", // sql_esql, sql_4gl, 
		"ROLE", // sql_esql, sql_4gl, 
		"ROLLBACK", // sql_isql, sql_esql, sql_4gl, 
		"ROW", // sql_esql, sql_4gl, 
		"ROWS", // sql_isql, sql_esql, 
		"RULE", // sql_esql, sql_4gl, 
		"RULES", // sql_isql, 
		// "RUN", // sql_4gl, quel_4gl, 
		"SAVE", // sql_isql, sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"SAVEPOINT", // sql_isql, sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"SCHEMA", // sql_isql, sql_esql, 
		"SCREEN", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"SCROLL", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"SCROLLDOWN", // sql_esql, quel_equel, 
		"SCROLLUP", // sql_esql, quel_equel, 
		"SECTION", // sql_esql, 
		"SECURITY_ALARM", // sql_esql, sql_4gl, 
		"SECURITY_AUDIT", // sql_esql, sql_4gl, 
		"SELECT", // sql_isql, sql_esql, sql_4gl, 
		// "SEND", // sql_4gl, 
		"SEQUENCE", // sql_esql, sql_4gl, 
		"SERIALIZABLE", // sql_isql, sql_esql, sql_4gl, 
		"SESSION", // sql_esql, sql_4gl, quel_iquel, 
		"SESSION_USER", // sql_isql, quel_iquel, 
		"SET", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		// "SET_4GL", // quel_equel, 
		// "SET_EQUEL", // quel_equel, 
		// "SET_FORMS", // sql_4gl, quel_4gl, 
		"SET_FRS", // sql_esql, quel_equel, 
		"SET_INGRES", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"SET_SQL", // sql_esql, sql_4gl, 
		"SHORT_REMARK", // sql_isql, 
		"SLEEP", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"SOME", // sql_isql, sql_esql, sql_4gl, 
		// "SORT", // quel_iquel, quel_equel, quel_4gl, 
		"SQL", // sql_esql, quel_iquel, 
		"START", // sql_isql, sql_esql, sql_4gl, 
		"STATEMENT", // sql_esql, 
		"STATISTICS", // sql_isql, quel_iquel, 
		"STOP", // sql_esql, 
		"STRUCTURE", // sql_isql, 
		"SUBMENU", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"SUBSTRING", // sql_isql, sql_esql, 
		"SUM", // sql_isql, sql_esql, sql_4gl, quel_iquel, quel_equel, 
		"SUMU", // sql_esql, quel_iquel, quel_equel, 
		"SYMMETRIC", // sql_isql, sql_esql, 
		"SYNONYM", // sql_esql, sql_4gl, 
		// "SYSTEM", // sql_4gl, quel_4gl, 
		"SYSTEM_MAINTAINED", // sql_isql, sql_esql, quel_iquel, quel_equel, 
		"SYSTEM_PASSWORD", // sql_esql, 
		"SYSTEM_USER", // sql_esql, 
		"TABLE", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"TABLEDATA", // sql_esql, quel_equel, 
		"TEMPORARY", // sql_esql, sql_4gl, 
		"THEN", // sql_isql, sql_esql, sql_4gl, quel_4gl, 
		"TO", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"TRACE", // sql_isql, quel_iquel, 
		"TRANSACTION", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		// "TYPE", // sql_4gl, 
		"UNCOMMITTED", // sql_isql, sql_esql, sql_4gl, 
		"UNICODE_SUBSTITUTION", // sql_isql, 
		"UNION", // sql_isql, sql_esql, sql_4gl, 
		"UNIQUE", // sql_isql, sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"UNLOADTABLE", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"UNTIL", // sql_isql, sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"UP", // sql_esql, quel_equel, 
		"UPDATE", // sql_esql, sql_4gl, quel_iquel, 
		"UPDATE_ROWCOUNT", // sql_isql, 
		"USER", // sql_esql, sql_4gl, 
		// "USEREVENT", // sql_4gl, 
		"USING", // sql_isql, sql_esql, 
		"VALIDATE", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"VALIDROW", // sql_esql, sql_4gl, quel_equel, quel_4gl, 
		"VALUE", // sql_esql, sql_4gl, 
		"VALUES", // sql_esql, sql_4gl, 
		"VIEW", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"WHEN", // sql_isql, sql_esql, 
		"WHENEVER", // sql_esql, 
		"WHERE", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		"WHILE", // sql_isql, quel_4gl, 
		"WITH", // sql_esql, sql_4gl, quel_iquel, quel_equel, quel_4gl, 
		// "WORK", // sql_4gl, 
		"WRITE", // sql_esql, sql_4gl, 
	};

	// Understanding the Elements of SQL Statements/SQL Operations
	private static final String[] predicates = {
			"+",
			"-",
			"**",
			"*",
			"/",
			"=",
			"<>",
			">",
			">=",
			"<",
			"<=",
			"!=",
			"^=",
			"||",
			",",
			";",
			".",
			"(",
			")",
			"?"
			};

	// Understanding SQL Data Types
	private static final String[] types = {
		"C",
		"CHAR",
		"CHARACTER",
		"TEXT",
		"VARCHAR",
		"CHARACTER", "VARYING",
		"LONG", "VARCHAR",
		"LONG", "VARCHAR",
		"CLOB",
		"CHARACTER", "LARGE", "OBJECT",
		"CHAR", "LARGE", "OBJECT",
		"NCHAR",
		"NVARCHAR",
		"LONG", "NVARCHAR",
		"CLOB",
		"NCLOB",
		"NCHAR", "LARGE", "OBJECT",
		"NATIONAL", "CHARACTER", "LARGE", "OBJECT",
		"INTEGER",
		"INTEGER4",
		"SMALLINT",
		"INTEGER2",
		"BIGINT",
		"INTEGER8",
		"TINYINT",
		"INTEGER1",
		"DECIMAL",
		"FLOAT",
		"FLOAT8",
		"DOUBLE", "PRECISION",
		"FLOAT4",
		"REAL",
		"DATE",
		"ANSIDATE",
		"INGRESDATE",
		"TIME",
		"TIME", "WITH", "TIME", "ZONE",
		"TIME", "WITHOUT", "TIME", "ZONE",
		"TIME", "WITH", "LOCAL", "TIME", "ZONE",
		"TIMESTAMP",
		"TIMESTAMP", "WITH", "TIME", "ZONE",
		"TIMESTAMP", "WITHOUT", "TIME", "ZONE",
		"TIMESTAMP", "WITH", "LOCAL", "TIME", "ZONE",
		"INTERVAL",
		"INTERVAL", "YEAR", "TO", "MONTH",
		"INTERVAL", "DAY", "TO", "SECOND",
		"MONEY",
		"OBJECT_KEY",
		"TABLE_KEY",
		"BYTE",
		"BYTE", "VARYING",
		"LONG", "BYTE",
		"BLOB",
		"BINARY", "LARGE", "OBJECT",
	};
	
	// SQL Constants
	private static final String[] constants = {
		"NOW",
		"NULL",
		"TODAY",
		"CURRENT_DATE",
		"CURRENT_TIME",
		"CURRENT_TIMESTAMP",
		"LOCAL_TIME",
		"LOCAL_TIMESTAMP",
		"USER",
		"CURRENT_USER",
		"SYSTEM_USER",
		"INITIAL_USER",
		"SESSION_USER",		
	};
	
	//Understanding the Elements of SQL Statements/SQL Functions
	private static final String[] functions = {
//		"ANSIDATE", // type cast
//		"BYTE", // type cast
//		"BINARY", // type cast
//		"C", // type cast
//		"CHAR", // type cast
//		"DATE", // type cast
//		"INGRESDATE", // type cast
//		"DECIMAL", // type cast
		"NUMERIC",
		"DOW",
//		"FLOAT4", // type cast
//		"FLOAT8", // type cast
		"HEX",
		"INT1",
//		"TINYINT", // type cast
		"INT2",
//		"SMALLINT", // type cast
		"INT4",
		"INT",
//		"INTEGER", // type cast
		"INT8",
//		"BIGINT", // type cast
		"INTERVAL_DTOS",
		"INTERVAL_YTOM",
		"LONG_BYTE",
		"LONG_BINARY",
		"LONG_VARCHAR",
//		"MONEY", // type cast
//		"NCHAR", // type cast
//		"NVARCHAR", // type cast
//		"OBJECT_KEY", // type cast
//		"TABLE_KEY", // type cast
//		"TEXT", // type cast
		"TIME_LOCAL",
		"TIME_WITH_TZ",
//		"TIME", // type cast
		"TIME_WO_TZ",
		"TIMESTAMP_LOCAL",
		"TIMESTAMP_WITH_TZ",
//		"TIMESTAMP", // type cast
		"TIMESTAMP_WO_TZ",
		"UNHEX",
		"VARBYTE",
		"VARBINARY",
//		"VARCHAR", // type cast
		"ABS",
		"ACOS",
		"ASIN",
		"ATAN",
		"ATAN2",
		"CEIL",
		"CEILING",
		"COS",
		"EXP",
		"FLOOR",
		"LOG",
		"LN",
		"MOD",
		"PI",
		"POWER",
		"ROUND",
		"SIGN",
		"SIN",
		"SQRT",
		"TAN",
		"TRUNC",
		"TRUNCATE",
		"ASCII",
		"BYTEEXTRACT",
		"CHAREXTRACT",
		"CHARACTER_LENGTH",
		"CHR",
		"COLLATION_WEIGHT",
		"CONCAT",
		"II_IPADDR",
		"LEFT",
		"LENGTH",
		"LOCATE",
		"LOWERCASE",
		"LOWER",
		"LPAD",
		"LTRIM",
		"OCTET_LENGTH",
		"POSITION",
		"REPLACE",
		"RIGHT",
		"RPAD",
		"RTRIM",
		"SHIFT",
		"SIZE",
		"SOUNDEX",
		"SQUEEZE",
		"SUBSTRING",
		"TRIM",
		"NOTRIM",
		"UPPERCASE",
		"UPPER",
		"YEAR",
		"QUARTER",
		"MONTH",
		"WEEK",
		"WEEK_ISO",
		"DAY",
		"HOUR",
		"MINUTE",
		"SECOND",
		"MICROSECOND",
		"NANOSECOND",
		"DATE_TRUNC",
		"DATE_PART",
		"DATE_GMT",
		"GMT_TIMESTAMP",
//		"INTERVAL", // type cast
		"ISDST",
		"_DATE",
		"_DATE4",
		"_TIME",
		"EXTRACT",
		"BIT_ADD",
		"BIT_AND",
		"BIT_NOT",
		"BIT_OR",
		"BIT_XOR",
		"INTEXTRACT",
		"HASH",
		"RANDOM",
		"ANY",
		"AVG",
		"COUNT",
		"MAX",
		"MIN",
		"SUM",
		"STDDEV_POP",
		"STDDEV_SAMP",
		"VAR_POP",
		"VAR_SAMP",
		"REGR_COUNT",
		"INDEP_PARM",
		"DEP_PARM",
		"COVAR_POP",
		"INDEP_PARM",
		"DEP_PARM",
		"COVAR_SAMP",
		"INDEP_PARM",
		"DEP_PARM",
		"CORR",
		"INDEP_PARM",
		"DEP_PARM",
		"REGR_R2",
		"INDEP_PARM",
		"DEP_PARM",
		"REGR_SLOPE",
		"INDEP_PARM",
		"DEP_PARM",
		"REGR_INTERCEPT",
		"INDEP_PARM",
		"DEP_PARM",
		"REGR_SXX",
		"INDEP_PARM",
		"DEP_PARM",
		"REGR_SYY",
		"INDEP_PARM",
		"DEP_PARM",
		"REGR_SXY",
		"INDEP_PARM",
		"DEP_PARM",
		"REGR_AVGX",
		"INDEP_PARM",
		"DEP_PARM",
		"REGR_AVGY",
		"INDEP_PARM",
		"DEP_PARM",
		"IFNULL",
		"UUID_CREATE",
		"UUID_FROM_CHAR",
		"UUID_COMPARE",
	};

	private static final String[] _comments = {
		"--"
	};

	/**
	 * @return Returns the functions.
	 */
	public String[] getFunctions() {
		return functions;
	}

	/**
	 * @return Returns the predicates.
	 */
	public String[] getPredicates() {
		return predicates;
	}

	/**
	 * @return Returns the reservedwords.
	 */
	public String[] getReservedwords() {
		return reservedwords;
	}

	public String[] getUnreservedwords() {
		return _unreservedwords;
	}

	/**
	 * @return Returns the types.
	 */
	public String[] getTypes() {
		return types;
	}

	/**
	 * @return Returns the allWords.
	 */
	public Object[] getAllWords() {
		return new Object[] { getReservedwords(), getUnreservedwords(),
				getPredicates(), getTypes(), getConstants(), getFunctions(),
				getGlobalVariables() };
	}

	/**
	 * @return Returns the constants.
	 */
	public String[] getConstants() {
		return constants;
	}

	public String[] getSingleLineComments() {
		return _comments;
	}

	public String[] getGlobalVariables() {
		return EMPTY;
	}

}
