/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.tableviewer;

import org.eclipse.datatools.sqltools.common.core.tableviewer.ITableData;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.AccessibleTableViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;

public abstract class AccessibleTableEditorImpl {
    private CellEditor _cellEditor;
    private CellEditor[] _cellEditors;
    private ICellModifier _cellModifier;
    private String[] _columnProperties;
    private Item _tableItem;
    private int _columnNumber;
    private ICellEditorListener _cellEditorListener;
    private FocusListener _focusListener;
    private MouseListener _mouseListener;
    private StructuredViewer _viewer;

    AccessibleTableEditorImpl(StructuredViewer viewer) {
        this._viewer = viewer;
        this.initCellEditorListener();
    }

    public StructuredViewer getViewer() {
        return this._viewer;
    }

    private void activateCellEditor() {
        String property;
        Object element;
        if (this._columnNumber == 0) {
            return;
        }
        if (this._cellEditors != null && this._cellEditors[this._columnNumber - 1] != null && this._cellModifier != null && this._cellModifier.canModify(element = this._tableItem.getData(), property = this._columnProperties[this._columnNumber - 1])) {
            if (this.getViewer().getInput() instanceof ITableData) {
                ITableData tableData = (ITableData)this.getViewer().getInput();
                int columnType = 0;
                try {
                    columnType = tableData.getColumnType(this._columnNumber - 1);
                    if (columnType == 16) {
                        ((TableItem)this._tableItem).setImage(this._columnNumber, null);
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
            this._cellEditor = this._cellEditors[this._columnNumber - 1];
            this._cellEditor.addListener(this._cellEditorListener);
            Object value = this._cellModifier.getValue(element, property);
            this._cellEditor.setValue(value);
            Control control = this._cellEditor.getControl();
            this._cellEditor.activate();
            if (control == null) {
                return;
            }
            this.setLayoutData(this._cellEditor.getLayoutData());
            this.setEditor(control, this._tableItem, this._columnNumber);
            this._cellEditor.setFocus();
            if (this._focusListener == null) {
                this._focusListener = new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        AccessibleTableEditorImpl.this.applyEditorValue();
                    }
                };
            }
            control.addFocusListener(this._focusListener);
            if (this.getViewer().getInput() instanceof ITableData) {
                ITableData tableData = (ITableData)this.getViewer().getInput();
                int columnType = 0;
                try {
                    columnType = tableData.getColumnType(this._columnNumber - 1);
                }
                catch (RuntimeException runtimeException) {}
                if (columnType == 16) {
                    IBaseLabelProvider labelProvider = this.getViewer().getLabelProvider();
                    ITableLabelProvider tableLabelProvider = null;
                    if (labelProvider instanceof ITableLabelProvider) {
                        tableLabelProvider = (ITableLabelProvider)labelProvider;
                        AccessibleTableViewer accessibleTableViewer = (AccessibleTableViewer)this.getViewer();
                        tableLabelProvider.getColumnImage((Object)accessibleTableViewer.getRow(), this._columnNumber - 1);
                        ((TableItem)this._tableItem).setImage(this._columnNumber, null);
                    }
                }
            }
        }
    }

    public void applyEditorValue() {
        CellEditor c = this._cellEditor;
        if (c != null) {
            this._cellEditor = null;
            Item t = this._tableItem;
            if (t != null && !t.isDisposed()) {
                this.saveEditorValue(c, t);
            }
            this.setEditor(null, null, 0);
            c.removeListener(this._cellEditorListener);
            Control control = c.getControl();
            if (control != null) {
                if (this._mouseListener != null) {
                    control.removeMouseListener(this._mouseListener);
                }
                if (this._focusListener != null) {
                    control.removeFocusListener(this._focusListener);
                }
            }
            c.deactivate();
        }
    }

    public void cancelEditing() {
        if (this._cellEditor != null) {
            this.setEditor(null, null, 0);
            this._cellEditor.removeListener(this._cellEditorListener);
            CellEditor oldEditor = this._cellEditor;
            this._cellEditor = null;
            oldEditor.deactivate();
        }
    }

    public void editElement(Object element, int column) {
        if (this._cellEditor != null) {
            this.applyEditorValue();
        }
        this.setSelection(new StructuredSelection(element), true);
        Item[] selection = this.getSelection();
        if (selection.length != 1) {
            return;
        }
        this._tableItem = selection[0];
        this.showSelection();
        this._columnNumber = column;
        this.activateCellEditor();
    }

    abstract Rectangle getBounds(Item var1, int var2);

    public CellEditor[] getCellEditors() {
        return this._cellEditors;
    }

    public ICellModifier getCellModifier() {
        return this._cellModifier;
    }

    abstract int getColumnCount();

    public Object[] getColumnProperties() {
        return this._columnProperties;
    }

    abstract Item[] getSelection();

    private void initCellEditorListener() {
        this._cellEditorListener = new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void cancelEditor() {
                AccessibleTableEditorImpl.this.cancelEditing();
            }

            public void applyEditorValue() {
                AccessibleTableEditorImpl.this.applyEditorValue();
            }
        };
    }

    public boolean isCellEditorActive() {
        return this._cellEditor != null;
    }

    private void saveEditorValue(CellEditor cellEditor, Item tableItem) {
        if (this._cellModifier != null) {
            cellEditor.isValueValid();
            String property = null;
            if (this._columnProperties != null && this._columnNumber - 1 < this._columnProperties.length) {
                property = this._columnProperties[this._columnNumber - 1];
            }
            this._cellModifier.modify((Object)tableItem, property, cellEditor.getValue());
        }
    }

    public void setCellEditors(CellEditor[] editors) {
        this._cellEditors = editors;
    }

    public void setCellModifier(ICellModifier modifier) {
        this._cellModifier = modifier;
    }

    public void setColumnProperties(String[] columnProperties) {
        this._columnProperties = columnProperties;
    }

    abstract void setEditor(Control var1, Item var2, int var3);

    abstract void setLayoutData(CellEditor.LayoutData var1);

    abstract void setSelection(StructuredSelection var1, boolean var2);

    abstract void showSelection();

    abstract void handleDoubleClickEvent();
}

