/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.impl.Connection;
import org.eclipse.datatools.enablement.oda.xml.impl.DataTypes;
import org.eclipse.datatools.enablement.oda.xml.impl.ResultSet;
import org.eclipse.datatools.enablement.oda.xml.impl.ResultSetMetaData;
import org.eclipse.datatools.enablement.oda.xml.util.MappedTables;

public class Query
implements IQuery {
    private String tableName = null;
    private int maxRows = 0;
    private boolean isClosed = false;
    private Connection connection;
    private MappedTables mt;

    public Query(Connection connection) {
        this.connection = connection;
    }

    public void prepare(String queryText) throws OdaException {
        this.testClosed();
        if (queryText == null) {
            throw new OdaException(Messages.getString("Query.InvalidQueryText"));
        }
        String[] temp = queryText.trim().split("#-TNAME-#");
        if (temp.length != 2) {
            throw new OdaException(Messages.getString("Query.InvalidQueryText"));
        }
        this.tableName = temp[0];
        this.mt = new MappedTables(temp[1]);
    }

    public void setProperty(String name, String value) throws OdaException {
    }

    public void close() throws OdaException {
        this.isClosed = true;
    }

    public void setMaxRows(int max) throws OdaException {
        this.testClosed();
        this.maxRows = max > 0 ? max : 0;
    }

    public int getMaxRows() throws OdaException {
        this.testClosed();
        return this.maxRows;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        this.testClosed();
        return new ResultSetMetaData(this.mt, this.tableName);
    }

    public IResultSet executeQuery() throws OdaException {
        this.testClosed();
        if (this.tableName == null || this.tableName.trim().length() == 0) {
            throw new OdaException(Messages.getString("Query.QueryHasNotBeenPrepared"));
        }
        ResultSet result = new ResultSet(this.connection, this.mt, this.tableName, this.getMaxRows());
        return result;
    }

    public void clearInParameters() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setInt(String parameterName, int value) throws OdaException {
        this.setString(parameterName, String.valueOf(value));
    }

    public void setInt(int parameterId, int value) throws OdaException {
        this.setString(parameterId, String.valueOf(value));
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        this.setString(parameterName, String.valueOf(value));
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        this.setString(parameterId, String.valueOf(value));
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        this.setString(parameterName, String.valueOf(value));
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        this.setString(parameterId, String.valueOf(value));
    }

    public void setString(String parameterName, String value) throws OdaException {
        if (this.mt != null) {
            this.mt.setParameterValue(parameterName, value);
        }
    }

    public void setString(int parameterId, String value) throws OdaException {
        if (this.mt != null && parameterId >= 1 && parameterId <= this.mt.getParameters().length) {
            this.mt.setParameterValue(this.mt.getParameters()[parameterId - 1], value);
        }
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        this.setString(parameterName, String.valueOf(value));
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        this.setString(parameterId, String.valueOf(value));
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        this.setString(parameterName, String.valueOf(value));
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        this.setString(parameterId, String.valueOf(value));
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        this.setString(parameterName, String.valueOf(value));
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        this.setString(parameterId, String.valueOf(value));
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        this.setString(parameterName, String.valueOf(value));
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        this.setString(parameterId, String.valueOf(value));
    }

    public void setObject(int parameterId, Object value) throws OdaException {
        this.setString(parameterId, String.valueOf(value));
    }

    public void setObject(String parameterName, Object value) throws OdaException {
        this.setString(parameterName, String.valueOf(value));
    }

    public void setNull(String parameterName) throws OdaException {
        this.setString(parameterName, "");
    }

    public void setNull(int parameterId) throws OdaException {
        this.setString(parameterId, "");
    }

    public int findInParameter(String parameterName) throws OdaException {
        if (this.mt == null) {
            return -1;
        }
        int i = 0;
        while (i < this.mt.getParameters().length) {
            if (this.mt.getParameters()[i].equals(parameterName)) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        if (this.mt == null) {
            return null;
        }
        return new IParameterMetaData(){

            public int getParameterCount() throws OdaException {
                return Query.this.mt.getParameters().length;
            }

            public int getParameterMode(int param) throws OdaException {
                return 1;
            }

            public String getParameterName(int param) throws OdaException {
                return Query.this.mt.getParameters()[param - 1];
            }

            public int getParameterType(int param) throws OdaException {
                return 12;
            }

            public String getParameterTypeName(int param) throws OdaException {
                return DataTypes.getTypeString(12);
            }

            public int getPrecision(int param) throws OdaException {
                return -1;
            }

            public int getScale(int param) throws OdaException {
                return -1;
            }

            public int isNullable(int param) throws OdaException {
                return 0;
            }
        };
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public String getEffectiveQueryText() {
        throw new UnsupportedOperationException();
    }

    public QuerySpecification getSpecification() {
        return null;
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void cancel() throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setAppContext(Object context) throws OdaException {
        throw new UnsupportedOperationException();
    }

    private void testClosed() throws OdaException {
        if (this.isClosed) {
            throw new OdaException(Messages.getString("Query.ResultSetClosed"));
        }
    }
}

