/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile.util;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.sql.Time;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;
import org.eclipse.datatools.connectivity.oda.flatfile.util.DateFormatFactory;
import org.eclipse.datatools.connectivity.oda.flatfile.util.DateFormatISO8601;

public final class DateUtil {
    private static ULocale DEFAULT_LOCALE = ULocale.US;
    private static ULocale JRE_DEFAULT_LOCALE = ULocale.getDefault();
    private static SimpleDateFormat MysqlUSDateFormatter = new SimpleDateFormat("M/d/yyyy HH:mm");
    private static int DEFAULT_DATE_STYLE = 2;
    private static Pattern p1 = Pattern.compile(".*[0-9]+:[0-9]+:[0-9]+.*");
    private static Pattern p2 = Pattern.compile(".*[0-9]+:[0-9]+.*");
    private static DateFormat cachedDateFormat = null;

    public static Date toDate(Object source) throws OdaException {
        if (source == null) {
            return null;
        }
        if (source instanceof Date) {
            return new Date(((Date)source).getTime());
        }
        if (source instanceof String) {
            return DateUtil.toDate((String)source);
        }
        throw new OdaException(String.valueOf(Messages.getString("dateUtil.ConvertFails")) + source.toString());
    }

    public static Time toSqlTime(Object source) throws OdaException {
        if (source == null) {
            return null;
        }
        if (source instanceof Date) {
            return DateUtil.toSqlTime((Date)source);
        }
        if (source instanceof String) {
            try {
                return DateUtil.toSqlTime(DateUtil.toDate((String)source));
            }
            catch (Exception exception) {
                try {
                    return DateUtil.toSqlTime((String)source);
                }
                catch (Exception exception2) {}
            }
        }
        throw new OdaException(String.valueOf(Messages.getString("dateUtil.ConvertFails")) + source.toString());
    }

    private static Time toSqlTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(date.getTime());
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(14, 0);
        return new Time(calendar.getTimeInMillis());
    }

    private static Time toSqlTime(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        int firstColon = s.indexOf(58);
        int secondColon = s.indexOf(58, firstColon + 1);
        int marker = secondColon + 1;
        while (marker < s.length()) {
            if (!DateUtil.isDigitTen(s.charAt(marker))) break;
            ++marker;
        }
        int addHour = 0;
        String markerValue = null;
        if (marker < s.length()) {
            markerValue = s.substring(marker).trim();
            if ("am".compareToIgnoreCase(markerValue) == 0) {
                addHour = 0;
            } else if ("pm".compareToIgnoreCase(markerValue) == 0) {
                addHour = 12;
            } else {
                throw new IllegalArgumentException();
            }
        }
        if (firstColon <= 0 || secondColon <= 0 || secondColon >= s.length() - 1) {
            throw new IllegalArgumentException();
        }
        int hour = Integer.parseInt(s.substring(0, firstColon));
        if (hour < 0 || hour > 12 && markerValue != null && markerValue.length() > 0) {
            throw new IllegalArgumentException();
        }
        if ((hour += addHour) > 24) {
            throw new IllegalArgumentException();
        }
        int minute = Integer.parseInt(s.substring(firstColon + 1, secondColon));
        if (minute < 0 || minute > 60) {
            throw new IllegalArgumentException();
        }
        int second = marker < s.length() ? Integer.parseInt(s.substring(secondColon + 1, marker)) : Integer.parseInt(s.substring(secondColon + 1));
        if (second < 0 || second > 60) {
            throw new IllegalArgumentException();
        }
        return DateUtil.toSqlTime(hour, minute, second);
    }

    private static boolean isDigitTen(char c) {
        return c <= '9' && c >= '0';
    }

    private static Time toSqlTime(int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        return new Time(calendar.getTimeInMillis());
    }

    public static java.sql.Date toSqlDate(Object source) throws OdaException {
        if (source == null) {
            return null;
        }
        if (source instanceof Date) {
            return DateUtil.toSqlDate((Date)source);
        }
        if (source instanceof String) {
            try {
                return DateUtil.toSqlDate(DateUtil.toDate((String)source));
            }
            catch (Exception exception) {
                try {
                    return java.sql.Date.valueOf((String)source);
                }
                catch (Exception exception2) {}
            }
        }
        throw new OdaException(String.valueOf(Messages.getString("dateUtil.ConvertFails")) + source.toString());
    }

    private static java.sql.Date toSqlDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(date.getTime());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new java.sql.Date(calendar.getTimeInMillis());
    }

    public static Date toDate(String source, Locale locale) throws OdaException {
        return DateUtil.toDate(source, ULocale.forLocale((Locale)locale));
    }

    public static Date toDate(String source, ULocale locale) throws OdaException {
        boolean existTime;
        if (source == null) {
            return null;
        }
        DateFormat dateFormat = null;
        Date resultDate = null;
        boolean bl = existTime = p1.matcher(source).matches() || p2.matcher(source).matches();
        if (cachedDateFormat != null) {
            try {
                resultDate = cachedDateFormat.parse(source);
                return resultDate;
            }
            catch (ParseException parseException) {
                cachedDateFormat = null;
            }
        }
        int i = DEFAULT_DATE_STYLE;
        while (i <= 3) {
            int j = DEFAULT_DATE_STYLE;
            while (j <= 3) {
                dateFormat = DateFormatFactory.getDateTimeInstance(i, j, locale);
                try {
                    resultDate = dateFormat.parse(source);
                    cachedDateFormat = dateFormat;
                    return resultDate;
                }
                catch (ParseException parseException) {
                    ++j;
                }
            }
            if (!existTime) {
                dateFormat = DateFormatFactory.getDateInstance(i, locale);
                try {
                    resultDate = dateFormat.parse(source);
                    return resultDate;
                }
                catch (ParseException parseException) {}
            }
            ++i;
        }
        throw new OdaException(String.valueOf(Messages.getString("dateUtil.ConvertFails")) + source.toString());
    }

    private static Date toDate(String source) throws OdaException {
        try {
            return DateUtil.toDateISO8601(source);
        }
        catch (OdaException odaException) {
            try {
                return DateUtil.toDate(source, JRE_DEFAULT_LOCALE);
            }
            catch (OdaException odaException2) {
                try {
                    return DateUtil.toDate(source, DEFAULT_LOCALE);
                }
                catch (OdaException odaException3) {
                    return DateUtil.toDateForSpecialFormat(source);
                }
            }
        }
    }

    private static Date toDateForSpecialFormat(String source) throws OdaException {
        try {
            return MysqlUSDateFormatter.parse(source);
        }
        catch (ParseException parseException) {
            throw new OdaException(String.valueOf(Messages.getString("dateUtil.ConvertFails")) + source.toString());
        }
    }

    private static Date toDateISO8601(String source) throws OdaException {
        Date resultDate = null;
        try {
            resultDate = DateFormatISO8601.parse(source);
            return resultDate;
        }
        catch (ParseException parseException) {
            throw new OdaException(String.valueOf(Messages.getString("dateUtil.ConvertFails")) + source.toString());
        }
    }
}

