/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ase.catalog.ASEUtil;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalog;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogDatabase;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASERoleImpl;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogRole
extends SybaseASERoleImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = 2894870535821570588L;
    private SybaseASECatalogDatabase database;
    private Map privilegesMap = Collections.synchronizedMap(new HashMap());
    private Boolean recievedPrivilegeLoaded = Boolean.FALSE;

    public SybaseASECatalogRole(SybaseASECatalogDatabase database) {
        this.database = database;
    }

    public Database getCatalogDatabase() {
        return this.database;
    }

    public Connection getConnection() {
        return this.database.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.recievedPrivilegeLoaded;
        synchronized (bl) {
            this.recievedPrivilegeLoaded = Boolean.FALSE;
            super.getReceivedPrivilege().clear();
        }
        this.privilegesMap.clear();
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 13: {
                this.getReceivedPrivilege();
            }
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getReceivedPrivilege() {
        Boolean bl = this.recievedPrivilegeLoaded;
        synchronized (bl) {
            if (!this.recievedPrivilegeLoaded.booleanValue()) {
                this.loadRecievedPrivilege();
            }
        }
        return super.getReceivedPrivilege();
    }

    private void loadRecievedPrivilege() {
        if (this.recievedPrivilegeLoaded.booleanValue()) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        EList recievedPrivileges = super.getReceivedPrivilege();
        recievedPrivileges.clear();
        EList catalogList = this.getCatalogDatabase().getCatalogs();
        int i = 0;
        while (i < catalogList.size()) {
            Catalog catalog = (Catalog)catalogList.get(i);
            recievedPrivileges.addAll((Collection)this.getReceivedPrivileges(catalog.getName()));
            ++i;
        }
        this.eSetDeliver(deliver);
        this.recievedPrivilegeLoaded = Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getReceivedPrivileges(String catalogName) {
        Map map = this.privilegesMap;
        synchronized (map) {
            List privileges = (List)this.privilegesMap.get(catalogName);
            if (privileges == null) {
                privileges = this.loadPrivileges(catalogName);
            }
            return privileges;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReceivedPrivileges(String catalogName) {
        Map map = this.privilegesMap;
        synchronized (map) {
            this.privilegesMap.remove(catalogName);
        }
    }

    private List loadPrivileges(String catalogName) {
        SybaseASECatalog cfr_ignored_0 = (SybaseASECatalog)ASEUtil.getSQLObject((Collection)this.database.getCatalogs(), catalogName);
        ArrayList privileges = new ArrayList();
        this.privilegesMap.put(catalogName, privileges);
        return privileges;
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }
}

