/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.criteria;

import java.util.Iterator;
import org.eclipse.datatools.modelbase.sql.query.Predicate;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.views.criteria.CriteriaElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class RemoveCriteriaAction
extends Action {
    TableViewer gridViewer;

    public RemoveCriteriaAction(TableViewer gridViewer) {
        super(Messages._UI_ACTION_REMOVE_CONDITION);
        this.gridViewer = gridViewer;
    }

    public void run() {
        ISelection selection = this.gridViewer.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection es = (IStructuredSelection)selection;
        Iterator elements = es.iterator();
        this.gridViewer.cancelEditing();
        while (elements.hasNext()) {
            Object item = elements.next();
            if (!(item instanceof CriteriaElement)) continue;
            this.removeCriteria((CriteriaElement)item);
        }
    }

    private void removeCriteria(CriteriaElement criteriaElement) {
        QuerySearchCondition searchCondition = criteriaElement.getSearchCondition();
        Predicate cond = criteriaElement.getCurrentPredicate();
        SQLQueryObject currStmt = criteriaElement.getSQLStatement();
        if (searchCondition != null && cond != null) {
            criteriaElement.getSearchConditionHelper().removePredicateFromCondition(cond, searchCondition, currStmt);
            if (currStmt instanceof QuerySelectStatement || currStmt instanceof QuerySelect) {
                SelectHelper.refresh(currStmt);
            }
            return;
        }
    }
}

