/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.mapping.util;

import org.eclipse.emf.diffmerge.bridge.api.ICause;
import org.eclipse.emf.diffmerge.bridge.impl.emf.EMFSymbolFunction;
import org.eclipse.emf.diffmerge.bridge.util.BaseTraceLoggingMessage;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceLoggingMessage
extends BaseTraceLoggingMessage {
    public TraceLoggingMessage(Object target_p, ICause<?> cause_p) {
        super(target_p, cause_p);
    }

    protected String getPrefix() {
        return "\t|\t|__Produced ";
    }

    protected String getMessageBody() {
        StringBuilder builder = new StringBuilder("(");
        builder.append(this.getTarget().getClass().getSimpleName()).append(" \"");
        builder.append(this.getObjectLabel(this.getTarget())).append("\"");
        EMFSymbolFunction function = EMFSymbolFunction.getInstance();
        builder.append("[").append(function.getSymbol(this.getTarget())).append("]");
        builder.append(") From {");
        for (Object source : this.getCause().getSourceElements()) {
            String sourceName = this.getObjectLabel(source);
            String sourceType = source instanceof EObject ? ((EObject)source).eClass().getName() : source.getClass().getSimpleName();
            builder.append("(");
            builder.append(sourceType).append(" \"");
            builder.append(sourceName).append("\"");
            builder.append("[").append(function.getSymbol(source)).append("])");
        }
        builder.append("}");
        return builder.toString();
    }
}

