/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AdditionKind implements Enumerator
{
    FORBIDDEN(0, "FORBIDDEN", "FORBIDDEN"),
    PREFERRED_CONTAINMENT(0, "PREFERRED_CONTAINMENT", "PREFERRED_CONTAINMENT"),
    ANY_CONTAINMENT(0, "ANY_CONTAINMENT", "ANY_CONTAINMENT"),
    ANY_STORAGE(0, "ANY_STORAGE", "ANY_STORAGE");

    public static final int FORBIDDEN_VALUE = 0;
    public static final int PREFERRED_CONTAINMENT_VALUE = 0;
    public static final int ANY_CONTAINMENT_VALUE = 0;
    public static final int ANY_STORAGE_VALUE = 0;
    private static final AdditionKind[] VALUES_ARRAY;
    public static final List<AdditionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AdditionKind[]{FORBIDDEN, PREFERRED_CONTAINMENT, ANY_CONTAINMENT, ANY_STORAGE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AdditionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AdditionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AdditionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AdditionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AdditionKind get(int value) {
        switch (value) {
            case 0: {
                return FORBIDDEN;
            }
        }
        return null;
    }

    private AdditionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

