/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.scopes;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.scopes.IFragmentedModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.AbstractEditableModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.DynamicUniqueListIterator;
import org.eclipse.emf.diffmerge.impl.scopes.MultiResourceTreeIterator;
import org.eclipse.emf.diffmerge.structures.binary.HashBinaryRelation;
import org.eclipse.emf.diffmerge.structures.binary.IBinaryRelation;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.diffmerge.util.ModelImplUtil;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;

public class FragmentedModelScope
extends AbstractEditableModelScope
implements IFragmentedModelScope.Editable,
IEditingDomainProvider {
    private final boolean _isReadOnly;
    protected EditingDomain _editingDomain;
    protected final ResourceSet _resourceSet;
    protected InputStream _loadingStream = null;
    protected final List<Resource> _resources;
    protected final List<Resource> _rootResources;
    protected final Set<Resource> _initiallyPresentResources;
    protected final Set<Resource> _loadedResources;
    protected final IBinaryRelation.Editable<Resource, Resource> _includedResources;
    protected final IBinaryRelation.Editable<Resource, Resource> _referencedResources;
    protected ScopeState _state = ScopeState.INITIALIZED;

    public FragmentedModelScope(Resource resource_p, boolean readOnly_p) {
        this(resource_p.getURI(), resource_p.getResourceSet(), readOnly_p);
    }

    public FragmentedModelScope(URI uri_p, EditingDomain editingDomain_p, boolean readOnly_p) {
        this(Collections.singleton(uri_p), editingDomain_p, readOnly_p);
    }

    public FragmentedModelScope(URI uri_p, ResourceSet resourceSet_p, boolean readOnly_p) {
        this(Collections.singleton(uri_p), resourceSet_p, readOnly_p);
    }

    public FragmentedModelScope(Collection<URI> uris_p, EditingDomain editingDomain_p, boolean readOnly_p) {
        this(uris_p, editingDomain_p.getResourceSet(), readOnly_p);
        this._editingDomain = editingDomain_p;
    }

    public FragmentedModelScope(Collection<URI> uris_p, ResourceSet resourceSet_p, boolean readOnly_p) {
        this(resourceSet_p, readOnly_p);
        for (URI uri : uris_p) {
            Resource rootResource = this.getResourceFromURI(this._resourceSet, uri);
            if (rootResource == null) continue;
            this._rootResources.add(rootResource);
            this.addNewResource(rootResource);
        }
    }

    protected FragmentedModelScope(ResourceSet resourceSet_p, boolean readOnly_p) {
        this._isReadOnly = readOnly_p;
        this._resourceSet = resourceSet_p;
        this._resources = new ArrayList<Resource>();
        this._rootResources = new ArrayList<Resource>();
        this._includedResources = new HashBinaryRelation();
        this._referencedResources = new HashBinaryRelation();
        this._initiallyPresentResources = new HashSet<Resource>();
        this._initiallyPresentResources.addAll((Collection<Resource>)this._resourceSet.getResources());
        this._loadedResources = new HashSet<Resource>();
        if (this._resourceSet instanceof IEditingDomainProvider) {
            this._editingDomain = ((IEditingDomainProvider)this._resourceSet).getEditingDomain();
        }
    }

    @Override
    public boolean add(EObject element_p) {
        boolean result = false;
        Resource defaultResource = this.getResourceForNewRoot(element_p);
        if (defaultResource != null) {
            defaultResource.getContents().add((Object)element_p);
            result = true;
        }
        return result;
    }

    @Override
    public boolean add(EObject source_p, EReference reference_p, EObject value_p) {
        Resource oldResource = value_p.eResource();
        boolean wasRoot = oldResource != null && oldResource.getContents().contains((Object)value_p);
        Object formerId = this.getExtrinsicID(value_p);
        boolean result = super.add(source_p, reference_p, value_p);
        if (wasRoot && reference_p.isContainment()) {
            oldResource.getContents().remove((Object)value_p);
        }
        if (formerId != null) {
            this.setExtrinsicID(value_p, formerId);
        }
        return result;
    }

    protected void addNewResource(Resource resource_p) {
        this._resources.add(resource_p);
        if (!this._initiallyPresentResources.contains(resource_p)) {
            this._loadedResources.add(resource_p);
        }
    }

    protected boolean containsUnnecessaryProxies(Collection<EObject> collection_p, EObject source_p) {
        for (EObject current : collection_p) {
            if (!current.eIsProxy() || current == ModelImplUtil.resolveIfLoaded(current, source_p)) continue;
            return true;
        }
        return false;
    }

    protected void explorationFinished() {
        AdapterFactoryEditingDomain afEditingDomain;
        Map readOnlyMap;
        this._state = ScopeState.FULLY_EXPLORED;
        this._loadedResources.addAll((Collection<Resource>)this._resourceSet.getResources());
        this._loadedResources.removeAll(this._initiallyPresentResources);
        this._initiallyPresentResources.clear();
        if (this.isReadOnly() && this._editingDomain instanceof AdapterFactoryEditingDomain && (readOnlyMap = (afEditingDomain = (AdapterFactoryEditingDomain)this._editingDomain).getResourceToReadOnlyMap()) != null) {
            for (Resource loadedResource : this._loadedResources) {
                readOnlyMap.put(loadedResource, Boolean.TRUE);
            }
        }
    }

    @Override
    public List<EObject> get(EObject source_p, EReference reference_p) {
        List<EObject> result = super.get(source_p, reference_p);
        boolean requiresResolution = this.containsUnnecessaryProxies(result, source_p);
        if (requiresResolution) {
            result = this.get(source_p, reference_p, true);
        }
        return result;
    }

    @Override
    public TreeIterator<EObject> getAllContents() {
        return new ExpandingMultiResourceTreeIterator();
    }

    @Override
    public List<EObject> getContents() {
        return this.getRawContents();
    }

    protected Collection<EReference> getCrossReferencesInScope(EObject element_p) {
        return new ArrayList<EReference>();
    }

    @Override
    protected Object getDefaultOriginator() {
        return this.getHoldingResource();
    }

    public EditingDomain getEditingDomain() {
        return this._editingDomain;
    }

    @Override
    public Object getExtrinsicID(EObject element_p) {
        return super.getExtrinsicID(element_p);
    }

    @Override
    public Resource getHoldingResource() {
        return this._rootResources.isEmpty() ? null : this._rootResources.get(0);
    }

    @Override
    public Collection<Resource> getIncludedResources(Resource resource_p) {
        return this._includedResources.get((Object)resource_p);
    }

    protected Map<Object, Object> getLoadOptions(Resource resource_p) {
        return new HashMap<Object, Object>();
    }

    @Override
    public List<EObject> getRawContents() {
        FArrayList result = new FArrayList();
        for (Resource resource : this._rootResources) {
            result.addAll(resource.getContents());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<Resource> getReferencedResources(Resource resource_p) {
        return this._referencedResources.get((Object)resource_p);
    }

    @Override
    public List<Resource> getRootResources() {
        return Collections.unmodifiableList(this._rootResources);
    }

    protected List<Resource> getRelevantReferencedResources(EObject element_p) {
        FOrderedSet result = new FOrderedSet();
        Collection<EReference> refsInScope = this.getCrossReferencesInScope(element_p);
        for (EReference ref : refsInScope) {
            if (ref.isContainment() || ref.isContainer() || !element_p.eIsSet((EStructuralFeature)ref)) continue;
            List<EObject> values = this.get(element_p, ref, true);
            for (EObject value : values) {
                Resource valueResource = value.eResource();
                if (valueResource == null) continue;
                result.add(valueResource);
            }
        }
        return result;
    }

    protected Resource getResourceForNewRoot(EObject newRoot_p) {
        for (Resource resource : this._resources) {
            if (!this.isSuitableFor(resource, newRoot_p)) continue;
            return resource;
        }
        return null;
    }

    protected Resource getResourceFromURI(ResourceSet resourceSet_p, URI uri_p) {
        Resource rootResource = resourceSet_p.getResource(uri_p, false);
        if (rootResource == null) {
            rootResource = resourceSet_p.createResource(uri_p);
        }
        return rootResource;
    }

    @Override
    public List<Resource> getResources() {
        return Collections.unmodifiableList(this._resources);
    }

    @Override
    public boolean isFullyExplored() {
        return this._state == ScopeState.FULLY_EXPLORED;
    }

    @Override
    public boolean isLoaded() {
        return this._state != ScopeState.INITIALIZED && this._state != ScopeState.UNLOADED;
    }

    @Override
    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    protected boolean isSuitableFor(Resource resource_p, EObject root_p) {
        return true;
    }

    @Override
    public boolean load() throws Exception {
        boolean result = false;
        if (this._state == ScopeState.INITIALIZED || this._state == ScopeState.LOADED) {
            if (this._loadingStream != null) {
                result = this.loadFromStream(this._loadingStream);
            } else {
                result = true;
                for (Resource rootResource : this._rootResources) {
                    boolean bl = result = result && this.loadResource(rootResource);
                }
            }
            this._state = ScopeState.LOADED;
        }
        return result;
    }

    protected boolean loadFromStream(InputStream stream_p) throws Exception {
        boolean result = false;
        Resource holdingResource = this.getHoldingResource();
        if (holdingResource != null) {
            Map<Object, Object> options = this.getLoadOptions(holdingResource);
            holdingResource.load(stream_p, options);
            result = true;
        }
        return result;
    }

    protected boolean loadResource(Resource resource_p) throws Exception {
        Map<Object, Object> options = this.getLoadOptions(resource_p);
        resource_p.load(options);
        return true;
    }

    protected void notifyExplored(EObject element_p) {
    }

    protected void notifyInclusion(Resource including_p, Resource included_p) {
        if (!this._resources.contains(included_p)) {
            this.addNewResource(included_p);
        }
        this._includedResources.add((Object)including_p, (Object)included_p);
        this._rootResources.remove(included_p);
        this._referencedResources.remove((Object)including_p, (Object)included_p);
    }

    protected void notifyReference(Resource source_p, Resource target_p) {
        if (!this._resources.contains(target_p)) {
            this.addNewResource(target_p);
            this._rootResources.add(target_p);
            this._referencedResources.add((Object)source_p, (Object)target_p);
        }
    }

    @Override
    public boolean save() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        for (Resource resource : this.getResources()) {
            resource.save(options);
        }
        return true;
    }

    @Override
    public boolean setExtrinsicID(EObject element_p, Object id_p) {
        return super.setExtrinsicID(element_p, id_p);
    }

    @Override
    public void setStream(InputStream stream_p) {
        this._loadingStream = stream_p;
    }

    @Override
    public List<Resource> unload() {
        ModelsUtil.Unloader.getDefault().unloadAdapters(this._loadedResources);
        for (Resource loadedResource : this._loadedResources) {
            this.unloadResource(loadedResource);
        }
        ArrayList<Resource> result = new ArrayList<Resource>(this._loadedResources);
        this._loadedResources.clear();
        if (!result.isEmpty()) {
            this._state = ScopeState.UNLOADED;
        }
        return result;
    }

    protected void unloadResource(Resource resource_p) {
        ModelsUtil.Unloader.getDefault().unloadResource(resource_p);
    }

    protected class ExpandingMultiResourceTreeIterator
    extends MultiResourceTreeIterator {
        protected final Set<Resource> _exploredResources;
        protected EObject _next;
        protected Resource _currentResource;
        protected boolean _finished;

        public ExpandingMultiResourceTreeIterator() {
            super(new DynamicUniqueListIterator<Resource>(FragmentedModelScope.this._resources));
            this._exploredResources = new LinkedHashSet<Resource>();
            this._next = null;
            this._currentResource = null;
            this._finished = false;
        }

        protected boolean checkNextResource() {
            boolean result = false;
            while ((this._contentIterator == null || !this._contentIterator.hasNext()) && this._resourceIterator.hasNext()) {
                result = true;
                Resource nextResource = (Resource)this._resourceIterator.next();
                if (this._exploredResources.contains(nextResource)) continue;
                this._contentIterator = nextResource.getAllContents();
            }
            return result;
        }

        @Override
        public boolean hasNext() {
            this.update();
            return this._next != null;
        }

        @Override
        public EObject next() {
            if (this.hasNext()) {
                EObject result = this._next;
                this._currentResource = this._next.eResource();
                this._next = null;
                if (!FragmentedModelScope.this.isFullyExplored()) {
                    FragmentedModelScope.this.notifyExplored(result);
                }
                return result;
            }
            throw new NoSuchElementException();
        }

        @Override
        protected void update() {
            while (this._next == null && !this._finished) {
                boolean firstExploration;
                boolean resourceChangedInList = this.checkNextResource();
                boolean bl = firstExploration = !FragmentedModelScope.this.isFullyExplored();
                if (this._contentIterator == null || !this._contentIterator.hasNext()) {
                    this._finished = true;
                    this._exploredResources.clear();
                    this._currentResource = null;
                    if (!firstExploration) continue;
                    FragmentedModelScope.this.explorationFinished();
                    continue;
                }
                EObject candidate = (EObject)this._contentIterator.next();
                boolean candidateOK = true;
                Resource candidateResource = candidate.eResource();
                if (candidateResource != null) {
                    EObject candidateContainer;
                    boolean resourceAlreadyExplored = !this._exploredResources.add(candidateResource);
                    boolean resourceChangedByInclusion = false;
                    Resource candidateContainerResource = null;
                    if (!resourceChangedInList && this._currentResource != null && this._currentResource != candidateResource && (candidateContainer = candidate.eContainer()) != null) {
                        candidateContainerResource = candidateContainer.eResource();
                        boolean bl2 = resourceChangedByInclusion = candidateContainerResource != null && candidateContainerResource != candidateResource;
                    }
                    if (resourceChangedByInclusion && firstExploration) {
                        FragmentedModelScope.this.notifyInclusion(candidateContainerResource, candidateResource);
                    }
                    if (resourceChangedByInclusion && resourceAlreadyExplored) {
                        this._contentIterator.prune();
                        candidateOK = false;
                    }
                }
                if (!candidateOK) continue;
                this._next = candidate;
                if (!firstExploration || candidateResource == null) continue;
                for (Resource additionalResource : FragmentedModelScope.this.getRelevantReferencedResources(this._next)) {
                    FragmentedModelScope.this.notifyReference(candidateResource, additionalResource);
                }
            }
        }
    }

    protected static enum ScopeState {
        INITIALIZED,
        LOADED,
        FULLY_EXPLORED,
        UNLOADED;

    }
}

