/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.wizards;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternProvider;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.IMultiRoleBasedSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.IMultiRoleSelection;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.ITemplatePatternSelection;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.providers.NameBasedLabelProvider;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.AbstractPatternPage;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.AbstractRoleBasedPage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public abstract class AbstractMultiRoleSelectionPage<T extends IMultiRoleBasedSpecification>
extends AbstractRoleBasedPage<T> {
    private boolean _alreadyShown = false;

    public AbstractMultiRoleSelectionPage(String pageName_p, String pageTitle_p, String defaultMessage_p, T data_p, boolean isBlocking_p) {
        super(pageName_p, pageTitle_p, defaultMessage_p, data_p, isBlocking_p);
    }

    protected Composite createRoleControls(Composite parent_p, boolean allowEdition_p) {
        Group result = this.createGroup(parent_p, Messages.AbstractMultiRoleSelectionPage_Roles, false, 2);
        this.createRoleList((Composite)result);
        return result;
    }

    private ListViewer createRoleList(Composite parent_p) {
        ListViewer result;
        org.eclipse.swt.widgets.List rolesList = new org.eclipse.swt.widgets.List(parent_p, 2818);
        GridData listData = new GridData(4, 4, true, true);
        listData.verticalSpan = 4;
        listData.widthHint = 150;
        rolesList.setLayoutData((Object)listData);
        this._rolesViewer = result = new ListViewer(rolesList);
        result.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement_p) {
                IPatternProvider input;
                Object[] elements = new Object[]{};
                if (inputElement_p instanceof IPatternProvider && (input = (IPatternProvider)inputElement_p).getPattern() != null) {
                    elements = input.getPattern().getRoles().toArray();
                }
                return elements;
            }
        });
        result.setInput(this.getData());
        result.setLabelProvider((IBaseLabelProvider)new AbstractRoleBasedPage.RoleViewerLabelProvider((ILabelProvider)NameBasedLabelProvider.getInstance()));
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                IStructuredSelection selection = (IStructuredSelection)event_p.getSelection();
                if (!(selection instanceof AbstractPatternPage.NonUserSelection)) {
                    ((IMultiRoleBasedSpecification)AbstractMultiRoleSelectionPage.this.getData()).setRoles((Collection)selection.toList());
                }
            }
        });
        ((IMultiRoleBasedSpecification)this.getData()).addSelectedRolesListener(new IMultiRoleSelection.IRolesChangedListener(){

            public void rolesChanged(Collection<? extends TemplatePatternRole> newRoles_p) {
                IStructuredSelection selection = (IStructuredSelection)result.getSelection();
                if (!selection.toList().equals(newRoles_p)) {
                    result.setSelection((ISelection)AbstractPatternPage.NonUserSelection.newInstance(newRoles_p));
                }
                result.refresh(true);
            }
        });
        if (this.getData() instanceof ITemplatePatternSelection) {
            ((ITemplatePatternSelection)this.getData()).addSelectedPatternListener(new ITemplatePatternSelection.IPatternChangedListener(){

                public void patternChanged(TemplatePattern newPattern_p) {
                    result.setInput(AbstractMultiRoleSelectionPage.this.getData());
                    ((IMultiRoleBasedSpecification)AbstractMultiRoleSelectionPage.this.getData()).setRoles(Collections.emptyList());
                }
            });
        }
        return result;
    }

    @Override
    public void setVisible(boolean visible_p) {
        super.setVisible(visible_p);
        if (!this._alreadyShown) {
            List<TemplatePatternRole> roles;
            this._alreadyShown = true;
            if (((IMultiRoleBasedSpecification)this.getData()).getRoles().isEmpty() && !(roles = this.getRoles()).isEmpty()) {
                this._rolesViewer.setSelection((ISelection)new StructuredSelection((Object)roles.get(0)));
            }
        }
    }
}

