/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.dialogs;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.StorageChoiceDialog;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MultiStorageChoiceDialog
extends StorageChoiceDialog {
    protected static MultiStorageKind __lastStorageKind = MultiStorageKind.ALL_SIMILAR;
    private MultiStorageKind _storageKind = __lastStorageKind;

    public MultiStorageChoiceDialog(Shell parentShell_p, String message_p, List<? extends EObject> proposed_p, EObject target_p) {
        super(parentShell_p, message_p, proposed_p, Collections.singletonList(target_p));
    }

    @Override
    protected Control createCustomArea(Composite parent_p) {
        Control result = super.createCustomArea(parent_p);
        Group applyGroup = new Group(parent_p, 0);
        GridData gd = new GridData(4, 4, true, false);
        applyGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(4, false);
        applyGroup.setLayout((Layout)layout);
        new Label((Composite)applyGroup, 0).setText(Messages.MultiStorageChoiceDialog_Target);
        Button elementButton = new Button((Composite)applyGroup, 16);
        elementButton.setText(Messages.MultiStorageChoiceDialog_Current);
        elementButton.setSelection(this._storageKind == MultiStorageKind.CURRENT_ONLY);
        elementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiStorageChoiceDialog.this.setStorageKind(MultiStorageKind.CURRENT_ONLY);
            }
        });
        Button similarButton = new Button((Composite)applyGroup, 16);
        similarButton.setText(Messages.MultiStorageChoiceDialog_Similar);
        similarButton.setSelection(this._storageKind == MultiStorageKind.ALL_SIMILAR);
        similarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiStorageChoiceDialog.this.setStorageKind(MultiStorageKind.ALL_SIMILAR);
            }
        });
        Button compatibleButton = new Button((Composite)applyGroup, 16);
        compatibleButton.setText(Messages.MultiStorageChoiceDialog_Compatible);
        compatibleButton.setSelection(this._storageKind == MultiStorageKind.ALL_COMPATIBLE);
        compatibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiStorageChoiceDialog.this.setStorageKind(MultiStorageKind.ALL_COMPATIBLE);
            }
        });
        return result;
    }

    public MultiStorageKind getStorageKind() {
        return this._storageKind;
    }

    public int open() {
        int result = super.open();
        if (result == 0) {
            __lastStorageKind = this.getStorageKind();
        }
        return result;
    }

    protected void setStorageKind(MultiStorageKind kind_p) {
        this._storageKind = kind_p;
    }

    public static enum MultiStorageKind {
        CURRENT_ONLY,
        ALL_SIMILAR,
        ALL_COMPATIBLE;

    }
}

