/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.generic.gdiffdata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.diffmerge.generic.api.IMapping;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IAttributeValuePresence;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.generic.api.diff.IElementRelativeDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IPresenceDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GComparison;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GMapping;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GMatch;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GMergeableDifference;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GdiffdataPackage;
import org.eclipse.emf.diffmerge.generic.gdiffdata.impl.GIdentifiedImpl;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class GMatchImpl<E, A, R>
extends GIdentifiedImpl
implements GMatch<E, A, R> {
    protected static final Object MATCH_ID_EDEFAULT = null;
    protected Object matchID = MATCH_ID_EDEFAULT;
    protected EList<GMergeableDifference<E, A, R>> modifiableRelatedDifferences;
    protected IElementPresence<E> elementPresenceDifference;
    protected IReferenceValuePresence<E> referenceOwnershipDifference;
    protected IReferenceValuePresence<E> targetOwnershipDifference;

    protected GMatchImpl() {
    }

    public GMatchImpl(E target_p, E reference_p, E ancestor_p) {
        this();
        this.setTarget(target_p);
        this.setReference(reference_p);
        this.setAncestor(ancestor_p);
    }

    @Override
    protected EClass eStaticClass() {
        return GdiffdataPackage.Literals.GMATCH;
    }

    @Override
    public Object getMatchID() {
        return this.matchID;
    }

    @Override
    public void setMatchID(Object newMatchID) {
        Object oldMatchID = this.matchID;
        this.matchID = newMatchID;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldMatchID, this.matchID));
        }
    }

    @Override
    public EList<GMergeableDifference<E, A, R>> getModifiableRelatedDifferences() {
        if (this.modifiableRelatedDifferences == null) {
            this.modifiableRelatedDifferences = new EObjectContainmentEList(GMergeableDifference.class, (InternalEObject)this, 2);
        }
        return this.modifiableRelatedDifferences;
    }

    @Override
    public GMapping<E, A, R> getMapping() {
        GMapping result = null;
        EObject container = this.eContainer();
        if (container instanceof GMapping) {
            result = (GMapping)container;
        }
        return result;
    }

    @Override
    public abstract E getAncestor();

    @Override
    public abstract E getReference();

    @Override
    public abstract E getTarget();

    @Override
    public abstract void setAncestor(E var1);

    @Override
    public abstract void setReference(E var1);

    @Override
    public abstract void setTarget(E var1);

    @Override
    public GComparison<E, A, R> getComparison() {
        GComparison result = null;
        IMapping mapping = this.getMapping();
        if (mapping != null) {
            result = mapping.getComparison();
        }
        return result;
    }

    @Override
    public IElementPresence<E> getElementPresenceDifference() {
        if (this.elementPresenceDifference != null && ((EObject)this.elementPresenceDifference).eIsProxy()) {
            InternalEObject oldElementPresenceDifference = (InternalEObject)this.elementPresenceDifference;
            this.elementPresenceDifference = (IElementPresence)this.eResolveProxy(oldElementPresenceDifference);
            if (this.elementPresenceDifference != oldElementPresenceDifference && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldElementPresenceDifference, this.elementPresenceDifference));
            }
        }
        return this.elementPresenceDifference;
    }

    public IElementPresence<E> basicGetElementPresenceDifference() {
        return this.elementPresenceDifference;
    }

    @Override
    public void setElementPresenceDifference(IElementPresence<E> newElementPresenceDifference) {
        IElementPresence<E> oldElementPresenceDifference = this.elementPresenceDifference;
        this.elementPresenceDifference = newElementPresenceDifference;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldElementPresenceDifference, this.elementPresenceDifference));
        }
    }

    @Override
    public IReferenceValuePresence<E> getReferenceOwnershipDifference() {
        if (this.referenceOwnershipDifference != null && ((EObject)this.referenceOwnershipDifference).eIsProxy()) {
            InternalEObject oldReferenceOwnershipDifference = (InternalEObject)this.referenceOwnershipDifference;
            this.referenceOwnershipDifference = (IReferenceValuePresence)this.eResolveProxy(oldReferenceOwnershipDifference);
            if (this.referenceOwnershipDifference != oldReferenceOwnershipDifference && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldReferenceOwnershipDifference, this.referenceOwnershipDifference));
            }
        }
        return this.referenceOwnershipDifference;
    }

    public IReferenceValuePresence<E> basicGetReferenceOwnershipDifference() {
        return this.referenceOwnershipDifference;
    }

    @Override
    public void setReferenceOwnershipDifference(IReferenceValuePresence<E> newReferenceOwnershipDifference) {
        IReferenceValuePresence<E> oldReferenceOwnershipDifference = this.referenceOwnershipDifference;
        this.referenceOwnershipDifference = newReferenceOwnershipDifference;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldReferenceOwnershipDifference, this.referenceOwnershipDifference));
        }
    }

    @Override
    public IReferenceValuePresence<E> getTargetOwnershipDifference() {
        if (this.targetOwnershipDifference != null && ((EObject)this.targetOwnershipDifference).eIsProxy()) {
            InternalEObject oldTargetOwnershipDifference = (InternalEObject)this.targetOwnershipDifference;
            this.targetOwnershipDifference = (IReferenceValuePresence)this.eResolveProxy(oldTargetOwnershipDifference);
            if (this.targetOwnershipDifference != oldTargetOwnershipDifference && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldTargetOwnershipDifference, this.targetOwnershipDifference));
            }
        }
        return this.targetOwnershipDifference;
    }

    public IReferenceValuePresence<E> basicGetTargetOwnershipDifference() {
        return this.targetOwnershipDifference;
    }

    @Override
    public void setTargetOwnershipDifference(IReferenceValuePresence<E> newTargetOwnershipDifference) {
        IReferenceValuePresence<E> oldTargetOwnershipDifference = this.targetOwnershipDifference;
        this.targetOwnershipDifference = newTargetOwnershipDifference;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldTargetOwnershipDifference, this.targetOwnershipDifference));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getModifiableRelatedDifferences()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getMatchID();
            }
            case 2: {
                return this.getModifiableRelatedDifferences();
            }
            case 3: {
                if (resolve) {
                    return this.getElementPresenceDifference();
                }
                return this.basicGetElementPresenceDifference();
            }
            case 4: {
                if (resolve) {
                    return this.getReferenceOwnershipDifference();
                }
                return this.basicGetReferenceOwnershipDifference();
            }
            case 5: {
                if (resolve) {
                    return this.getTargetOwnershipDifference();
                }
                return this.basicGetTargetOwnershipDifference();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setMatchID(newValue);
                return;
            }
            case 2: {
                this.getModifiableRelatedDifferences().clear();
                this.getModifiableRelatedDifferences().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setElementPresenceDifference((IElementPresence)newValue);
                return;
            }
            case 4: {
                this.setReferenceOwnershipDifference((IReferenceValuePresence)newValue);
                return;
            }
            case 5: {
                this.setTargetOwnershipDifference((IReferenceValuePresence)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setMatchID(MATCH_ID_EDEFAULT);
                return;
            }
            case 2: {
                this.getModifiableRelatedDifferences().clear();
                return;
            }
            case 3: {
                this.setElementPresenceDifference(null);
                return;
            }
            case 4: {
                this.setReferenceOwnershipDifference(null);
                return;
            }
            case 5: {
                this.setTargetOwnershipDifference(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return MATCH_ID_EDEFAULT == null ? this.matchID != null : !MATCH_ID_EDEFAULT.equals(this.matchID);
            }
            case 2: {
                return this.modifiableRelatedDifferences != null && !this.modifiableRelatedDifferences.isEmpty();
            }
            case 3: {
                return this.elementPresenceDifference != null;
            }
            case 4: {
                return this.referenceOwnershipDifference != null;
            }
            case 5: {
                return this.targetOwnershipDifference != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (matchID: ");
        result.append(this.matchID);
        result.append(')');
        return result.toString();
    }

    protected void addAttributeValuePresence(IAttributeValuePresence<E> presence_p) {
        EMap<?, EList<IAttributeValuePresence<?>>> attributeMap = this.getModifiableAttributeMap(true);
        EList<IAttributeValuePresence<E>> forAttribute = (EList<IAttributeValuePresence<E>>)attributeMap.get(presence_p.getFeature());
        if (forAttribute == null) {
            forAttribute = this.newAttributeValuePresenceList(presence_p.getFeature());
        }
        forAttribute.add(presence_p);
    }

    @Override
    public void addOwnershipDifference(IReferenceValuePresence<E> presence_p) {
        if (Role.TARGET == presence_p.getPresenceRole()) {
            this.setTargetOwnershipDifference(presence_p);
        } else {
            this.setReferenceOwnershipDifference(presence_p);
        }
    }

    protected void addReferenceOrderDifference(IReferenceValuePresence<E> presence_p) {
        assert (presence_p.getElementMatch() == this && presence_p.isOrder());
        EMap<?, EList<IReferenceValuePresence<?>>> referenceMap = this.getModifiableOrderReferenceMap(true);
        EList<IReferenceValuePresence<IReferenceValuePresence<E>>> forReference = (EList<IReferenceValuePresence<IReferenceValuePresence<E>>>)referenceMap.get(presence_p.getFeature());
        if (forReference == null) {
            forReference = this.newReferenceOrderDifferenceList(presence_p.getFeature());
        }
        forReference.add(presence_p);
    }

    protected void addReferenceValuePresence(IReferenceValuePresence<E> presence_p) {
        assert (presence_p.getElementMatch() == this && !presence_p.isOrder());
        EMap<?, EMap<?, IReferenceValuePresence<?>>> referenceMap = this.getModifiableReferenceMap(true);
        EMap<E, IReferenceValuePresence<E>> forReference = (EMap<E, IReferenceValuePresence<E>>)referenceMap.get(presence_p.getFeature());
        if (forReference == null) {
            forReference = this.newReferenceValueToPresenceMap(presence_p.getFeature());
        }
        E key = presence_p.getValue();
        forReference.put(key, presence_p);
    }

    @Override
    public void addRelatedDifference(IDifference<E> difference_p) {
        assert (difference_p != null);
        List<GMergeableDifference<IDifference<E>, A, R>> differences = this.getModifiableRelatedDifferences(true);
        if (!differences.contains(difference_p)) {
            differences.add((GMergeableDifference<IDifference<E>, A, R>)difference_p);
            if (difference_p instanceof IElementPresence) {
                this.setElementPresenceDifference((IElementPresence)difference_p);
            } else if (difference_p instanceof IReferenceValuePresence) {
                IReferenceValuePresence presence = (IReferenceValuePresence)difference_p;
                if (presence.isOrder()) {
                    this.addReferenceOrderDifference(presence);
                } else {
                    IMatch valueMatch;
                    this.addReferenceValuePresence(presence);
                    if (presence.isOwnership() && (valueMatch = presence.getValueMatch()) != null) {
                        ((IMatch.Editable)valueMatch).addOwnershipDifference(presence);
                    }
                }
            } else if (difference_p instanceof IAttributeValuePresence) {
                this.addAttributeValuePresence((IAttributeValuePresence)difference_p);
            }
        }
    }

    @Override
    public boolean coversRole(Role role_p) {
        return this.get(role_p) != null;
    }

    @Override
    public E get(Role role_p) {
        E result;
        switch (role_p) {
            case TARGET: {
                result = this.getTarget();
                break;
            }
            case REFERENCE: {
                result = this.getReference();
                break;
            }
            default: {
                result = this.getAncestor();
            }
        }
        return result;
    }

    @Override
    public List<IDifference<E>> getAllDifferences() {
        IReferenceValuePresence<E> referenceOwnership;
        FArrayList result = new FArrayList(this.getRelatedDifferences(), null);
        IReferenceValuePresence<E> targetOwnership = this.getOwnershipDifference(Role.TARGET);
        if (targetOwnership != null) {
            result.add(targetOwnership);
        }
        if ((referenceOwnership = this.getOwnershipDifference(Role.REFERENCE)) != null) {
            result.add(referenceOwnership);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<IAttributeValuePresence<E>> getAttributeDifferences(Object attribute_p) {
        EList forAttribute;
        Collection<IAttributeValuePresence<Object>> result = null;
        if (this.getModifiableAttributeMap(false) != null && (forAttribute = (EList)this.getModifiableAttributeMap(false).get(attribute_p)) != null) {
            result = Collections.unmodifiableCollection(forAttribute);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public IAttributeValuePresence<E> getAttributeOrderDifference(Object attribute_p, Role role_p) {
        List forAttribute;
        IAttributeValuePresence result = null;
        EMap<?, EList<IAttributeValuePresence<?>>> attributeMap = this.getModifiableAttributeMap(false);
        if (attributeMap != null && (forAttribute = (List)attributeMap.get(attribute_p)) != null) {
            for (IAttributeValuePresence current : forAttribute) {
                if (!current.isOrder() || current.getPresenceRole() != role_p) continue;
                result = current;
                break;
            }
        }
        return result;
    }

    @Override
    public IAttributeValuePresence<E> getAttributeValueDifference(Object attribute_p, Object value_p) {
        List forAttribute;
        IAttributeValuePresence result = null;
        if (this.getModifiableAttributeMap(false) != null && (forAttribute = (List)this.getModifiableAttributeMap(false).get(attribute_p)) != null) {
            for (IAttributeValuePresence current : forAttribute) {
                if (!value_p.equals(current.getValue())) continue;
                result = current;
                break;
            }
        }
        return result;
    }

    @Override
    public Collection<Object> getAttributesWithDifferences() {
        Set<Object> result = this.getModifiableAttributeMap(false) == null ? Collections.emptySet() : Collections.unmodifiableSet(this.getModifiableAttributeMap(false).keySet());
        return result;
    }

    protected abstract EMap<?, ? extends EList<? extends IAttributeValuePresence<?>>> getModifiableAttributeMap(boolean var1);

    protected abstract EMap<?, ? extends EList<? extends IReferenceValuePresence<?>>> getModifiableOrderReferenceMap(boolean var1);

    protected abstract EMap<?, ? extends EMap<?, ? extends IReferenceValuePresence<?>>> getModifiableReferenceMap(boolean var1);

    protected List<GMergeableDifference<E, A, R>> getModifiableRelatedDifferences(boolean create_p) {
        return create_p ? this.getModifiableRelatedDifferences() : this.modifiableRelatedDifferences;
    }

    @Override
    public int getNbNoContainmentDifferences() {
        int result = 0;
        if (!this.isPartial()) {
            for (IDifference<E> difference : this.getRelatedDifferences()) {
                if (!(difference instanceof IElementRelativeDifference) || !((IElementRelativeDifference)difference).isUnrelatedToContainmentTree() || difference.isMerged()) continue;
                ++result;
            }
        }
        return result;
    }

    @Override
    public IReferenceValuePresence<E> getOwnershipDifference(Role role_p) {
        return Role.TARGET == role_p ? this.getTargetOwnershipDifference() : this.getReferenceOwnershipDifference();
    }

    @Override
    public Collection<IDifference<E>> getPresenceDifferencesIn(Role role_p) {
        ArrayList<IDifference<E>> result = new ArrayList<IDifference<E>>();
        for (IDifference<E> difference : this.getRelatedDifferences()) {
            if (!(difference instanceof IPresenceDifference) || ((IPresenceDifference)difference).getPresenceRole() != role_p) continue;
            result.add(difference);
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Collection<IReferenceValuePresence<E>> getReferenceDifferences(Object reference_p) {
        EMap forReference;
        Collection<IReferenceValuePresence<Object>> result = null;
        if (this.getModifiableReferenceMap(false) != null && (forReference = (EMap)this.getModifiableReferenceMap(false).get(reference_p)) != null) {
            result = Collections.unmodifiableCollection(forReference.values());
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public IReferenceValuePresence<E> getReferenceOrderDifference(Object reference_p, Role role_p) {
        List forReference;
        EMap<?, EList<IReferenceValuePresence<?>>> referenceMap = this.getModifiableOrderReferenceMap(false);
        if (referenceMap != null && (forReference = (List)referenceMap.get(reference_p)) != null) {
            for (IReferenceValuePresence orderDifference : forReference) {
                if (orderDifference.getPresenceRole() != role_p) continue;
                return orderDifference;
            }
        }
        return null;
    }

    @Override
    public IReferenceValuePresence<E> getReferenceValueDifference(Object reference_p, E value_p) {
        EMap forReference;
        IReferenceValuePresence result = null;
        if (this.getModifiableReferenceMap(false) != null && (forReference = (EMap)this.getModifiableReferenceMap(false).get(reference_p)) != null) {
            result = (IReferenceValuePresence)forReference.get(value_p);
        }
        return result;
    }

    @Override
    public Collection<Object> getReferencesWithDifferences() {
        Set<Object> result = this.getModifiableReferenceMap(false) == null ? Collections.emptySet() : Collections.unmodifiableSet(this.getModifiableReferenceMap(false).keySet());
        return result;
    }

    @Override
    public List<IDifference<E>> getRelatedDifferences() {
        List<GMergeableDifference<E, A, R>> modifiable = this.getModifiableRelatedDifferences(false);
        List<Object> result = modifiable == null ? Collections.emptyList() : Collections.unmodifiableList(modifiable);
        return result;
    }

    @Override
    public Role getUncoveredRole() {
        Role result = null;
        if (!this.coversRole(Role.TARGET)) {
            result = Role.TARGET;
        } else if (!this.coversRole(Role.REFERENCE)) {
            result = Role.REFERENCE;
        }
        return result;
    }

    @Override
    public boolean isAMove() {
        boolean result = false;
        if (!this.isPartial() && this.getElementPresenceDifference() == null) {
            IReferenceValuePresence<E> onTarget = this.getOwnershipDifference(Role.TARGET);
            IReferenceValuePresence<E> onReference = this.getOwnershipDifference(Role.REFERENCE);
            result = onTarget != null || onReference != null;
        }
        return result;
    }

    @Override
    public boolean isPartial() {
        return this.getUncoveredRole() != null;
    }

    @Override
    public boolean isPartial(Role role1_p, Role role2_p) {
        return !this.coversRole(role1_p) || !this.coversRole(role2_p);
    }

    @Override
    public boolean maps(E target_p, E reference_p) {
        return this.get(Role.TARGET) == target_p && this.get(Role.REFERENCE) == reference_p;
    }

    @Override
    public boolean maps(E target_p, E reference_p, E ancestor_p) {
        return this.maps(target_p, reference_p) && this.get(Role.ANCESTOR) == ancestor_p;
    }

    protected abstract EList<IAttributeValuePresence<E>> newAttributeValuePresenceList(A var1);

    protected abstract EList<IReferenceValuePresence<E>> newReferenceOrderDifferenceList(R var1);

    protected abstract EMap<E, IReferenceValuePresence<E>> newReferenceValueToPresenceMap(R var1);

    @Override
    public void set(Role role_p, E element_p) {
        switch (role_p) {
            case TARGET: {
                this.setTarget(element_p);
                break;
            }
            case REFERENCE: {
                this.setReference(element_p);
                break;
            }
            default: {
                this.setAncestor(element_p);
            }
        }
    }
}

