/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.diffmerge.bridge.api.IBridge;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeExecution;
import org.eclipse.emf.diffmerge.bridge.api.incremental.IIncrementalBridge;
import org.eclipse.emf.diffmerge.bridge.api.incremental.IIncrementalBridgeExecution;
import org.eclipse.emf.diffmerge.bridge.impl.IncrementalWrappingBridgeExecution;
import org.eclipse.emf.diffmerge.bridge.operations.AbstractBridgeOperation;

public class IncrementalWrappingBridgeOperation
extends AbstractBridgeOperation {
    private final boolean _isActuallyIncremental;

    public IncrementalWrappingBridgeOperation(Object sourceDataSet_p, Object targetDataSet_p, IIncrementalBridge.Wrapping<?, ?, ?> bridge_p, IBridgeExecution execution_p) {
        super(sourceDataSet_p, targetDataSet_p, bridge_p, execution_p);
        this._isActuallyIncremental = this.isActuallyIncremental(bridge_p, targetDataSet_p, execution_p);
        this.getBridgeExecution().setActuallyIncremental(this._isActuallyIncremental);
    }

    public IIncrementalBridge.Wrapping<?, ?, ?> getBridge() {
        return (IIncrementalBridge.Wrapping)super.getBridge();
    }

    @Override
    public IncrementalWrappingBridgeExecution getBridgeExecution() {
        return (IncrementalWrappingBridgeExecution)super.getBridgeExecution();
    }

    protected int getWorkAmount() {
        return this.getBridge().getWorkAmount(this.getSourceDataSet(), this.getTargetDataSet());
    }

    public boolean isActuallyIncremental() {
        return this._isActuallyIncremental;
    }

    protected boolean isActuallyIncremental(IIncrementalBridge<?, ?, ?> bridge_p, Object targetDataSet_p, IBridgeExecution execution_p) {
        boolean result = false;
        if (execution_p instanceof IIncrementalBridgeExecution) {
            IIncrementalBridgeExecution execution = (IIncrementalBridgeExecution)execution_p;
            result = execution.canBeIncremental() && !bridge_p.isEmpty(targetDataSet_p);
        }
        return result;
    }

    public IStatus run() {
        IStatus result;
        IBridge bridge = this.getBridge();
        IBridge<Object, Object> transformationBridge = bridge.getTransformationBridge();
        if (this._isActuallyIncremental) {
            this.getMonitor().worked(1);
            Object intermediateDataSet = bridge.createIntermediateDataSet(this.getSourceDataSet(), this.getTargetDataSet());
            IBridgeExecution transformationExecution = transformationBridge.executeOn(this.getSourceDataSet(), intermediateDataSet, this.getBridgeExecution().getTransformationExecution(), (IProgressMonitor)this.getMonitor());
            result = transformationExecution.getStatus().isOK() ? bridge.merge(intermediateDataSet, this.getTargetDataSet(), this.getBridgeExecution(), (IProgressMonitor)this.getMonitor()) : transformationExecution.getStatus();
        } else {
            IBridgeExecution execution = transformationBridge.executeOn(this.getSourceDataSet(), this.getTargetDataSet(), this.getBridgeExecution().getTransformationExecution(), (IProgressMonitor)this.getMonitor());
            result = execution.getStatus();
        }
        return result;
    }
}

