/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.environment.AbstractGenericTypeUtil;
import org.eclipse.emf.diffmerge.patterns.diagrams.PatternCoreDiagramPlugin;
import org.eclipse.emf.diffmerge.patterns.diagrams.factories.IPatternOperationFactory;
import org.eclipse.emf.diffmerge.patterns.diagrams.util.AbstractDiagramUtil;
import org.eclipse.emf.diffmerge.patterns.ui.PatternsUIPlugin;
import org.eclipse.emf.diffmerge.patterns.ui.factories.IPatternDialogAndWizardFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class AbstractTableChoiceDialog<T>
extends MessageDialog {
    protected static final int DEFAULT_COLUMN_WIDTH = 240;
    protected static final int WIDTH_INCREMENT = 40;
    protected final List<T> _originalList;
    private final SelectionKind _selectionKind;
    protected TableViewer _viewer;
    private IStructuredSelection _selection;
    protected AbstractGenericTypeUtil _genericTypeUtil;
    protected AbstractDiagramUtil _diagramUtil;
    protected IPatternDialogAndWizardFactory _dialogAndWizardFactory;
    protected IPatternOperationFactory _operationFactory;

    public AbstractTableChoiceDialog(Shell parentShell_p, String dialogTitle_p, String dialogMessage_p, Collection<? extends T> elements_p, SelectionKind selectionKind_p) {
        this(parentShell_p, dialogTitle_p, dialogMessage_p, 3, elements_p, selectionKind_p, true);
    }

    public AbstractTableChoiceDialog(Shell parentShell_p, String dialogTitle_p, String dialogMessage_p, int iconKind_p, Collection<? extends T> elements_p, SelectionKind selectionKind_p, boolean canConfirm_p) {
        String[] stringArray;
        String string = dialogTitle_p != null ? dialogTitle_p : CorePatternsPlugin.getDefault().getLabel();
        if (canConfirm_p) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = IDialogConstants.OK_LABEL;
            stringArray = stringArray2;
            stringArray2[1] = IDialogConstants.CANCEL_LABEL;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = IDialogConstants.CLOSE_LABEL;
        }
        super(parentShell_p, string, null, dialogMessage_p, iconKind_p, stringArray, 0);
        this._genericTypeUtil = CorePatternsPlugin.getDefault().getGenericTypeUtil();
        this._diagramUtil = PatternCoreDiagramPlugin.getDefault().getDiagramUtilityClass();
        this._dialogAndWizardFactory = PatternsUIPlugin.getDefault().getDialogAndWizardFactory();
        this._operationFactory = PatternCoreDiagramPlugin.getDefault().getOperationFactory();
        this._originalList = new ArrayList<T>(elements_p);
        this._selectionKind = selectionKind_p;
        this._selection = null;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public boolean close() {
        this.rememberSelection();
        return super.close();
    }

    protected Control createDialogArea(Composite parent_p) {
        this.createMessageArea(parent_p);
        ScrolledComposite composite = new ScrolledComposite(parent_p, 512);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = Integer.MAX_VALUE;
        composite.setLayoutData((Object)data);
        Control customArea = this.createCustomArea((Composite)composite);
        composite.setContent(customArea);
        composite.setExpandHorizontal(true);
        composite.setExpandVertical(true);
        return composite;
    }

    protected Control createCustomArea(Composite parent_p) {
        Table result = this.createTable(parent_p);
        this._viewer = new TableViewer(result);
        this._viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this._viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this._viewer.setInput(this._originalList);
        this.selectFirst();
        return result;
    }

    protected Table createTable(Composite parent_p) {
        int style = 67584;
        switch (this._selectionKind) {
            case MULTI_CHECK: {
                style = style | 0x20 | 0x8000;
                break;
            }
            case MULTI: {
                style |= 2;
            }
        }
        Table result = new Table(parent_p, style);
        List<String> headers = this.getColumnHeaders();
        int nbCol = this.getColumnsNumber();
        int i = 0;
        while (i < nbCol) {
            TableColumn fCol = new TableColumn(result, 16384);
            String header = i < headers.size() ? headers.get(i) : "";
            fCol.setText(header);
            int colWidth = this.getColumnWidth(i);
            fCol.setWidth(colWidth > 0 ? colWidth : 0);
            ++i;
        }
        result.setLinesVisible(true);
        result.setHeaderVisible(true);
        return result;
    }

    protected abstract String getColumnText(T var1, int var2);

    protected abstract List<String> getColumnHeaders();

    protected int getColumnsNumber() {
        return this.getColumnHeaders().size();
    }

    protected int getColumnWidth(int columnNb_p) {
        return 240;
    }

    public List<T> getChoices() {
        return this._selection == null ? Collections.emptyList() : Collections.unmodifiableList(this._selection.toList());
    }

    public T getChoice() {
        Object result = null;
        if (this._selection != null && !this._selection.isEmpty()) {
            result = this._selection.getFirstElement();
        }
        return (T)result;
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        int sum = 0;
        int i = 0;
        while (i < this.getColumnsNumber()) {
            sum += this.getColumnWidth(i);
            ++i;
        }
        result.x = sum + 40;
        return result;
    }

    protected ILabelProvider getLabelProvider() {
        return new TableLabelProvider();
    }

    protected void selectAll() {
        this._viewer.setSelection((ISelection)new StructuredSelection(this._originalList));
    }

    protected void selectFirst() {
        if (this._viewer.getTable().getItemCount() > 0) {
            this._viewer.setSelection((ISelection)new StructuredSelection(this._viewer.getElementAt(0)));
        }
    }

    private void rememberSelection() {
        if (SelectionKind.MULTI_CHECK == this._selectionKind) {
            ArrayList<Object> allChecked = new ArrayList<Object>();
            TableItem[] tableItemArray = this._viewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked()) {
                    allChecked.add(item.getData());
                }
                ++n2;
            }
            this._selection = new StructuredSelection(allChecked);
        } else {
            this._selection = (IStructuredSelection)this._viewer.getSelection();
        }
    }

    public static enum SelectionKind {
        SINGLE,
        MULTI,
        MULTI_CHECK;

    }

    protected class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected TableLabelProvider() {
        }

        public String getColumnText(Object element_p, int columnIndex_p) {
            return AbstractTableChoiceDialog.this.getColumnText(element_p, columnIndex_p);
        }

        public Image getColumnImage(Object element_p, int columnIndex_p) {
            return this.getImage(element_p);
        }
    }
}

