/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.dialogs;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.AbstractTableChoiceDialog;
import org.eclipse.emf.diffmerge.patterns.ui.providers.DiscriminatingLabelProvider;
import org.eclipse.emf.diffmerge.patterns.ui.util.PatternsInstancesUIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Shell;

public class InstanceChoiceDialog
extends AbstractTableChoiceDialog<IPatternInstance> {
    protected final EObject _referenceElement;
    private static final String NO_ROLE_TEXT = Messages.InstanceChoiceDialog_NoRole;
    private static final String UNKNOWN_ROLE_TEXT = Messages.InstanceChoiceDialog_UnknownRole;

    public InstanceChoiceDialog(Shell parentShell_p, String dialogTitle_p, String dialogMessage_p, int iconKind_p, EObject referenceElement_p, List<? extends IPatternInstance> instances_p, AbstractTableChoiceDialog.SelectionKind selectionKind_p, boolean canConfirm_p) {
        super(parentShell_p, dialogTitle_p, InstanceChoiceDialog.extendWithReferenceElement(dialogMessage_p, referenceElement_p), iconKind_p, instances_p, selectionKind_p, canConfirm_p);
        this._referenceElement = referenceElement_p;
    }

    private static String extendWithReferenceElement(String initialMessage_p, EObject referenceElement_p) {
        String name = DiscriminatingLabelProvider.getInstance().getText(referenceElement_p);
        StringBuilder builder = new StringBuilder();
        builder.append(initialMessage_p);
        builder.append(' ');
        builder.append(Messages.InstanceChoiceDialog_InitialSelection);
        builder.append(" '");
        builder.append(name);
        builder.append("'.");
        return builder.toString();
    }

    @Override
    protected String getColumnText(IPatternInstance instance_p, int columnIndex_p) {
        switch (columnIndex_p) {
            case 0: {
                return PatternsInstancesUIUtil.getPatternAsText(instance_p);
            }
            case 1: {
                return PatternsInstancesUIUtil.getRolesAsText(instance_p, this._referenceElement, UNKNOWN_ROLE_TEXT, NO_ROLE_TEXT);
            }
        }
        return "";
    }

    @Override
    protected List<String> getColumnHeaders() {
        return Arrays.asList(Messages.InstanceChoiceDialog_InstanceOf, Messages.InstanceChoiceDialog_RolePlayed);
    }
}

