/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.util;

import org.eclipse.emf.diffmerge.generic.gdiffdata.GComparison;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.viewers.AbstractComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DiffMergeDialog
extends Dialog {
    protected String _title;
    protected final EMFDiffNode _input;

    public DiffMergeDialog(Shell shell_p, String title_p, EMFDiffNode input_p) {
        super(shell_p);
        this._title = title_p;
        this._input = input_p;
    }

    protected void configureShell(Shell newShell_p) {
        super.configureShell(newShell_p);
        newShell_p.setText(this._title != null ? this._title : EMFDiffMergeUIPlugin.LABEL);
    }

    protected void createButtonsForButtonBar(Composite parent_p) {
        boolean editable = this.isEditable();
        if (editable) {
            this.createOKButton(parent_p);
        }
        this.createButton(parent_p, 1, IDialogConstants.CANCEL_LABEL, !editable);
    }

    protected boolean isEditable() {
        return this._input.isEditionPossible(true) || this._input.isEditionPossible(false);
    }

    protected AbstractComparisonViewer createComparisonViewer(Composite parent_p) {
        return new ComparisonViewer(parent_p);
    }

    protected Control createDialogArea(Composite parent_p) {
        Composite composite = (Composite)super.createDialogArea(parent_p);
        AbstractComparisonViewer viewer = this.createComparisonViewer(composite);
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        viewer.setInput(this._input);
        return composite;
    }

    protected Button createOKButton(Composite parent_p) {
        Button result = this.createButton(parent_p, 0, IDialogConstants.OK_LABEL, false);
        GComparison comparison = this._input.getActualComparison();
        boolean enabled = comparison != null ? comparison.hasRemainingDifferences() : false;
        result.setEnabled(enabled);
        return result;
    }

    protected boolean isResizable() {
        return true;
    }
}

