/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.git.ext;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.info.GitInfo;
import org.eclipse.egit.core.info.GitItemState;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.connector.git.EMFDiffMergeGitConnectorPlugin;
import org.eclipse.emf.diffmerge.connector.git.Messages;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.CachedResourceVariant;

public final class GitHelper {
    public static final GitHelper INSTANCE = new GitHelper();
    private static final String REMOTE_SCHEME = "remote";
    private static final String INDEX_SCHEME = "index";
    private static final String COMMIT_SCHEME = "commit";
    private static final String SCHEME_SEP = ":/";

    protected GitHelper() {
    }

    public GitInfo getGitInfo(Object object_p) {
        return (GitInfo)Adapters.adapt((Object)object_p, GitInfo.class);
    }

    public GitFileRevisionKind getGitKind(GitInfo info_p, ITypedElement typedElement_p) {
        GitInfo.Source source;
        GitFileRevisionKind result = info_p == null || info_p.getRepository() == null ? GitFileRevisionKind.NOT_MANAGED : ((source = info_p.getSource()) == GitInfo.Source.WORKING_TREE ? GitFileRevisionKind.WORKING_TREE : (source == GitInfo.Source.INDEX ? (INSTANCE.isConflicting(info_p) ? (typedElement_p instanceof IEditableContent ? GitFileRevisionKind.INDEX_CONFLICT_OURS : GitFileRevisionKind.INDEX_CONFLICT_THEIRS) : GitFileRevisionKind.INDEX) : (info_p instanceof CachedResourceVariant ? GitFileRevisionKind.REMOTE : GitFileRevisionKind.COMMIT)));
        return result;
    }

    public Collection<String> getGitSchemes() {
        return Arrays.asList(this.getSchemeCommit(), this.getSchemeIndex(), this.getSchemeRemote());
    }

    public RevCommit getOurs(Repository repository_p, RevWalk revWalk_p) throws IOException {
        ObjectId ours = repository_p.resolve("HEAD");
        return revWalk_p.parseCommit((AnyObjectId)ours);
    }

    public Repository getRepository(Object object_p) {
        Repository result = null;
        GitInfo gitInfo = this.getGitInfo(object_p);
        if (gitInfo != null) {
            result = gitInfo.getRepository();
        }
        if (result == null) {
            String path = null;
            if (gitInfo != null) {
                path = gitInfo.getGitPath();
            } else {
                IPath iPath = null;
                if (object_p instanceof IResource) {
                    iPath = ((IResource)object_p).getFullPath();
                } else if (object_p instanceof IFileRevision) {
                    iPath = this.toPath((IFileRevision)object_p);
                }
                if (iPath != null) {
                    path = iPath.toString();
                }
            }
            EMFDiffMergeGitConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeGitConnectorPlugin.getDefault().getPluginId(), String.format(Messages.GitHelper_NoRepoFound, path)));
        }
        return result;
    }

    public RevWalk getRevWalk(Repository repository_p, String path_p) {
        RevWalk result = new RevWalk(repository_p);
        result.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings((String[])new String[]{path_p}), (TreeFilter)TreeFilter.ANY_DIFF));
        return result;
    }

    public String getSchemeCommit() {
        return COMMIT_SCHEME;
    }

    public String getSchemeIndex() {
        return INDEX_SCHEME;
    }

    public String getSchemeRemote() {
        return REMOTE_SCHEME;
    }

    public String getSchemeSeparator() {
        return SCHEME_SEP;
    }

    public boolean isConflicting(GitInfo info_p) {
        boolean result = false;
        if (info_p != null) {
            GitItemState state = info_p.getGitState();
            result = state != null && state.hasConflicts();
        }
        return result;
    }

    public IPath toPath(IFileRevision revision_p) {
        Path result = null;
        java.net.URI uri = revision_p.getURI();
        if (uri != null) {
            String uriString = URI.decode((String)uri.toString());
            result = new Path(uriString);
        }
        return result;
    }

    public static enum GitFileRevisionKind {
        NOT_MANAGED,
        WORKING_TREE,
        INDEX,
        INDEX_CONFLICT_OURS,
        INDEX_CONFLICT_THEIRS,
        COMMIT,
        REMOTE;

    }
}

