/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.git.ext;

import java.util.Arrays;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.info.GitInfo;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.connector.core.ext.AbstractRevisionScopeDefinitionFactory;
import org.eclipse.emf.diffmerge.connector.git.EMFDiffMergeGitConnectorPlugin;
import org.eclipse.emf.diffmerge.connector.git.Messages;
import org.eclipse.emf.diffmerge.connector.git.ext.GitCommitURIConverter;
import org.eclipse.emf.diffmerge.connector.git.ext.GitHelper;
import org.eclipse.emf.diffmerge.connector.git.ext.GitIndexOursURIConverter;
import org.eclipse.emf.diffmerge.connector.git.ext.GitIndexTheirsURIConverter;
import org.eclipse.emf.diffmerge.connector.git.ext.GitIndexURIConverter;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.IResourceVariant;

public class GitRevisionScopeDefinitionFactory
extends AbstractRevisionScopeDefinitionFactory {
    protected static final int ABBREVIATE_COMMIT_LABEL_SIZE = 7;

    protected String getContentIdentifier(RevCommit revCommit_p) {
        StringBuilder s = new StringBuilder();
        if (revCommit_p != null) {
            s.append(revCommit_p.abbreviate(7).name());
            s.append("...");
            PersonIdent authorIdent = revCommit_p.getAuthorIdent();
            if (authorIdent != null) {
                s.append(" (");
                s.append(authorIdent.getName());
                s.append(')');
            }
        }
        return s.toString();
    }

    protected URIConverter getURIConverterForRevision(IFileRevision revision_p, ITypedElement entrypoint_p) throws CoreException {
        Object result = null;
        GitInfo info = GitHelper.INSTANCE.getGitInfo(revision_p);
        GitHelper.GitFileRevisionKind kind = GitHelper.INSTANCE.getGitKind(info, entrypoint_p);
        switch (kind) {
            case NOT_MANAGED: 
            case WORKING_TREE: {
                result = super.getURIConverterForRevision(revision_p, entrypoint_p);
                break;
            }
            case INDEX: {
                result = new GitIndexURIConverter(info.getRepository());
                break;
            }
            case INDEX_CONFLICT_OURS: {
                result = new GitIndexOursURIConverter(info.getRepository(), info.getGitPath());
                break;
            }
            case INDEX_CONFLICT_THEIRS: {
                result = new GitIndexTheirsURIConverter(info.getRepository(), info.getGitPath());
                break;
            }
            case COMMIT: 
            case REMOTE: {
                try {
                    RevCommit commit = info.getRepository().parseCommit(info.getCommitId());
                    result = new GitCommitURIConverter(commit, info.getRepository());
                    break;
                }
                catch (Exception e) {
                    EMFDiffMergeGitConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeGitConnectorPlugin.getDefault().getPluginId(), e.getMessage(), (Throwable)e));
                }
            }
        }
        return result;
    }

    protected URI getURIForRevision(IFileRevision revision_p, ITypedElement entrypoint_p) throws CoreException {
        String scheme;
        GitInfo info = GitHelper.INSTANCE.getGitInfo(revision_p);
        GitHelper.GitFileRevisionKind kind = GitHelper.INSTANCE.getGitKind(info, entrypoint_p);
        URI result = null;
        switch (kind) {
            case INDEX_CONFLICT_OURS: {
                scheme = null;
                result = this.createPlatformResourceUriFromFileRevision(revision_p);
                break;
            }
            case INDEX: 
            case INDEX_CONFLICT_THEIRS: {
                scheme = GitHelper.INSTANCE.getSchemeIndex();
                break;
            }
            case COMMIT: {
                scheme = GitHelper.INSTANCE.getSchemeCommit();
                break;
            }
            case REMOTE: {
                scheme = GitHelper.INSTANCE.getSchemeRemote();
                break;
            }
            default: {
                scheme = null;
            }
        }
        if (result == null) {
            result = scheme != null ? URI.createURI((String)(String.valueOf(scheme) + GitHelper.INSTANCE.getSchemeSeparator() + info.getGitPath())) : super.getURIForRevision(revision_p, entrypoint_p);
        }
        return result;
    }

    protected URI createPlatformResourceUriFromFileRevision(IFileRevision revision_p) {
        URI result = null;
        Repository repo = GitHelper.INSTANCE.getRepository(revision_p);
        if (repo != null) {
            java.net.URI revisionAbsoluteUri = repo.getWorkTree().toURI().resolve(revision_p.getURI());
            IWorkspaceRoot wkRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile[] platformFiles = wkRoot.findFilesForLocationURI(revisionAbsoluteUri);
            if (platformFiles.length > 0 && platformFiles[0].isAccessible()) {
                IFile iFile = platformFiles[0];
                result = URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true);
            }
        }
        return result;
    }

    protected String getLabelForRevision(IFileRevision revision_p, ITypedElement entrypoint_p) {
        String result = null;
        GitInfo info = GitHelper.INSTANCE.getGitInfo(revision_p);
        GitHelper.GitFileRevisionKind kind = GitHelper.INSTANCE.getGitKind(info, entrypoint_p);
        switch (kind) {
            case WORKING_TREE: {
                result = String.format(Messages.GitRevisionScopeDefinitionFactory_LabelWorkspace, revision_p.getName());
                break;
            }
            case INDEX_CONFLICT_OURS: {
                result = String.format(Messages.GitRevisionScopeDefinitionFactory_LabelIndexEditable, revision_p.getName());
                break;
            }
            case INDEX: 
            case INDEX_CONFLICT_THEIRS: {
                result = String.format(Messages.GitRevisionScopeDefinitionFactory_LabelIndex, revision_p.getName());
                break;
            }
            case COMMIT: {
                try {
                    RevCommit commit = info.getRepository().parseCommit(info.getCommitId());
                    result = String.format(Messages.GitRevisionScopeDefinitionFactory_LabelCommit, revision_p.getName(), this.getContentIdentifier(commit));
                }
                catch (Exception e) {
                    EMFDiffMergeGitConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeGitConnectorPlugin.getDefault().getPluginId(), e.getMessage(), (Throwable)e));
                }
                break;
            }
            case REMOTE: {
                IResourceVariant variant = this.getVariant(revision_p);
                result = String.format(Messages.GitRevisionScopeDefinitionFactory_LabelRemote, revision_p.getName(), variant == null ? null : variant.getContentIdentifier());
            }
        }
        if (result == null) {
            result = super.getLabelForRevision(revision_p, entrypoint_p);
        }
        return result;
    }

    protected boolean isApplicableToRevision(IFileRevision revision_p, ITypedElement entrypoint_p) {
        GitInfo info = GitHelper.INSTANCE.getGitInfo(revision_p);
        return GitHelper.INSTANCE.getGitKind(info, entrypoint_p) != GitHelper.GitFileRevisionKind.NOT_MANAGED;
    }

    protected boolean isScopeEditable(Object entrypoint_p) {
        boolean result = false;
        if (entrypoint_p instanceof ITypedElement) {
            ITypedElement typedElement = (ITypedElement)entrypoint_p;
            IFileRevision revision = this.getRevision(typedElement);
            GitInfo info = GitHelper.INSTANCE.getGitInfo(revision);
            GitHelper.GitFileRevisionKind kind = GitHelper.INSTANCE.getGitKind(info, typedElement);
            result = Arrays.asList(GitHelper.GitFileRevisionKind.NOT_MANAGED, GitHelper.GitFileRevisionKind.WORKING_TREE, GitHelper.GitFileRevisionKind.INDEX_CONFLICT_OURS).contains((Object)kind);
        }
        return result;
    }
}

