/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonTreeViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.TextualCategoryFilter;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.internal.WorkbenchMessages;

public class ComparisonTreeViewerWithTextualFilter
extends Composite {
    protected Text filterText;
    protected Composite filterComposite;
    protected String initialText = "";
    protected Composite parent;
    protected boolean showFilterControls;
    protected Composite treeComposite;
    protected TextualCategoryFilter textualCategoryFilter;
    ComparisonTreeViewer treeViewer = null;

    public ComparisonTreeViewerWithTextualFilter(Composite parent_p) {
        this(parent_p, 770);
    }

    public ComparisonTreeViewerWithTextualFilter(Composite parent_p, int style_p) {
        super(parent_p, style_p);
        this.parent = parent_p;
        this.init(style_p);
    }

    protected void init(int treeStyle) {
        this.createControl(this.parent, treeStyle);
        this.setInitialText(Messages.CapellaFilteredTree_FILTER_TEXT_PLACEHOLDER);
        this.setFont(this.parent.getFont());
        this.textualCategoryFilter = new TextualCategoryFilter(this.getViewer());
    }

    protected void createControl(Composite p, int treeStyle) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        if (p.getLayout() instanceof GridLayout) {
            this.setLayoutData(new GridData(4, 4, true, true));
        }
        this.filterComposite = new Composite((Composite)this, 0);
        GridLayout filterLayout = new GridLayout();
        filterLayout.marginHeight = 0;
        filterLayout.marginWidth = 0;
        this.filterComposite.setLayout((Layout)filterLayout);
        this.filterComposite.setFont(p.getFont());
        this.createFilterControls(this.filterComposite);
        this.filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.treeComposite = new Composite((Composite)this, 0);
        GridLayout treeCompositeLayout = new GridLayout();
        treeCompositeLayout.marginHeight = 0;
        treeCompositeLayout.marginWidth = 0;
        this.treeComposite.setLayout((Layout)treeCompositeLayout);
        GridData data = new GridData(4, 4, true, true);
        this.treeComposite.setLayoutData((Object)data);
        this.createTreeControl(this.treeComposite, treeStyle);
    }

    protected ComparisonTreeViewer getViewer() {
        return this.treeViewer;
    }

    protected Composite createFilterControls(Composite p) {
        this.createFilterText(p);
        return p;
    }

    protected void createFilterText(Composite p) {
        this.filterText = this.doCreateFilterText(p);
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = ComparisonTreeViewerWithTextualFilter.this.filterText.getText();
                e.result = filterTextString.isEmpty() || filterTextString.equals(ComparisonTreeViewerWithTextualFilter.this.initialText) ? ComparisonTreeViewerWithTextualFilter.this.initialText : NLS.bind((String)WorkbenchMessages.FilteredTree_AccessibleListenerFiltered, (Object[])new String[]{filterTextString, String.valueOf(this.getFilteredItemsCount())});
            }

            private int getFilteredItemsCount() {
                TreeItem[] items;
                int total = 0;
                TreeItem[] treeItemArray = items = ComparisonTreeViewerWithTextualFilter.this.getViewer().getTree().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    total += this.itemCount(item);
                    ++n2;
                }
                return total;
            }

            private int itemCount(TreeItem treeItem) {
                TreeItem[] children;
                int count = 1;
                TreeItem[] treeItemArray = children = treeItem.getItems();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem element = treeItemArray[n2];
                    count += this.itemCount(element);
                    ++n2;
                }
                return count;
            }
        });
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Display display = ComparisonTreeViewerWithTextualFilter.this.filterText.getDisplay();
                display.asyncExec(() -> {
                    if (!ComparisonTreeViewerWithTextualFilter.this.filterText.isDisposed() && ComparisonTreeViewerWithTextualFilter.this.getInitialText().equals(ComparisonTreeViewerWithTextualFilter.this.filterText.getText().trim())) {
                        ComparisonTreeViewerWithTextualFilter.this.filterText.selectAll();
                    }
                });
            }

            public void focusLost(FocusEvent e) {
                if (ComparisonTreeViewerWithTextualFilter.this.filterText.getText().equals(ComparisonTreeViewerWithTextualFilter.this.initialText)) {
                    ComparisonTreeViewerWithTextualFilter.this.setFilterText("");
                    ComparisonTreeViewerWithTextualFilter.this.textChanged();
                }
            }
        });
        this.filterText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (ComparisonTreeViewerWithTextualFilter.this.filterText.getText().equals(ComparisonTreeViewerWithTextualFilter.this.initialText)) {
                    ComparisonTreeViewerWithTextualFilter.this.setFilterText("");
                    ComparisonTreeViewerWithTextualFilter.this.textChanged();
                }
            }
        });
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasItems;
                boolean bl = hasItems = ComparisonTreeViewerWithTextualFilter.this.getViewer().getTree().getItemCount() > 0;
                if (hasItems && e.keyCode == 0x1000002) {
                    ComparisonTreeViewerWithTextualFilter.this.getViewer().getTree().setFocus();
                    return;
                }
            }
        });
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    ComparisonTreeViewerWithTextualFilter.this.textChanged();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.filterText.setLayoutData((Object)gridData);
    }

    protected Text doCreateFilterText(Composite p) {
        return new Text(p, 2180);
    }

    protected Control createTreeControl(Composite p, int style) {
        this.treeViewer = (ComparisonTreeViewer)this.doCreateTreeViewer(p, style);
        GridData data = new GridData(4, 4, true, true);
        this.treeViewer.getControl().setLayoutData((Object)data);
        return this.treeViewer.getControl();
    }

    protected TreeViewer doCreateTreeViewer(Composite p, int style) {
        return new ComparisonTreeViewer(p, style);
    }

    public void setInitialText(String text) {
        this.initialText = text;
        if (this.filterText != null) {
            this.filterText.setMessage(text);
            if (this.filterText.isFocusControl()) {
                this.setFilterText(this.initialText);
                this.textChanged();
            } else {
                this.getDisplay().asyncExec(() -> {
                    if (!this.filterText.isDisposed() && this.filterText.isFocusControl()) {
                        this.setFilterText(this.initialText);
                        this.textChanged();
                    }
                });
            }
        } else {
            this.setFilterText(this.initialText);
            this.textChanged();
        }
    }

    protected String getInitialText() {
        return this.initialText;
    }

    protected String getFilterString() {
        return this.filterText != null ? this.filterText.getText() : null;
    }

    protected void textChanged() {
        String filterString = this.getFilterString();
        this.textualCategoryFilter.textChanged(filterString);
        this.getViewer().getInput().updateDifferenceNumbers();
    }

    public void inputChanged(Object newInput, Object oldInput) {
        EMFDiffNode node;
        if (newInput != oldInput && newInput instanceof EMFDiffNode && !(node = (EMFDiffNode)newInput).getCategoryManager().getCategories().stream().anyMatch(it -> it instanceof TextualCategoryFilter)) {
            node.getCategoryManager().addCategory(this.textualCategoryFilter);
            node.getCategoryManager().update();
        }
    }

    protected void setFilterText(String fText) {
        if (this.filterText != null) {
            this.filterText.setText(fText);
            this.selectAll();
        }
    }

    protected void selectAll() {
        if (this.filterText != null) {
            this.filterText.selectAll();
        }
    }

    public void dispose() {
        this.filterText.dispose();
        this.filterComposite.dispose();
        this.treeComposite.dispose();
        this.treeViewer.getControl().dispose();
        super.dispose();
    }

    public void setDirected(boolean value) {
        this.treeViewer.setDirected(value);
    }
}

