/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.specification.ext;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonSpecification;
import org.eclipse.emf.diffmerge.ui.specification.IScopeSpecification;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;

public class DefaultComparisonSpecification
implements IComparisonSpecification {
    private final Map<Role, IScopeSpecification> _roleToScopeSpec = new HashMap<Role, IScopeSpecification>();
    private IMatchPolicy _matchPolicy;
    private IDiffPolicy _diffPolicy;
    private IMergePolicy _mergePolicy;
    private EditingDomain _editingDomain;

    public DefaultComparisonSpecification(IScopeSpecification leftScopeSpec_p, IScopeSpecification rightScopeSpec_p, IScopeSpecification ancestorScopeSpec_p) {
        this._roleToScopeSpec.put(Role.TARGET, leftScopeSpec_p);
        this._roleToScopeSpec.put(Role.REFERENCE, rightScopeSpec_p);
        this._roleToScopeSpec.put(Role.ANCESTOR, ancestorScopeSpec_p);
        this._editingDomain = null;
        this._matchPolicy = this.createMatchPolicy();
        this._diffPolicy = this.createDiffPolicy();
        this._mergePolicy = this.createMergePolicy();
    }

    public void configure() {
    }

    protected IDiffPolicy createDiffPolicy() {
        return null;
    }

    protected IMatchPolicy createMatchPolicy() {
        return null;
    }

    protected IMergePolicy createMergePolicy() {
        return null;
    }

    public void dispose() {
        AdapterFactoryEditingDomain afed;
        AdapterFactory af;
        EditingDomain domain = this.getEditingDomain();
        if (domain.getResourceSet().getResources().isEmpty() && domain instanceof AdapterFactoryEditingDomain && (af = (afed = (AdapterFactoryEditingDomain)domain).getAdapterFactory()) instanceof IDisposable) {
            ((IDisposable)af).dispose();
        }
    }

    protected EditingDomain doGetEditingDomain() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new BasicCommandStack());
    }

    public IScopeSpecification getScopeSpecification(Role role_p) {
        return this._roleToScopeSpec.get(role_p);
    }

    public final IDiffPolicy getDiffPolicy() {
        return this._diffPolicy;
    }

    public final EditingDomain getEditingDomain() {
        if (this._editingDomain == null) {
            this._editingDomain = this.doGetEditingDomain();
        }
        return this._editingDomain;
    }

    public final IMatchPolicy getMatchPolicy() {
        return this._matchPolicy;
    }

    public final IMergePolicy getMergePolicy() {
        return this._mergePolicy;
    }

    public boolean isConfigurable() {
        return false;
    }

    public final boolean isThreeWay() {
        return this.getScopeSpecification(Role.ANCESTOR) != null;
    }

    public boolean swapScopeSpecifications(Role role1_p, Role role2_p) {
        boolean result = false;
        IScopeSpecification scope1 = this.getScopeSpecification(role1_p);
        IScopeSpecification scope2 = this.getScopeSpecification(role2_p);
        if (scope1 != null && scope2 != null) {
            this._roleToScopeSpec.put(role1_p, scope2);
            this._roleToScopeSpec.put(role2_p, scope1);
            result = true;
        }
        return result;
    }
}

