/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.Messages;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMapping;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IAttributeValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.api.diff.IMergeableDifference;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.impl.helpers.AbstractExpensiveOperation;
import org.eclipse.emf.diffmerge.util.structures.FArrayList;
import org.eclipse.emf.diffmerge.util.structures.IEqualityTester;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffOperation
extends AbstractExpensiveOperation {
    private final IDiffPolicy _diffPolicy;
    private final IMergePolicy _mergePolicy;
    private final IComparison.Editable _comparison;

    public DiffOperation(IComparison.Editable comparison_p, IDiffPolicy diffPolicy_p, IMergePolicy mergePolicy_p) {
        this._comparison = comparison_p;
        this._diffPolicy = diffPolicy_p;
        this._mergePolicy = mergePolicy_p;
    }

    protected void createAllAttributeDifferences(IMatch match_p) {
        assert (match_p != null && !match_p.isPartial());
        EClass eClass = match_p.get(Role.TARGET).eClass();
        for (EAttribute attribute : eClass.getEAllAttributes()) {
            if (!this.getDiffPolicy().coverFeature((EStructuralFeature)attribute)) continue;
            this.createAttributeDifferences(match_p, attribute);
        }
    }

    protected void createAttributeDifferences(IMatch match_p, EAttribute attribute_p) {
        assert (match_p != null && !match_p.isPartial() && attribute_p != null);
        IFeaturedModelScope targetScope = this.getOutput().getScope(Role.TARGET);
        IFeaturedModelScope referenceScope = this.getOutput().getScope(Role.REFERENCE);
        EObject target = match_p.get(Role.TARGET);
        EObject reference = match_p.get(Role.REFERENCE);
        List<Object> targetValues = targetScope.get(target, attribute_p);
        List<Object> referenceValues = referenceScope.get(reference, attribute_p);
        ArrayList<Object> remainingTargetValues = new ArrayList<Object>(targetValues);
        ArrayList<Object> remainingReferenceValues = new ArrayList<Object>(referenceValues);
        boolean checkOrder = attribute_p.isMany() && this.getDiffPolicy().considerOrdered((EStructuralFeature)attribute_p);
        int maxIndex = -1;
        for (Object targetValue : targetValues) {
            ObjectAndIndex matchingReferenceValue = this.findEqualAttributeValue(attribute_p, targetValue, remainingReferenceValues);
            if (matchingReferenceValue.getObject() == null) continue;
            if (checkOrder) {
                if (matchingReferenceValue.getIndex() < maxIndex) {
                    this.createAttributeOrderDifference(match_p, attribute_p, targetValue, matchingReferenceValue.getObject());
                    checkOrder = false;
                } else {
                    maxIndex = matchingReferenceValue.getIndex();
                }
            }
            remainingTargetValues.remove(targetValue);
            remainingReferenceValues.remove(matchingReferenceValue.getObject());
        }
        for (Object remainingTargetValue : remainingTargetValues) {
            if (!this.getDiffPolicy().coverValue(remainingTargetValue, attribute_p)) continue;
            this.createAttributeValueDifference(match_p, attribute_p, remainingTargetValue, Role.TARGET, false);
        }
        for (Object remainingReferenceValue : remainingReferenceValues) {
            if (!this.getDiffPolicy().coverValue(remainingReferenceValue, attribute_p)) continue;
            this.createAttributeValueDifference(match_p, attribute_p, remainingReferenceValue, Role.REFERENCE, false);
        }
    }

    protected void createAttributeOrderDifference(IMatch elementMatch_p, EAttribute attribute_p, Object targetValue_p, Object referenceValue_p) {
        this.createAttributeValueDifference(elementMatch_p, attribute_p, targetValue_p, Role.TARGET, true);
        this.createAttributeValueDifference(elementMatch_p, attribute_p, referenceValue_p, Role.REFERENCE, true);
    }

    protected IAttributeValuePresence createAttributeValueDifference(IMatch elementMatch_p, EAttribute attribute_p, Object value_p, Role role_p, boolean isOrder_p) {
        IAttributeValuePresence result = this.getEditableComparison().newAttributeValuePresence(elementMatch_p, attribute_p, value_p, role_p, isOrder_p);
        IAttributeValuePresence symmetrical = result.getSymmetrical();
        if (symmetrical != null) {
            this.setSymmetricalValuePresenceDependencies(result, symmetrical);
        }
        if (this.getOutput().isThreeWay()) {
            this.setThreeWayProperties(result);
        }
        return result;
    }

    protected void createOwnershipDifferences(IMatch match_p) {
        assert (match_p != null && !match_p.isPartial());
        for (Role role : Arrays.asList(Role.TARGET, Role.REFERENCE)) {
            IMatch parentMatch = this.getOutput().getContainerOf(match_p, role);
            if (parentMatch == null || !parentMatch.isPartial()) continue;
            EObject element = match_p.get(role);
            EReference containment = this.getOutput().getScope(role).getContainment(element);
            this.createReferenceValueDifference(parentMatch, containment, match_p, role, false);
        }
    }

    protected void createAllReferenceDifferences(IMatch match_p) {
        assert (match_p != null && !match_p.isPartial());
        EClass eClass = match_p.get(Role.TARGET).eClass();
        for (EReference reference : eClass.getEAllReferences()) {
            if (reference.isContainer() || !this.getDiffPolicy().coverFeature((EStructuralFeature)reference)) continue;
            this.createReferenceDifferences(match_p, reference);
        }
    }

    protected void createReferenceDifferences(IMatch match_p, EReference reference_p) {
        assert (match_p != null && !match_p.isPartial() && reference_p != null);
        assert (!reference_p.isContainer());
        IFeaturedModelScope targetScope = this.getOutput().getScope(Role.TARGET);
        IFeaturedModelScope referenceScope = this.getOutput().getScope(Role.REFERENCE);
        EObject targetElement = match_p.get(Role.TARGET);
        EObject referenceElement = match_p.get(Role.REFERENCE);
        List<EObject> targetValues = targetScope.get(targetElement, reference_p);
        List<EObject> referenceValues = referenceScope.get(referenceElement, reference_p);
        FArrayList<EObject> remainingReferenceValues = new FArrayList<EObject>(referenceValues, IEqualityTester.BY_REFERENCE);
        boolean checkOrder = reference_p.isMany() && this.getDiffPolicy().considerOrdered((EStructuralFeature)reference_p);
        int maxIndex = -1;
        FArrayList<IMatch> isolatedTargetMatches = new FArrayList<IMatch>();
        for (EObject targetValue : targetValues) {
            boolean isIsolated;
            IMatch targetValueMatch = this.getMapping().getMatchFor(targetValue, Role.TARGET);
            if (targetValueMatch == null) continue;
            EObject matchReference = targetValueMatch.get(Role.REFERENCE);
            boolean bl = isIsolated = matchReference == null;
            if (!isIsolated) {
                int index = remainingReferenceValues.indexOf(matchReference);
                boolean bl2 = isIsolated = index < 0;
                if (checkOrder && !isIsolated) {
                    if (index < maxIndex) {
                        this.createReferenceOrderDifference(match_p, reference_p, targetValueMatch);
                        checkOrder = false;
                    } else {
                        maxIndex = index;
                    }
                }
            }
            if (isIsolated) {
                isolatedTargetMatches.add(targetValueMatch);
                continue;
            }
            remainingReferenceValues.remove(matchReference);
        }
        FArrayList<IMatch> isolatedReferenceMatches = new FArrayList<IMatch>();
        Iterator iterator = remainingReferenceValues.iterator();
        while (iterator.hasNext()) {
            EObject remainingReferenceValue = (EObject)iterator.next();
            IMatch referenceValueMatch = this.getMapping().getMatchFor(remainingReferenceValue, Role.REFERENCE);
            if (referenceValueMatch == null) continue;
            isolatedReferenceMatches.add(referenceValueMatch);
        }
        iterator = isolatedTargetMatches.iterator();
        while (iterator.hasNext()) {
            IMatch isolatedTargetMatch = (IMatch)iterator.next();
            if (!this.getDiffPolicy().coverMatch(isolatedTargetMatch)) continue;
            this.createReferenceValueDifference(match_p, reference_p, isolatedTargetMatch, Role.TARGET, false);
        }
        iterator = isolatedReferenceMatches.iterator();
        while (iterator.hasNext()) {
            IMatch isolatedReferenceMatch = (IMatch)iterator.next();
            if (!this.getDiffPolicy().coverMatch(isolatedReferenceMatch)) continue;
            this.createReferenceValueDifference(match_p, reference_p, isolatedReferenceMatch, Role.REFERENCE, false);
        }
    }

    protected void createReferenceOrderDifference(IMatch elementMatch_p, EReference reference_p, IMatch valueMatch_p) {
        this.createReferenceValueDifference(elementMatch_p, reference_p, valueMatch_p, Role.TARGET, true);
        this.createReferenceValueDifference(elementMatch_p, reference_p, valueMatch_p, Role.REFERENCE, true);
    }

    protected IReferenceValuePresence createReferenceValueDifference(IMatch elementMatch_p, EReference reference_p, IMatch valueMatch_p, Role role_p, boolean isOrder_p) {
        IReferenceValuePresence result = this.getEditableComparison().newReferenceValuePresence(elementMatch_p, reference_p, valueMatch_p, role_p, isOrder_p);
        this.setReferencedValueDependencies(result);
        if (this.getOutput().isThreeWay()) {
            this.setThreeWayProperties(result);
        }
        return result;
    }

    protected void createDifferences() {
        for (IMatch match : this.getMapping().getContents()) {
            this.checkProgress();
            if (this.getDiffPolicy().coverMatch(match)) {
                this.createTechnicalDifferences(match);
            }
            this.getMonitor().worked(1);
        }
    }

    protected void createContentDifferences(IMatch match_p) {
        assert (match_p != null && !match_p.isPartial());
        this.createAllAttributeDifferences(match_p);
        this.createAllReferenceDifferences(match_p);
        this.createOwnershipDifferences(match_p);
    }

    protected void createTechnicalDifferences(IMatch match_p) {
        assert (match_p != null);
        if (match_p.isPartial()) {
            this.getOrCreateElementPresence(match_p);
        } else {
            this.createContentDifferences(match_p);
        }
    }

    protected ObjectAndIndex findEqualAttributeValue(EAttribute attribute_p, Object value_p, Collection<? extends Object> candidates_p) {
        int i = 0;
        for (Object object : candidates_p) {
            if (this.getDiffPolicy().considerEqual(value_p, object, attribute_p)) {
                return new ObjectAndIndex(object, i);
            }
            ++i;
        }
        return new ObjectAndIndex();
    }

    protected IDiffPolicy getDiffPolicy() {
        return this._diffPolicy;
    }

    protected IMergePolicy getMergePolicy() {
        return this._mergePolicy;
    }

    protected IComparison.Editable getEditableComparison() {
        return this._comparison;
    }

    protected IMapping getMapping() {
        return this.getOutput().getMapping();
    }

    @Override
    public String getOperationName() {
        return Messages.DiffBuilder_Task_Main;
    }

    protected IElementPresence getOrCreateElementPresence(IMatch match_p) {
        assert (match_p != null && match_p.isPartial());
        IElementPresence result = match_p.getElementPresenceDifference();
        if (result == null) {
            Role presenceRole = match_p.getUncoveredRole().opposite();
            IMatch ownerMatch = this.getOutput().getContainerOf(match_p, presenceRole);
            result = this.getEditableComparison().newElementPresence(match_p, ownerMatch);
            if (this.getOutput().isThreeWay() && !match_p.coversRole(Role.ANCESTOR)) {
                ((IDifference.Editable)((Object)result)).markAsDifferentFromAncestor();
            }
            this.setElementPresenceDependencies(result);
        }
        return result;
    }

    public IComparison getOutput() {
        return this._comparison;
    }

    @Override
    protected int getWorkAmount() {
        return 1 + this.getMapping().size();
    }

    @Override
    public IStatus run() {
        this.getMonitor().worked(1);
        this.createDifferences();
        return Status.OK_STATUS;
    }

    protected void setElementPresenceDependencies(IElementPresence presence_p) {
        Role presenceRole;
        if (!presence_p.isRoot()) {
            presenceRole = presence_p.getPresenceRole();
            IMatch ownerMatch = presence_p.getOwnerMatch();
            if (this.getMergePolicy().bindPresenceToOwnership() && ownerMatch != null && ownerMatch.isPartial()) {
                IElementPresence ownerPresence = this.getOrCreateElementPresence(ownerMatch);
                ((IMergeableDifference.Editable)((Object)presence_p)).markRequires(ownerPresence, presenceRole.opposite());
                ((IMergeableDifference.Editable)((Object)ownerPresence)).markRequires(presence_p, presenceRole);
            }
        }
        presenceRole = presence_p.getPresenceRole();
        Collection<EObject> additionPeers = this.getMergePolicy().getAdditionGroup(presence_p.getElement(), this.getOutput().getScope(presenceRole));
        for (EObject peer : additionPeers) {
            IMatch peerMatch = this.getMapping().getMatchFor(peer, presenceRole);
            if (peerMatch == null || !peerMatch.isPartial()) continue;
            IElementPresence peerPresence = this.getOrCreateElementPresence(peerMatch);
            ((IMergeableDifference.Editable)((Object)presence_p)).markRequires(peerPresence, presenceRole.opposite());
            ((IMergeableDifference.Editable)((Object)peerPresence)).markRequires(presence_p, presenceRole);
        }
        Collection<EObject> deletionPeers = this.getMergePolicy().getDeletionGroup(presence_p.getElement(), this.getOutput().getScope(presenceRole));
        for (EObject peer : deletionPeers) {
            IMatch peerMatch = this.getMapping().getMatchFor(peer, presenceRole);
            if (peerMatch == null || !peerMatch.isPartial()) continue;
            IElementPresence peerPresence = this.getOrCreateElementPresence(peerMatch);
            ((IMergeableDifference.Editable)((Object)presence_p)).markRequires(peerPresence, presenceRole);
        }
    }

    protected void setOppositeReferenceDependencies(IReferenceValuePresence first_p, IReferenceValuePresence second_p) {
        assert (first_p.isOppositeOf(second_p));
        IMergeableDifference.Editable first = (IMergeableDifference.Editable)((Object)first_p);
        IMergeableDifference.Editable second = (IMergeableDifference.Editable)((Object)second_p);
        Role presenceRole = first_p.getPresenceRole();
        if (second_p.getFeature().isMany()) {
            first.markImplies(second_p, presenceRole);
            first.markImplies(second_p, presenceRole.opposite());
        } else {
            first.markRequires(second_p, presenceRole);
            first.markRequires(second_p, presenceRole.opposite());
        }
        if (first_p.getFeature().isMany()) {
            second.markImplies(first_p, presenceRole);
            second.markImplies(first_p, presenceRole.opposite());
        } else {
            second.markRequires(first_p, presenceRole);
            second.markRequires(first_p, presenceRole.opposite());
        }
    }

    protected void setPartialReferencedValueDependencies(IReferenceValuePresence referenceDiff_p) {
        assert (referenceDiff_p.getValue().isPartial());
        IElementPresence presence = this.getOrCreateElementPresence(referenceDiff_p.getValue());
        Role presenceRole = referenceDiff_p.getPresenceRole();
        IMergeableDifference.Editable referenceDiff = (IMergeableDifference.Editable)((Object)referenceDiff_p);
        referenceDiff.markRequires(presence, presenceRole.opposite());
        ((IMergeableDifference.Editable)((Object)presence)).markRequires(referenceDiff_p, presenceRole);
        if (referenceDiff_p.getFeature() != null) {
            if (referenceDiff_p.getFeature().isContainment() && this.getMergePolicy().bindPresenceToOwnership()) {
                ((IMergeableDifference.Editable)((Object)presence)).markImplies(referenceDiff_p, presenceRole.opposite());
                referenceDiff.markImplies(presence, presenceRole);
            } else {
                EReference opposite = referenceDiff_p.getFeature().getEOpposite();
                if (opposite != null && this.getMergePolicy().isMandatoryForAddition(opposite)) {
                    ((IMergeableDifference.Editable)((Object)presence)).markRequires(referenceDiff_p, presenceRole.opposite());
                    referenceDiff.markRequires(presence, presenceRole);
                }
            }
        }
    }

    protected void setPartialReferencingElementDependencies(IReferenceValuePresence referenceDiff_p) {
        assert (referenceDiff_p.getElementMatch().isPartial());
        IElementPresence presence = this.getOrCreateElementPresence(referenceDiff_p.getElementMatch());
        Role presenceRole = referenceDiff_p.getPresenceRole();
        ((IMergeableDifference.Editable)((Object)referenceDiff_p)).markRequires(presence, presenceRole.opposite());
        ((IMergeableDifference.Editable)((Object)presence)).markRequires(referenceDiff_p, presenceRole);
    }

    protected void setReferencedValueDependencies(IReferenceValuePresence presence_p) {
        IReferenceValuePresence symmetricalOwnership;
        IReferenceValuePresence symmetrical;
        IReferenceValuePresence oppositeDiff;
        EReference reference = presence_p.getFeature();
        IMatch valueMatch = presence_p.getValue();
        if (!reference.isContainment() && (oppositeDiff = presence_p.getOpposite()) != null) {
            this.setOppositeReferenceDependencies(presence_p, oppositeDiff);
        }
        if ((symmetrical = presence_p.getSymmetrical()) != null) {
            this.setSymmetricalValuePresenceDependencies(presence_p, symmetrical);
        }
        if (presence_p.getElementMatch().isPartial()) {
            this.setPartialReferencingElementDependencies(presence_p);
        }
        if (valueMatch.isPartial()) {
            this.setPartialReferencedValueDependencies(presence_p);
        } else if (reference.isContainment() && (symmetricalOwnership = presence_p.getSymmetricalOwnership()) != null) {
            this.setSymmetricalOwnershipDependencies(presence_p, symmetricalOwnership);
        }
    }

    protected void setSymmetricalOwnershipDependencies(IReferenceValuePresence first_p, IReferenceValuePresence second_p) {
        assert (first_p.isSymmetricalOwnershipTo(second_p));
        IMergeableDifference.Editable first = (IMergeableDifference.Editable)((Object)first_p);
        IMergeableDifference.Editable second = (IMergeableDifference.Editable)((Object)second_p);
        first.markImplies(second_p, second_p.getPresenceRole());
        second.markImplies(first_p, first_p.getPresenceRole());
        first.markRequires(second_p, first_p.getPresenceRole());
        second.markRequires(first_p, second_p.getPresenceRole());
    }

    protected void setSymmetricalValuePresenceDependencies(IValuePresence first_p, IValuePresence second_p) {
        assert (first_p.isSymmetricalTo(second_p));
        IMergeableDifference.Editable first = (IMergeableDifference.Editable)((Object)first_p);
        IMergeableDifference.Editable second = (IMergeableDifference.Editable)((Object)second_p);
        first.markImplies(second_p, second_p.getPresenceRole());
        second.markImplies(first_p, first_p.getPresenceRole());
        first.markRequires(second_p, first_p.getPresenceRole());
        second.markRequires(first_p, second_p.getPresenceRole());
    }

    protected void setThreeWayProperties(IAttributeValuePresence presence_p) {
        EObject ancestorHolder = presence_p.getElementMatch().get(Role.ANCESTOR);
        if (ancestorHolder != null) {
            boolean aligned;
            EAttribute attribute = presence_p.getFeature();
            IFeaturedModelScope ancestorScope = this._comparison.getScope(Role.ANCESTOR);
            assert (ancestorScope != null);
            List<Object> valuesInAncestor = ancestorScope.get(ancestorHolder, attribute);
            if (presence_p.isOrder()) {
                Role presenceRole = presence_p.getPresenceRole();
                List<Object> values = this._comparison.getScope(presenceRole).get(presence_p.getElementMatch().get(presenceRole), presence_p.getFeature());
                int maxIndex = -1;
                aligned = true;
                for (Object value : values) {
                    ObjectAndIndex matchingAncestorValue = this.findEqualAttributeValue(attribute, value, valuesInAncestor);
                    if (matchingAncestorValue.getObject() == null) continue;
                    if (matchingAncestorValue.getIndex() < maxIndex) {
                        aligned = false;
                        break;
                    }
                    maxIndex = matchingAncestorValue.getIndex();
                }
            } else {
                ObjectAndIndex equalInAncestor = this.findEqualAttributeValue(attribute, presence_p.getValue(), valuesInAncestor);
                boolean bl = aligned = equalInAncestor.getObject() != null;
            }
            if (!aligned) {
                IAttributeValuePresence symmetrical = presence_p.getSymmetrical();
                if (symmetrical != null && !symmetrical.isAlignedWithAncestor()) {
                    ((IDifference.Editable)((Object)presence_p)).markAsConflicting();
                    ((IDifference.Editable)((Object)symmetrical)).markAsConflicting();
                } else {
                    ((IDifference.Editable)((Object)presence_p)).markAsDifferentFromAncestor();
                }
            }
        }
    }

    protected void setThreeWayProperties(IReferenceValuePresence presence_p) {
        boolean aligned;
        EObject ancestorHolder = presence_p.getElementMatch().get(Role.ANCESTOR);
        if (ancestorHolder == null) {
            aligned = false;
        } else {
            IMatch valueMatch = presence_p.getValue();
            EObject ancestorValue = valueMatch.get(Role.ANCESTOR);
            IFeaturedModelScope ancestorScope = this._comparison.getScope(Role.ANCESTOR);
            assert (ancestorScope != null);
            FArrayList<EObject> ancestorValues = new FArrayList<EObject>(ancestorScope.get(ancestorHolder, presence_p.getFeature()), IEqualityTester.BY_REFERENCE);
            if (presence_p.isOrder()) {
                Role presenceRole = presence_p.getPresenceRole();
                List<EObject> values = this._comparison.getScope(presenceRole).get(presence_p.getElementMatch().get(presenceRole), presence_p.getFeature());
                int maxIndex = -1;
                aligned = true;
                for (EObject value : values) {
                    int index;
                    EObject matchAncestor;
                    IMatch currentValueMatch = this.getMapping().getMatchFor(value, presenceRole);
                    if (currentValueMatch == null || (matchAncestor = currentValueMatch.get(Role.ANCESTOR)) == null || (index = ancestorValues.indexOf(matchAncestor)) < 0) continue;
                    if (index < maxIndex) {
                        aligned = false;
                        break;
                    }
                    maxIndex = index;
                }
            } else {
                aligned = ancestorValues.contains(ancestorValue);
            }
        }
        if (!aligned) {
            IReferenceValuePresence symmetrical = presence_p.getSymmetrical();
            if (symmetrical != null && !symmetrical.isAlignedWithAncestor()) {
                ((IDifference.Editable)((Object)presence_p)).markAsConflicting();
                ((IDifference.Editable)((Object)symmetrical)).markAsConflicting();
            } else {
                ((IDifference.Editable)((Object)presence_p)).markAsDifferentFromAncestor();
            }
        }
    }

    protected static class ObjectAndIndex {
        private Object _object;
        private int _index;

        public ObjectAndIndex(Object object_p, int index_p) {
            assert (object_p != null && index_p >= 0);
            this._object = object_p;
            this._index = index_p;
        }

        public ObjectAndIndex() {
            this._object = null;
            this._index = -1;
        }

        public boolean equals(Object peer_p) {
            boolean result = false;
            if (peer_p instanceof ObjectAndIndex) {
                ObjectAndIndex peer = (ObjectAndIndex)peer_p;
                result = this._object == null && peer.getObject() == null || this._object != null && this._object.equals(peer.getObject());
                result = result && this._index == peer.getIndex();
            }
            return result;
        }

        public Object getObject() {
            return this._object;
        }

        public int getIndex() {
            return this._index;
        }

        public int hashCode() {
            return (this._object != null ? this._object.hashCode() : 0) + Integer.valueOf(this._index).hashCode();
        }
    }
}

