/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.engine.operations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.Messages;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IPatternSupport;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IEvaluationStatus;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IModelTransformationStatus;
import org.eclipse.emf.diffmerge.patterns.core.operations.AbstractModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.operations.InstanceOperation;
import org.eclipse.emf.diffmerge.patterns.support.gen.commonpatternsupport.CommonPatternInstance;
import org.eclipse.emf.diffmerge.patterns.templates.engine.NamingUtil;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyNTimesTemplatePatternOperation
extends AbstractModelOperation<Collection<IPatternInstance>> {
    private final IPatternApplication _application;
    private final String _namingRule;
    private final boolean _unfold;
    private final int _numberOfApplications;
    private final int _multiplicity;

    public ApplyNTimesTemplatePatternOperation(IPatternApplication application_p, boolean unfold_p, String namingRule_p, int numberOfApplications_p, int multiplicity_p, Object targetContext_p, Object sourceContext_p) {
        super(Messages.CreateInstanceOperation_Name, null, false, false, true, targetContext_p, sourceContext_p);
        this._application = application_p;
        this._namingRule = namingRule_p;
        this._unfold = unfold_p;
        this._numberOfApplications = numberOfApplications_p;
        this._multiplicity = multiplicity_p;
    }

    protected Collection<IPatternInstance> run() {
        ArrayList<IPatternInstance> result = new ArrayList<IPatternInstance>();
        IPatternSupport patternSupport = CorePatternsPlugin.getDefault().getPatternSupportFor(this._application);
        if (patternSupport != null) {
            int i = 1;
            while (i <= this._numberOfApplications) {
                IPatternInstance currentInstance = patternSupport.createInstance(this._application);
                result.add(this.createIndexedInstance(currentInstance, i));
                ++i;
            }
        }
        return result;
    }

    protected IPatternInstance createIndexedInstance(IPatternInstance instance_p, int index_p) {
        if (instance_p != null && instance_p.getPatternData() instanceof TemplatePatternData) {
            TemplatePatternData data = (TemplatePatternData)instance_p.getPatternData();
            String finalNamingRule = this._namingRule;
            if (finalNamingRule != null) {
                finalNamingRule = NamingUtil.substituteIndex(finalNamingRule, index_p);
            }
            data.setNamingRule(finalNamingRule);
            data.setMultiplicity(this._multiplicity);
        }
        if (instance_p != null && this._unfold) {
            InstanceOperation unfoldOperation = new InstanceOperation(instance_p, InstanceOperation.InstanceOperationKind.UNFOLD, null, this.getTargetContext(), this.getSourceContext());
            IEvaluationStatus unfoldStatus = (IEvaluationStatus)this.call((AbstractModelOperation)unfoldOperation);
            if (unfoldStatus instanceof IModelTransformationStatus && ((IModelTransformationStatus)unfoldStatus).isAborted()) {
                this.abort();
            } else {
                try {
                    if (instance_p instanceof CommonPatternInstance) {
                        ((CommonPatternInstance)instance_p).eResource().save(null);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return instance_p;
                }
            }
        }
        return instance_p;
    }
}

