/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.diffmerge.patterns.core.SingletonContributionDiscoverer;
import org.eclipse.emf.diffmerge.patterns.ui.environment.DefaultModelEnvironmentUI;
import org.eclipse.emf.diffmerge.patterns.ui.environment.IModelEnvironmentUI;
import org.eclipse.emf.diffmerge.patterns.ui.factories.IPatternDialogAndWizardFactory;
import org.eclipse.emf.diffmerge.patterns.ui.factories.IPatternJobFactory;
import org.eclipse.emf.diffmerge.patterns.ui.misc.PersistentSelection;
import org.eclipse.emf.diffmerge.patterns.ui.util.IUIExtender;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PatternsUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.diffmerge.patterns.ui";
    private static PatternsUIPlugin plugin;
    private static final String MODEL_ENVIRONMENT_UI_EXTENSION_POINT = "org.eclipse.emf.diffmerge.patterns.ui.modelenvironmentui";
    private static final String MODEL_ENVIRONMENT_UI_POINT_PROPERTY = "class";
    private IPatternJobFactory _patternJobFactory;
    private static final String JOB_FACTORY_EXTENSION_POINT = "org.eclipse.emf.diffmerge.patterns.ui.jobFactory";
    private static final String JOB_FACTORY_POINT_PROPERTY = "class";
    private IPatternDialogAndWizardFactory _patternDialogAndWizardFactory;
    private static final String DIALOG_AND_WIZARD_FACTORY_EXTENSION_POINT = "org.eclipse.emf.diffmerge.patterns.ui.dialogAndWizardFactory";
    private static final String DIALOG_AND_WIZARD_FACTORY_POINT_PROPERTY = "class";
    private IUIExtender _uiExtender;
    private static final String UI_EXTENDER_EXTENSION_POINT = "org.eclipse.emf.diffmerge.patterns.ui.uiextender";
    private static final String UI_EXTENDER_POINT_PROPERTY = "class";
    private static final String ICON_PATH = "icons/full/";
    private IModelEnvironmentUI _modelEnvironmentUI;
    private final PersistentSelection _persistentSelection = new PersistentSelection();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.initializeIcons();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static PatternsUIPlugin getDefault() {
        return plugin;
    }

    public Image getImage(ImageID id_p) {
        return this.getImageRegistry().get(id_p.name());
    }

    public ImageDescriptor getImageDescriptor(ImageID id_p) {
        return this.getImageRegistry().getDescriptor(id_p.name());
    }

    private void initializeIcons() {
        ImageID[] imageIDArray = ImageID.values();
        int n = imageIDArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageID imageId = imageIDArray[n2];
            this.registerLocalIcon(imageId);
            ++n2;
        }
    }

    private ImageDescriptor registerLocalIcon(ImageID imageID_p) {
        ImageDescriptor result = null;
        String path = ICON_PATH + imageID_p.name().toLowerCase() + ".gif";
        try {
            result = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)this.getBundle().getEntry(path)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result != null) {
            this.getImageRegistry().put(imageID_p.name(), result);
        }
        return result;
    }

    public PersistentSelection getPersistentSelection() {
        return this._persistentSelection;
    }

    public IModelEnvironmentUI getModelEnvironmentUI() {
        if (this._modelEnvironmentUI == null) {
            SingletonContributionDiscoverer d = new SingletonContributionDiscoverer(IModelEnvironmentUI.class, MODEL_ENVIRONMENT_UI_EXTENSION_POINT, "class");
            this._modelEnvironmentUI = (IModelEnvironmentUI)d.getContributedSingleton();
        }
        if (this._modelEnvironmentUI == null) {
            this._modelEnvironmentUI = new DefaultModelEnvironmentUI();
        }
        return this._modelEnvironmentUI;
    }

    public IPatternJobFactory getJobFactory() {
        if (this._patternJobFactory == null) {
            SingletonContributionDiscoverer d = new SingletonContributionDiscoverer(IPatternJobFactory.class, JOB_FACTORY_EXTENSION_POINT, "class");
            this._patternJobFactory = (IPatternJobFactory)d.getContributedSingleton();
        }
        return this._patternJobFactory;
    }

    public IPatternDialogAndWizardFactory getDialogAndWizardFactory() {
        if (this._patternDialogAndWizardFactory == null) {
            SingletonContributionDiscoverer d = new SingletonContributionDiscoverer(IPatternDialogAndWizardFactory.class, DIALOG_AND_WIZARD_FACTORY_EXTENSION_POINT, "class");
            this._patternDialogAndWizardFactory = (IPatternDialogAndWizardFactory)d.getContributedSingleton();
        }
        return this._patternDialogAndWizardFactory;
    }

    public IUIExtender getSemanticUIUtil() {
        if (this._uiExtender == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] config = registry.getConfigurationElementsFor(UI_EXTENDER_EXTENSION_POINT);
            HashSet<IUIExtender> extenders = new HashSet<IUIExtender>();
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    Object o = e.createExecutableExtension("class");
                    if (o instanceof IUIExtender) {
                        extenders.add((IUIExtender)o);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++n2;
            }
            HashSet<? extends Class<? extends IUIExtender>> overriddenClasses = new HashSet<Class<? extends IUIExtender>>();
            for (IUIExtender extender : extenders) {
                overriddenClasses.addAll(extender.getOverridenClasses());
            }
            for (IUIExtender extender : new HashSet(extenders)) {
                for (Class clazz : overriddenClasses) {
                    if (!extender.getClass().equals(clazz)) continue;
                    extenders.remove(extender);
                }
            }
            if (!extenders.isEmpty()) {
                this._uiExtender = (IUIExtender)extenders.iterator().next();
            }
        }
        return this._uiExtender;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageID {
        CATALOG,
        PATTERN,
        INSTANCE,
        COLLAPSEALL,
        EXPANDALL,
        REFRESH,
        SORT;

    }
}

