/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.helpers;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IMapping;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.impl.helpers.BidirectionalComparisonCopier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnidirectionalComparisonCopier
extends EcoreUtil.Copier {
    private static final long serialVersionUID = 5334350558149241676L;
    protected final Role _sourceRole;
    protected IMapping.Editable _mapping;
    protected IFeaturedModelScope _sourceScope;
    protected IEditableModelScope _destinationScope;
    protected IMergePolicy _mergePolicy;

    public UnidirectionalComparisonCopier(Role sourceRole_p) {
        super(false, true);
        this._sourceRole = sourceRole_p;
        this._mapping = null;
        this._sourceScope = null;
        this._destinationScope = null;
    }

    public EObject copy(EObject element_p) {
        EObject result = this.copyAsProxy(element_p);
        for (EAttribute attribute : element_p.eClass().getEAllAttributes()) {
            if (!this.coverFeature((EStructuralFeature)attribute)) continue;
            this.copyAttribute(attribute, element_p, result);
        }
        return result;
    }

    public EObject completeMatch(IMatch partialMatch_p, IComparison.Editable comparison_p) {
        assert (partialMatch_p.getUncoveredRole() == this._sourceRole.opposite() && this.getCompletedMatches().contains(partialMatch_p));
        this.setComparison(comparison_p);
        EObject element = partialMatch_p.get(this._sourceRole);
        EObject result = this.copy(element);
        assert (result != null);
        this._mapping.mapIncrementally(element, this._sourceRole, result, this._sourceRole.opposite());
        this.getCompletedMatches().add(this._mapping.getMatchFor(element, this._sourceRole));
        return result;
    }

    public void completeReferences(IComparison.Editable comparison_p) {
        this.setComparison(comparison_p);
        this.copyReferences();
    }

    protected EObject copyAsProxy(EObject element_p) {
        EObject result = this.createCopy(element_p);
        this.copyProxyURI(element_p, result);
        return result;
    }

    protected void copyAttribute(EAttribute attribute_p, EObject element_p, EObject copy_p) {
        for (Object value : this._sourceScope.get(element_p, attribute_p)) {
            this._destinationScope.add(copy_p, attribute_p, value);
        }
    }

    public void copyReferences() {
        for (IMatch updatedMatch : this.getCompletedMatches()) {
            this.copyReferences(updatedMatch);
        }
        if (this._mergePolicy != null) {
            for (IMatch updatedMatch : this.getCompletedMatches()) {
                EObject source = updatedMatch.get(this._sourceRole);
                EObject target = updatedMatch.get(this._sourceRole.opposite());
                BidirectionalComparisonCopier.handleIDCopy(source, this._sourceScope, target, this._destinationScope, this._mergePolicy);
            }
        }
    }

    protected void copyReferences(IMatch match_p) {
        EObject source = match_p.get(this._sourceRole);
        EObject destination = match_p.get(this._sourceRole.opposite());
        assert (source != null && destination != null);
        for (EReference reference : source.eClass().getEAllReferences()) {
            if (reference.isContainer() || !this.coverFeature((EStructuralFeature)reference)) continue;
            this.copyReference(reference, source, destination);
        }
    }

    protected void copyReference(EReference reference_p, EObject source_p, EObject destination_p) {
        List<EObject> sourceValues = this._sourceScope.get(source_p, reference_p);
        for (EObject sourceValue : sourceValues) {
            IMatch valueMatch = this._mapping.getMatchFor(sourceValue, this._sourceRole);
            if (valueMatch != null) {
                EObject destinationValue;
                IMatch holderMatch;
                boolean mustCopy;
                boolean bl = mustCopy = this.getCompletedMatches().contains(valueMatch) || reference_p.getEOpposite() == null && !reference_p.isContainment();
                if (!mustCopy && (holderMatch = this._mapping.getMatchFor(source_p, this._sourceRole)) != null) {
                    boolean bl2 = mustCopy = holderMatch.getReferenceValueDifference(reference_p, valueMatch) == null;
                }
                if (!mustCopy || (destinationValue = valueMatch.get(this._sourceRole.opposite())) == null) continue;
                this._destinationScope.add(destination_p, reference_p, destinationValue);
                continue;
            }
            if (!this.useOriginalReferences || reference_p.getEOpposite() != null || reference_p.isContainment() || reference_p.isContainer()) continue;
            this._destinationScope.add(destination_p, reference_p, sourceValue);
        }
    }

    protected boolean coverFeature(EStructuralFeature feature_p) {
        return this._mergePolicy != null && this._mergePolicy.copyFeature(feature_p, this._destinationScope);
    }

    public EObject get(Object key_p) {
        return this.get(key_p, true);
    }

    public EObject get(Object key_p, boolean inCopierOnly_p) {
        IMatch match;
        EObject result = null;
        if (key_p instanceof EObject && (match = this._mapping.getMatchFor((EObject)key_p, this._sourceRole)) != null && (!inCopierOnly_p || this.getCompletedMatches().contains(match))) {
            result = match.get(this._sourceRole.opposite());
        }
        return result;
    }

    protected Collection<IMatch> getCompletedMatches() {
        return this._mapping.getModifiableCompletedMatches(this._sourceRole.opposite());
    }

    protected void setComparison(IComparison.Editable comparison_p) {
        this._mapping = comparison_p.getMapping();
        this._sourceScope = comparison_p.getScope(this._sourceRole);
        this._destinationScope = comparison_p.getScope(this._sourceRole.opposite());
        this._mergePolicy = comparison_p.getLastMergePolicy();
        if (this._mergePolicy != null) {
            this.useOriginalReferences = this._mergePolicy.copyOutOfScopeCrossReferences(this._sourceScope, this._destinationScope);
        }
    }
}

