/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.api.diff.IElementRelativeDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementRelativePresence;
import org.eclipse.emf.diffmerge.api.diff.IPresenceDifference;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.diffuidata.MatchAndFeature;
import org.eclipse.emf.diffmerge.ui.diffuidata.UIComparison;
import org.eclipse.emf.diffmerge.ui.diffuidata.impl.UIComparisonImpl;
import org.eclipse.emf.diffmerge.ui.setup.EMFDiffMergeEditorInput;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonResourceManager;
import org.eclipse.emf.diffmerge.util.structures.FHashMap;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.diffmerge.util.structures.IEqualityTester;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.services.IDisposable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFDiffNode
extends DiffNode
implements IDisposable,
IEditingDomainProvider {
    private final ComparisonResourceManager _resourceManager = new ComparisonResourceManager();
    private final UIComparison _contents;
    private final EditingDomain _editingDomain;
    private Role _drivingRole;
    private Role _leftRole;
    private Role _twoWayReferenceRole;
    private final Set<UserDifferenceKind> _countedKinds;
    private final EMap<EMatch, Integer> _matchToNb;
    private boolean _useCustomIcons;
    private boolean _useCustomLabels;
    private boolean _isTargetEditable;
    private boolean _isReferenceEditable;
    private final boolean _isTargetEditionPossible;
    private final boolean _isReferenceEditionPossible;
    private boolean _isTargetModified;
    private boolean _isReferenceModified;
    private boolean _isHideDifferenceNumbers;
    private boolean _isShowMergeImpact;
    private boolean _isUndoRedoSupported;
    private boolean _isLogEvents;
    private boolean _defaultCoverChildren;
    private boolean _defaultIncrementalMode;
    private boolean _defaultShowMergeImpact;
    private final Map<EMFDiffMergeUIPlugin.DifferenceColorKind, Integer> _differenceColors;

    public EMFDiffNode(EComparison comparison_p) {
        this(comparison_p, null);
    }

    public EMFDiffNode(EComparison comparison_p, EditingDomain domain_p) {
        this(comparison_p, domain_p, true, true);
    }

    public EMFDiffNode(EComparison comparison_p, EditingDomain domain_p, boolean isLeftEditionPossible_p, boolean isRightEditionPossible_p) {
        super(3, (ITypedElement)(comparison_p.isThreeWay() ? new EMFDiffMergeEditorInput.ScopeTypedElementWrapper(comparison_p.getScope(Role.ANCESTOR)) : null), (ITypedElement)new EMFDiffMergeEditorInput.ScopeTypedElementWrapper(comparison_p.getScope(Role.TARGET)), (ITypedElement)new EMFDiffMergeEditorInput.ScopeTypedElementWrapper(comparison_p.getScope(Role.REFERENCE)));
        this._contents = new UIComparisonImpl(comparison_p);
        this._editingDomain = domain_p;
        this._drivingRole = this._leftRole = EMFDiffMergeUIPlugin.getDefault().getDefaultLeftRole();
        this._twoWayReferenceRole = null;
        this._differenceColors = new HashMap<EMFDiffMergeUIPlugin.DifferenceColorKind, Integer>();
        this.initializeDifferenceColors(this._differenceColors);
        this._matchToNb = new FHashMap(IEqualityTester.BY_EQUALS);
        this._countedKinds = new HashSet<UserDifferenceKind>(Arrays.asList(UserDifferenceKind.values()));
        this._useCustomIcons = true;
        this._useCustomLabels = false;
        this._isTargetEditionPossible = isLeftEditionPossible_p;
        this._isReferenceEditionPossible = isRightEditionPossible_p;
        this._isTargetEditable = this._isTargetEditionPossible;
        this._isReferenceEditable = this._isReferenceEditionPossible;
        this._isTargetModified = false;
        this._isReferenceModified = false;
        this._isHideDifferenceNumbers = false;
        this._isShowMergeImpact = true;
        this._isUndoRedoSupported = this._editingDomain != null;
        this._isLogEvents = false;
        this._defaultShowMergeImpact = this._isShowMergeImpact;
        this._defaultCoverChildren = true;
        this._defaultIncrementalMode = false;
    }

    protected void initializeDifferenceColors(Map<EMFDiffMergeUIPlugin.DifferenceColorKind, Integer> differenceColorsMap_p) {
        differenceColorsMap_p.put(EMFDiffMergeUIPlugin.DifferenceColorKind.LEFT, 4);
        differenceColorsMap_p.put(EMFDiffMergeUIPlugin.DifferenceColorKind.RIGHT, 9);
        differenceColorsMap_p.put(EMFDiffMergeUIPlugin.DifferenceColorKind.BOTH, 12);
        differenceColorsMap_p.put(EMFDiffMergeUIPlugin.DifferenceColorKind.NONE, 15);
        differenceColorsMap_p.put(EMFDiffMergeUIPlugin.DifferenceColorKind.CONFLICT, 3);
        differenceColorsMap_p.put(EMFDiffMergeUIPlugin.DifferenceColorKind.DEFAULT, 2);
    }

    public boolean isEditable(boolean left_p) {
        return this.getRoleForSide(left_p) == Role.TARGET ? this._isTargetEditable : this._isReferenceEditable;
    }

    public boolean isEditionPossible(boolean left_p) {
        return this.getRoleForSide(left_p) == Role.TARGET ? this._isTargetEditionPossible : this._isReferenceEditionPossible;
    }

    public boolean isModified(boolean left_p) {
        return this.getRoleForSide(left_p) == Role.TARGET ? this._isTargetModified : this._isReferenceModified;
    }

    public boolean isShowMergeImpact() {
        return this._isShowMergeImpact;
    }

    public boolean isUndoRedoSupported() {
        return this._isUndoRedoSupported;
    }

    public boolean isLogEvents() {
        return this._isLogEvents;
    }

    public boolean isDefaultCoverChildren() {
        return this._defaultCoverChildren;
    }

    public boolean isDefaultIncrementalMode() {
        return this._defaultIncrementalMode;
    }

    public boolean isDefaultShowImpact() {
        return this._defaultShowMergeImpact;
    }

    protected int countDifferenceNumber(IMatch match_p) {
        IElementPresence presence;
        int result = 0;
        if (this.counts(UserDifferenceKind.NO_CONTAINMENT)) {
            result += this.countNonContainmentDifferenceNumber(match_p);
        }
        if (this.counts(UserDifferenceKind.MOVE) && this.isAMove(match_p, false, false)) {
            ++result;
        }
        if ((presence = match_p.getElementPresenceDifference()) != null && !this.shouldBeIgnored((IDifference)presence)) {
            boolean countPresence;
            boolean isLeftPresence = presence.getPresenceRole() == this.getRoleForSide(true);
            boolean bl = countPresence = isLeftPresence ? this.counts(UserDifferenceKind.PRESENCE_LEFT) : this.counts(UserDifferenceKind.PRESENCE_RIGHT);
            if (countPresence) {
                ++result;
            }
        }
        return result;
    }

    protected int countNonContainmentDifferenceNumber(IMatch match_p) {
        int result = 0;
        if (!match_p.isPartial()) {
            HashSet<EStructuralFeature> uniFeatures = new HashSet<EStructuralFeature>();
            for (IDifference difference : match_p.getRelatedDifferences()) {
                IElementRelativeDifference eltDiff;
                if (!(difference instanceof IElementRelativeDifference) || this.shouldBeIgnored(difference) || !(eltDiff = (IElementRelativeDifference)difference).isUnrelatedToContainmentTree()) continue;
                if (eltDiff instanceof IValuePresence) {
                    EStructuralFeature feature = ((IValuePresence)eltDiff).getFeature();
                    if (feature != null && (!feature.isMany() || ((IValuePresence)eltDiff).isOrder())) {
                        if (uniFeatures.contains(feature)) continue;
                        ++result;
                        uniFeatures.add(feature);
                        continue;
                    }
                    ++result;
                    continue;
                }
                ++result;
            }
        }
        return result;
    }

    public boolean counts(UserDifferenceKind kind_p) {
        return this._countedKinds.contains((Object)kind_p);
    }

    public void dispose() {
        this._resourceManager.dispose();
    }

    public EComparison getActualComparison() {
        return this.getUIComparison().getActualComparison();
    }

    protected EMatch getContainerOf(EMatch match_p) {
        Role containerSide = match_p.getUncoveredRole() == this.getDrivingRole() ? this.getDrivingRole().opposite() : this.getDrivingRole();
        EMatch result = (EMatch)this.getActualComparison().getContainerOf((IMatch)match_p, containerSide);
        return result;
    }

    public Color getDifferenceColor(EMFDiffMergeUIPlugin.DifferenceColorKind colorKind_p) {
        int colorCode = 2;
        Integer colorCodeI = this._differenceColors.get((Object)colorKind_p);
        if (colorCodeI != null) {
            colorCode = colorCodeI;
        }
        return UIUtil.getColor(colorCode);
    }

    public DifferenceKind getDifferenceKind(IMatch match_p) {
        boolean considerReference;
        DifferenceKind result = DifferenceKind.NONE;
        IElementPresence presence = match_p.getElementPresenceDifference();
        boolean bl = considerReference = this.getReferenceRole() != null;
        if (presence != null) {
            result = this.getDifferenceKind((IDifference)presence);
        } else {
            result = this.getModificationKind(match_p);
            result = result.with(this.getOwnershipDifferenceKind(match_p), considerReference);
            result = result.keepOnlyDirection(considerReference);
        }
        if (result == DifferenceKind.NONE && this.getDifferenceNumber(match_p) > 0) {
            result = DifferenceKind.COUNTED;
        }
        return result;
    }

    public DifferenceKind getDifferenceKind(MatchAndFeature maf_p) {
        DifferenceKind result = DifferenceKind.NONE;
        EStructuralFeature feature = maf_p.getFeature();
        if (feature == EMFDiffMergeUIPlugin.getDefault().getOwnershipFeature()) {
            result = this.getOwnershipDifferenceKind((IMatch)maf_p.getMatch());
        } else {
            Collection presences;
            if (feature instanceof EReference) {
                if (((EReference)feature).isContainment()) {
                    presences = new ArrayList();
                    IValuePresence orderDiff = maf_p.getMatch().getOrderDifference(feature, this.getDrivingRole());
                    if (orderDiff != null) {
                        ((List)presences).add(orderDiff);
                    }
                    if ((orderDiff = maf_p.getMatch().getOrderDifference(feature, this.getDrivingRole().opposite())) != null) {
                        ((List)presences).add(orderDiff);
                    }
                } else {
                    presences = maf_p.getMatch().getReferenceDifferences((EReference)feature);
                }
            } else {
                presences = maf_p.getMatch().getAttributeDifferences((EAttribute)feature);
            }
            Iterator it = presences.iterator();
            while (it.hasNext() && result != DifferenceKind.CONFLICT && result != DifferenceKind.FROM_BOTH && result != DifferenceKind.MODIFIED) {
                DifferenceKind current = this.getDifferenceKind((IDifference)it.next());
                result = result.with(current, true);
            }
        }
        return result;
    }

    public DifferenceKind getDifferenceKind(IDifference difference_p) {
        DifferenceKind result = DifferenceKind.NONE;
        if (!this.shouldBeIgnored(difference_p)) {
            if (difference_p.isConflicting()) {
                result = DifferenceKind.CONFLICT;
            } else if (difference_p instanceof IPresenceDifference) {
                IPresenceDifference presence = (IPresenceDifference)difference_p;
                boolean isMany = this.isMany(presence);
                result = presence.getPresenceRole() == this.getRoleForSide(true) ? (this.isAlignedWithReference(presence) ? DifferenceKind.FROM_RIGHT_DEL : (isMany || this.getReferenceRole() != null ? DifferenceKind.FROM_LEFT_ADD : DifferenceKind.MODIFIED)) : (this.isAlignedWithReference(presence) ? DifferenceKind.FROM_LEFT_DEL : (isMany || this.getReferenceRole() != null ? DifferenceKind.FROM_RIGHT_ADD : DifferenceKind.MODIFIED));
            }
        }
        return result;
    }

    public int getDifferenceNumber(IMatch match_p) {
        Integer currentNb = (Integer)this.getMatchToNb().get((Object)match_p);
        if (currentNb == null) {
            currentNb = 0;
        }
        return currentNb;
    }

    public Role getDrivingRole() {
        return this._drivingRole;
    }

    public List<IMatch> getChildrenForMerge(IMatch match_p) {
        List candidates = this.getActualComparison().getContentsOf(match_p);
        FOrderedSet result = new FOrderedSet();
        IComparison comparison = match_p.getMapping().getComparison();
        for (IMatch candidate : candidates) {
            if (this.isAMove(candidate, false, false) && comparison.getContainerOf(candidate, this.getDrivingRole().opposite()) == match_p || this.getDifferenceNumber(candidate) <= 0) continue;
            result.add(candidate);
        }
        return Collections.unmodifiableList(result);
    }

    public EditingDomain getEditingDomain() {
        return this._editingDomain;
    }

    protected EMap<EMatch, Integer> getMatchToNb() {
        return this._matchToNb;
    }

    protected DifferenceKind getModificationKind(IMatch match_p) {
        boolean considerReference;
        DifferenceKind result = DifferenceKind.NONE;
        boolean bl = considerReference = this.getReferenceRole() != null;
        if (this.counts(UserDifferenceKind.NO_CONTAINMENT) && match_p.getElementPresenceDifference() == null) {
            for (IDifference diff : match_p.getRelatedDifferences()) {
                DifferenceKind diffKind;
                if (diff instanceof IElementRelativeDifference && ((IElementRelativeDifference)diff).isUnrelatedToContainmentTree() && (result = result.with(diffKind = this.getDifferenceKind(diff), considerReference)) == DifferenceKind.CONFLICT) break;
            }
        }
        return result;
    }

    public List<IDifference> getNonIgnoredDifferences(Iterable<? extends IDifference> differences_p) {
        ArrayList<IDifference> result = new ArrayList<IDifference>();
        for (IDifference iDifference : differences_p) {
            if (this.shouldBeIgnored(iDifference)) continue;
            result.add(iDifference);
        }
        return Collections.unmodifiableList(result);
    }

    protected DifferenceKind getOwnershipDifferenceKind(IMatch match_p) {
        DifferenceKind result = DifferenceKind.NONE;
        if (this.representAsMove(match_p)) {
            result = DifferenceKind.MODIFIED;
            if (this.getReferenceRole() != null) {
                boolean fromRight;
                IReferenceValuePresence onLeft = match_p.getOwnershipDifference(this.getRoleForSide(true));
                boolean fromLeft = onLeft != null && !this.isAlignedWithReference((IPresenceDifference)onLeft);
                IReferenceValuePresence onRight = match_p.getOwnershipDifference(this.getRoleForSide(false));
                boolean bl = fromRight = onRight != null && !this.isAlignedWithReference((IPresenceDifference)onRight);
                if (fromLeft && fromRight) {
                    result = DifferenceKind.CONFLICT;
                } else if (fromLeft) {
                    result = DifferenceKind.FROM_LEFT;
                } else if (fromRight) {
                    result = DifferenceKind.FROM_RIGHT;
                }
            }
        }
        return result;
    }

    public Role getReferenceRole() {
        return this.isThreeWay() ? Role.ANCESTOR : this._twoWayReferenceRole;
    }

    public ComparisonResourceManager getResourceManager() {
        return this._resourceManager;
    }

    public Role getRoleForSide(boolean left_p) {
        return left_p ? this._leftRole : this._leftRole.opposite();
    }

    public UIComparison getUIComparison() {
        return this._contents;
    }

    public int getUIDifferenceNumber(EMatch match_p) {
        if (this.isHideDifferenceNumbers()) {
            return 0;
        }
        Role leftRole = this.getRoleForSide(true);
        int result = this.getDifferenceNumber((IMatch)match_p);
        if (match_p.getUncoveredRole() == leftRole && this.counts(UserDifferenceKind.PRESENCE_RIGHT) || match_p.getUncoveredRole() == leftRole.opposite() && this.counts(UserDifferenceKind.PRESENCE_LEFT)) {
            --result;
        }
        return result;
    }

    public boolean hasChildren() {
        return this.getUIComparison().getActualComparison().hasRemainingDifferences();
    }

    public boolean hasChildrenForMerge(IMatch match_p) {
        List candidates = this.getActualComparison().getContentsOf(match_p);
        IComparison comparison = match_p.getMapping().getComparison();
        for (IMatch candidate : candidates) {
            if (this.isAMove(candidate, false, false) && comparison.getContainerOf(candidate, this.getDrivingRole().opposite()) == match_p || this.getDifferenceNumber(candidate) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasNonContainmentDifferencesForMerge(IMatch match_p) {
        if (!match_p.isPartial()) {
            for (IDifference difference : match_p.getRelatedDifferences()) {
                IElementRelativeDifference eltDiff;
                if (!(difference instanceof IElementRelativeDifference) || this.shouldBeIgnored(difference) || !(eltDiff = (IElementRelativeDifference)difference).isUnrelatedToContainmentTree()) continue;
                return true;
            }
        }
        return false;
    }

    protected void incrementDifferenceNumbers(EMatch match_p, int increment_p) {
        int currentNb = this.getDifferenceNumber((IMatch)match_p);
        Integer newNb = increment_p + currentNb;
        this.getMatchToNb().put((Object)match_p, (Object)newNb);
    }

    protected void incrementDifferenceNumbersInHierarchy(EMatch match_p, int increment_p) {
        if (increment_p > 0) {
            this.incrementDifferenceNumbers(match_p, increment_p);
            EMatch current = this.getContainerOf(match_p);
            while (current != null) {
                this.incrementDifferenceNumbers(current, increment_p);
                current = this.getContainerOf(current);
            }
        }
    }

    protected boolean isAlignedWithReference(IPresenceDifference presence_p) {
        boolean result = this.isThreeWay() ? presence_p.isAlignedWithAncestor() : presence_p.getPresenceRole() == this.getReferenceRole();
        return result;
    }

    public boolean isAMove(IMatch match_p, boolean considerMerged_p, boolean considerIgnored_p) {
        boolean result = false;
        if (!match_p.isPartial()) {
            IReferenceValuePresence onTarget = match_p.getOwnershipDifference(Role.TARGET);
            IReferenceValuePresence onReference = match_p.getOwnershipDifference(Role.REFERENCE);
            result = !((onTarget == null || !considerMerged_p && onTarget.isMerged() || !considerIgnored_p && this.getUIComparison().getDifferencesToIgnore().contains((Object)onTarget)) && (onReference == null || !considerMerged_p && onReference.isMerged() || !considerIgnored_p && this.getUIComparison().getDifferencesToIgnore().contains((Object)onReference)));
        }
        return result;
    }

    public boolean isEmpty() {
        EComparison comparison = this.getActualComparison();
        if (comparison != null) {
            for (IMatch match : comparison.getMapping().getContents()) {
                for (IDifference difference : match.getAllDifferences()) {
                    if (this.shouldBeIgnored(difference)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isFiltering() {
        return UserDifferenceKind.values().length != this._countedKinds.size();
    }

    public boolean isHideDifferenceNumbers() {
        return this._isHideDifferenceNumbers;
    }

    public boolean isMany(IPresenceDifference presence_p) {
        boolean result = true;
        if (presence_p instanceof IValuePresence) {
            IValuePresence valuePresence = (IValuePresence)presence_p;
            EStructuralFeature feature = valuePresence.getFeature();
            result = (feature == null || feature.isMany()) && !valuePresence.isOrder();
        }
        return result;
    }

    public boolean isMoveOrigin(TreePath path_p) {
        boolean result = false;
        IMatch end = (IMatch)path_p.getLastSegment();
        if (end != null && this.isAMove(end, false, true)) {
            TreePath parentPath = path_p.getParentPath();
            IMatch father = parentPath == null ? null : (IMatch)parentPath.getLastSegment();
            IComparison comparison = end.getMapping().getComparison();
            result = comparison.getContainerOf(end, this.getDrivingRole().opposite()) == father && comparison.getContainerOf(end, this.getDrivingRole()) != father;
        }
        return result;
    }

    public boolean isOwnershipOpposite(IDifference difference_p) {
        boolean result = false;
        if (difference_p instanceof IReferenceValuePresence) {
            IReferenceValuePresence valuePresence = (IReferenceValuePresence)difference_p;
            EReference ref = valuePresence.getFeature();
            result = ref == null || ref.isContainment();
        }
        return result;
    }

    public boolean isThreeWay() {
        return this.getActualComparison().isThreeWay();
    }

    public boolean representAsModification(IMatch match_p) {
        if (!this.counts(UserDifferenceKind.NO_CONTAINMENT) || match_p.getElementPresenceDifference() != null) {
            return false;
        }
        for (IDifference diff : match_p.getRelatedDifferences()) {
            if (!this.representAsModificationDifference(diff)) continue;
            return true;
        }
        return false;
    }

    protected boolean representAsModificationDifference(IDifference diff_p) {
        boolean result = false;
        if (diff_p instanceof IElementRelativePresence) {
            IElementRelativePresence presence = (IElementRelativePresence)diff_p;
            return presence.isUnrelatedToContainmentTree() && !this.shouldBeIgnored(diff_p);
        }
        return result;
    }

    public boolean representAsMove(IMatch match_p) {
        boolean result = false;
        if (this.counts(UserDifferenceKind.MOVE) && !match_p.isPartial()) {
            IReferenceValuePresence drivingOwnership = match_p.getOwnershipDifference(this.getDrivingRole());
            IReferenceValuePresence nonDrivingOwnership = match_p.getOwnershipDifference(this.getDrivingRole().opposite());
            result = drivingOwnership != null && !this.shouldBeIgnored((IDifference)drivingOwnership) || nonDrivingOwnership != null && !this.shouldBeIgnored((IDifference)nonDrivingOwnership);
        }
        return result;
    }

    public boolean representAsMoveOrigin(TreePath path_p) {
        IMatch end = (IMatch)path_p.getLastSegment();
        return this.representAsMove(end) && this.isMoveOrigin(path_p);
    }

    public boolean representAsUserDifference(IMatch match_p) {
        DifferenceKind kind = this.getDifferenceKind(match_p);
        boolean result = kind != DifferenceKind.NONE && kind != DifferenceKind.COUNTED;
        return result;
    }

    public boolean representAsUserDifference(TreePath path_p) {
        boolean result = false;
        IMatch end = (IMatch)path_p.getLastSegment();
        if (end != null) {
            result = this.representAsUserDifference(end) && !this.representAsMoveOrigin(path_p);
        }
        return result;
    }

    public void setCount(UserDifferenceKind kind_p, boolean count_p) {
        if (count_p) {
            this._countedKinds.add(kind_p);
        } else {
            this._countedKinds.remove((Object)kind_p);
        }
    }

    public void setDefaultCoverChildren(boolean coverChildren_p) {
        this._defaultCoverChildren = coverChildren_p;
    }

    public void setDefaultIncrementalMode(boolean isIncrementalMode_p) {
        this._defaultIncrementalMode = isIncrementalMode_p;
    }

    public void setDefaultShowImpact(boolean showImpact_p) {
        this._defaultShowMergeImpact = showImpact_p;
    }

    public void setDifferenceColor(EMFDiffMergeUIPlugin.DifferenceColorKind colorKind_p, int swtColor_p) {
        this._differenceColors.put(colorKind_p, new Integer(swtColor_p));
    }

    public void setDrivingRole(Role drivingRole_p) {
        if (Role.TARGET == drivingRole_p || Role.REFERENCE == drivingRole_p) {
            this._drivingRole = drivingRole_p;
        }
    }

    public void setEditable(boolean isEditable_p, boolean left_p) {
        if (this.isEditionPossible(left_p)) {
            if (this.getRoleForSide(left_p) == Role.TARGET) {
                this._isTargetEditable = isEditable_p;
            } else {
                this._isReferenceEditable = isEditable_p;
            }
        }
    }

    public void setHideDifferenceNumbers(boolean hideDifferenceNumbers_p) {
        this._isHideDifferenceNumbers = hideDifferenceNumbers_p;
    }

    public void setLeftRole(Role leftRole_p) {
        if (Role.TARGET == leftRole_p || Role.REFERENCE == leftRole_p) {
            this._leftRole = leftRole_p;
        }
    }

    public void setLogEvents(boolean logEvents_p) {
        this._isLogEvents = logEvents_p;
    }

    public void setModified(boolean isModified_p, boolean left_p) {
        if (this.getRoleForSide(left_p) == Role.TARGET) {
            this._isTargetModified = isModified_p;
        } else {
            this._isReferenceModified = isModified_p;
        }
    }

    public void setReferenceRole(Role role_p) {
        if (!(this.isThreeWay() || Role.TARGET != role_p && Role.REFERENCE != role_p)) {
            this._twoWayReferenceRole = role_p;
        }
    }

    public void setShowMergeImpact(boolean showMergeImpact_p) {
        this._isShowMergeImpact = showMergeImpact_p;
    }

    public void setUndoRedoSupported(boolean supportUndoRedo_p) {
        this._isUndoRedoSupported = this.getEditingDomain() != null && supportUndoRedo_p;
    }

    public void setUseCustomIcons(boolean useCustom_p) {
        this._useCustomIcons = useCustom_p;
    }

    public void setUseCustomLabels(boolean useCustom_p) {
        this._useCustomLabels = useCustom_p;
    }

    public boolean shouldBeIgnored(IDifference difference_p) {
        Role leftRole = this.getRoleForSide(true);
        return difference_p.isMerged() || this.getUIComparison().getDifferencesToIgnore().contains((Object)difference_p) || difference_p instanceof IValuePresence && ((IValuePresence)difference_p).isUnrelatedToContainmentTree() && !this.counts(UserDifferenceKind.NO_CONTAINMENT) || difference_p instanceof IElementPresence && (((IElementPresence)difference_p).getPresenceRole() == leftRole && !this.counts(UserDifferenceKind.PRESENCE_LEFT) || ((IElementPresence)difference_p).getPresenceRole() == leftRole.opposite() && !this.counts(UserDifferenceKind.PRESENCE_RIGHT));
    }

    public void updateDifferenceNumbers() {
        this.getMatchToNb().clear();
        for (IMatch match : this.getActualComparison().getMapping().getContents()) {
            int nb = this.countDifferenceNumber(match);
            this.incrementDifferenceNumbersInHierarchy((EMatch)match, nb);
        }
    }

    public boolean usesCustomIcons() {
        return this._useCustomIcons;
    }

    public boolean usesCustomLabels() {
        return this._useCustomLabels;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UserDifferenceKind {
        PRESENCE_LEFT,
        PRESENCE_RIGHT,
        MOVE,
        NO_CONTAINMENT;

    }
}

