/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.scopes;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.impl.scopes.AbstractEditableModelScope;
import org.eclipse.emf.diffmerge.util.structures.FArrayList;
import org.eclipse.emf.diffmerge.util.structures.IEqualityTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootedModelScope
extends AbstractEditableModelScope {
    protected final List<EObject> _roots;

    public RootedModelScope(List<? extends EObject> roots_p) {
        this._roots = new FArrayList<EObject>(roots_p, IEqualityTester.BY_REFERENCE);
    }

    public RootedModelScope(List<EObject> roots_p, boolean operateOnList_p) {
        this._roots = operateOnList_p ? roots_p : new FArrayList<EObject>(roots_p, IEqualityTester.BY_REFERENCE);
    }

    @Override
    public boolean add(EObject element_p) {
        return this._roots.add(element_p);
    }

    @Override
    public boolean add(EObject source_p, EReference reference_p, EObject value_p) {
        boolean result = super.add(source_p, reference_p, value_p);
        if (result && reference_p.isContainment()) {
            this._roots.remove(value_p);
        }
        return result;
    }

    @Override
    public boolean covers(EObject element_p) {
        return EcoreUtil.isAncestor(this._roots, (EObject)element_p);
    }

    @Override
    public EObject getContainer(EObject element_p) {
        return this.getContents().contains(element_p) ? null : super.getContainer(element_p);
    }

    @Override
    public EReference getContainment(EObject element_p) {
        return this.getContents().contains(element_p) ? null : super.getContainment(element_p);
    }

    @Override
    public List<EObject> getContents() {
        return Collections.unmodifiableList(this._roots);
    }

    @Override
    public boolean remove(EObject element_p) {
        boolean result = super.remove(element_p);
        if (result) {
            this._roots.remove(element_p);
        }
        return result;
    }
}

