/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public final class MiscUtil {
    public static String buildString(Object ... objects_p) {
        StringBuilder builder = new StringBuilder();
        Object[] objectArray = objects_p;
        int n = objects_p.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object != null) {
                builder.append(object);
            }
            ++n2;
        }
        return builder.toString();
    }

    public static void execute(EditingDomain domain_p, String label_p, Runnable runnable_p, boolean recordChanges_p) {
        if (recordChanges_p && domain_p != null) {
            MiscUtil.executeOnDomain(domain_p, label_p, runnable_p);
        } else {
            MiscUtil.executeAndForget(domain_p, runnable_p);
        }
    }

    public static void executeAndForget(EditingDomain domain_p, Runnable runnable_p) {
        if (domain_p != null && !MiscUtil.isRunningInActiveTransaction(domain_p)) {
            ForgettingCommand cmd = new ForgettingCommand(runnable_p);
            CommandStack cStack = domain_p.getCommandStack();
            if (cStack instanceof TransactionalCommandStack) {
                try {
                    ((TransactionalCommandStack)cStack).execute((Command)cmd, Collections.singletonMap("no_undo", Boolean.TRUE));
                }
                catch (Exception exception) {}
            } else {
                cStack.execute((Command)cmd);
            }
        } else {
            runnable_p.run();
        }
    }

    public static void executeOnDomain(EditingDomain domain_p, String label_p, final Runnable runnable_p) {
        if (MiscUtil.isRunningInActiveTransaction(domain_p)) {
            runnable_p.run();
        } else {
            String commandLabel = label_p != null ? label_p : Messages.MiscUtil_DefaultCommandName;
            ChangeCommand cmd = new ChangeCommand((Notifier)domain_p.getResourceSet(), commandLabel){
                {
                    super($anonymous0);
                    this.label = string;
                }

                protected void doExecute() {
                    runnable_p.run();
                }
            };
            domain_p.getCommandStack().execute((Command)cmd);
        }
    }

    public static void executeWithBusyCursor(final EditingDomain domain_p, final String label_p, final Runnable runnable_p, final boolean recordChanges_p, Display display_p) {
        Runnable actualOperation = new Runnable(){

            public void run() {
                MiscUtil.execute(domain_p, label_p, runnable_p, recordChanges_p);
            }
        };
        if (MiscUtil.isRunningInActiveTransaction(domain_p)) {
            actualOperation = ((TransactionalEditingDomain)domain_p).createPrivilegedRunnable(actualOperation);
        }
        BusyIndicator.showWhile((Display)display_p, (Runnable)actualOperation);
    }

    public static void executeWithProgress(EditingDomain domain_p, String label_p, IRunnableWithProgress behavior_p, boolean recordChanges_p) throws InvocationTargetException, InterruptedException {
        RunnableWithProgressOnModel operation = new RunnableWithProgressOnModel(behavior_p, label_p, domain_p, recordChanges_p);
        IProgressService progress = PlatformUI.getWorkbench().getProgressService();
        progress.busyCursorWhile((IRunnableWithProgress)operation);
    }

    public static IFile getFileFor(Resource resource_p, boolean allowExternal_p) {
        IWorkspace wk;
        IFile result = null;
        URI uri = resource_p.getURI();
        if (uri != null && (wk = ResourcesPlugin.getWorkspace()) != null && wk.getRoot() != null) {
            if (uri.isPlatformResource()) {
                String platformResourcePath = uri.toPlatformString(true);
                result = wk.getRoot().getFile((IPath)new Path(platformResourcePath));
            } else if (allowExternal_p) {
                IProject project = wk.getRoot().getProject("ExternalFiles");
                try {
                    if (!project.exists()) {
                        project.create(null);
                    }
                    if (!project.isOpen()) {
                        project.open(null);
                    }
                    Path path = new Path(uri.toFileString());
                    result = project.getFile(path.lastSegment());
                    result.createLink((IPath)path, 0, null);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static boolean isRunningInActiveTransaction(EditingDomain domain_p) {
        InternalTransaction activeTransaction;
        boolean result = false;
        if (domain_p instanceof InternalTransactionalEditingDomain && (activeTransaction = ((InternalTransactionalEditingDomain)domain_p).getActiveTransaction()) != null) {
            result = Thread.currentThread() == activeTransaction.getOwner();
        }
        return result;
    }

    protected static class ForgettingCommand
    extends AbstractCommand
    implements AbstractCommand.NonDirtying {
        private final Runnable _runnable;

        protected ForgettingCommand(Runnable runnable_p) {
            this._runnable = runnable_p;
        }

        public boolean canUndo() {
            return false;
        }

        protected boolean prepare() {
            return true;
        }

        public void execute() {
            this._runnable.run();
        }

        public void redo() {
        }
    }

    protected static class RunnableWithProgressOnModel
    implements IRunnableWithProgress,
    IThreadListener {
        protected final EditingDomain _domain;
        protected final boolean _recordChanges;
        protected Runnable _wrappingRunnable;
        protected IProgressMonitor _monitor;

        public RunnableWithProgressOnModel(final IRunnableWithProgress behavior_p, final String label_p, EditingDomain domain_p, boolean recordChanges_p) {
            this._domain = domain_p;
            this._recordChanges = recordChanges_p;
            this._wrappingRunnable = new Runnable(){

                public void run() {
                    MiscUtil.execute(RunnableWithProgressOnModel.this._domain, label_p, new Runnable(){

                        public void run() {
                            try {
                                behavior_p.run((this).RunnableWithProgressOnModel.this._monitor);
                            }
                            catch (InvocationTargetException e) {
                                throw new RuntimeException(e);
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }, RunnableWithProgressOnModel.this._recordChanges);
                }
            };
            this._monitor = null;
        }

        public void threadChange(Thread thread_p) {
            if (MiscUtil.isRunningInActiveTransaction(this._domain)) {
                TransactionalEditingDomain ted = (TransactionalEditingDomain)this._domain;
                this._wrappingRunnable = ted.createPrivilegedRunnable(this._wrappingRunnable);
            }
        }

        public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
            this._monitor = monitor_p;
            this._wrappingRunnable.run();
        }
    }
}

