/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.util.DelegatingLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.IComparisonSideViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ComparisonSideViewer
extends TreeViewer
implements IComparisonSideViewer {
    private final boolean _sideIsLeft;

    public ComparisonSideViewer(Composite parent_p, boolean isLeftSide_p) {
        this(parent_p, 770, isLeftSide_p);
    }

    public ComparisonSideViewer(Composite parent_p, int style_p, boolean isLeftSide_p) {
        super(parent_p, style_p);
        this._sideIsLeft = isLeftSide_p;
        this.setContentProvider((IContentProvider)new ContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public ITreeContentProvider getContentProvider() {
        return (ITreeContentProvider)super.getContentProvider();
    }

    public EMFDiffNode getInput() {
        return (EMFDiffNode)((Object)super.getInput());
    }

    public ITreeSelection getSelection() {
        return (ITreeSelection)super.getSelection();
    }

    public Color getSideColor() {
        return this.getInput() == null ? null : this.getInput().getDifferenceColor(this.isLeftSide() ? EMFDiffMergeUIPlugin.DifferenceColorKind.LEFT : EMFDiffMergeUIPlugin.DifferenceColorKind.RIGHT);
    }

    protected Role getSideRole() {
        return this.getInput() == null ? null : this.getInput().getRoleForSide(this.isLeftSide());
    }

    public IModelScope getSideScope() {
        return this.getInput() == null ? null : this.getInput().getActualComparison().getScope(this.getSideRole());
    }

    public boolean isLeftSide() {
        return this._sideIsLeft;
    }

    protected class ContentProvider
    implements ITreeContentProvider {
        protected ContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement_p) {
            EObject container = (EObject)parentElement_p;
            IModelScope scope = ComparisonSideViewer.this.getSideScope();
            Object[] result = scope != null ? scope.getContents(container).toArray() : new Object[]{};
            return result;
        }

        public Object[] getElements(Object inputElement_p) {
            IModelScope scope = ComparisonSideViewer.this.getSideScope();
            Object[] result = scope != null ? scope.getContents().toArray() : new Object[]{};
            return result;
        }

        public Object getParent(Object element_p) {
            EObject result = null;
            IModelScope scope = ComparisonSideViewer.this.getSideScope();
            if (scope != null) {
                result = scope.getContainer((EObject)element_p);
            }
            return result;
        }

        public boolean hasChildren(Object element_p) {
            return this.getChildren(element_p).length > 0;
        }

        public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
        }
    }

    protected class LabelProvider
    extends DelegatingLabelProvider {
        protected LabelProvider() {
        }

        public Color getForeground(Object element_p) {
            DifferenceKind kind;
            EObject element = (EObject)element_p;
            IMatch match = ComparisonSideViewer.this.getInput().getActualComparison().getMapping().getMatchFor(element, ComparisonSideViewer.this.getSideRole());
            Color result = match != null ? (!(kind = ComparisonSideViewer.this.getInput().getDifferenceKind(match)).isNeutral() ? ComparisonSideViewer.this.getSideColor() : ComparisonSideViewer.this.getInput().getDifferenceColor(EMFDiffMergeUIPlugin.DifferenceColorKind.NONE)) : super.getForeground(element_p);
            return result;
        }
    }
}

