/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.setup;

import java.util.Collections;
import java.util.List;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.setup.ComparisonSetupManager;
import org.eclipse.emf.diffmerge.ui.setup.EMFDiffMergeEditorInput;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareModelsAction
implements IObjectActionDelegate {
    private IStructuredSelection _selection = null;
    private Shell _shell = null;

    protected List<Object> getSelection() {
        List<Object> result = this._selection == null ? Collections.emptyList() : Collections.unmodifiableList(this._selection.toList());
        return result;
    }

    protected Shell getShell() {
        return this._shell;
    }

    protected boolean isApplicable() {
        List<Object> allSelected = this.getSelection();
        int size = allSelected.size();
        if (size != 2 && size != 3) {
            return false;
        }
        ComparisonSetupManager manager = EMFDiffMergeUIPlugin.getDefault().getSetupManager();
        for (Object selected : allSelected) {
            if (manager.isValidEntrypoint(selected)) continue;
            return false;
        }
        return true;
    }

    public void run(IAction action_p) {
        ComparisonSetupManager manager;
        EMFDiffMergeEditorInput editorInput;
        List<Object> allSelected = this.getSelection();
        int size = allSelected.size();
        if ((size == 2 || size == 3) && (editorInput = (manager = EMFDiffMergeUIPlugin.getDefault().getSetupManager()).createEditorInputWithUI(this.getShell(), allSelected.get(0), allSelected.get(1), size == 3 ? allSelected.get(2) : null)) != null) {
            CompareUI.openCompareEditor((CompareEditorInput)editorInput);
        }
    }

    public void selectionChanged(IAction action_p, ISelection selection_p) {
        this._selection = selection_p instanceof IStructuredSelection ? (IStructuredSelection)selection_p : null;
        if (action_p != null) {
            action_p.setEnabled(this.isApplicable());
        }
    }

    public void setActivePart(IAction action_p, IWorkbenchPart targetPart_p) {
        if (targetPart_p != null && targetPart_p.getSite() != null) {
            this._shell = targetPart_p.getSite().getShell();
        }
    }
}

