/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.git.ext;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.connector.git.EMFDiffMergeGitConnectorPlugin;
import org.eclipse.emf.diffmerge.connector.git.Messages;
import org.eclipse.emf.diffmerge.connector.git.ext.GitHelper;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.history.IFileRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGitURIConverter
extends ExtensibleURIConverterImpl {
    private final Repository _repository;

    public AbstractGitURIConverter(Repository repository_p) {
        this._repository = repository_p;
    }

    public AbstractGitURIConverter(List<URIHandler> uriHandlers_p, List<ContentHandler> contentHandlers_p, Repository repository_p) {
        super(uriHandlers_p, contentHandlers_p);
        this._repository = repository_p;
    }

    public InputStream createInputStream(URI uri_p, Map<?, ?> options_p) throws IOException {
        Repository repo = this._repository;
        if (repo != null && this.isSupportedURI(uri_p)) {
            String pathRepresentation = this.getURIPathRepresentation(uri_p);
            IPath newPath = new Path(repo.getWorkTree().getAbsolutePath()).append(pathRepresentation);
            File target = newPath.toFile();
            if (target != null && target.exists()) {
                try {
                    String gitPath = pathRepresentation.substring(1);
                    return this.getGitFileRevision(gitPath).getStorage((IProgressMonitor)new NullProgressMonitor()).getContents();
                }
                catch (CoreException e) {
                    EMFDiffMergeGitConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeGitConnectorPlugin.getDefault().getPluginId(), e.getMessage(), (Throwable)e));
                }
            } else {
                EMFDiffMergeGitConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeGitConnectorPlugin.getDefault().getPluginId(), String.format(Messages.AbstractGitURIConverter_CannotFindResource, newPath)));
            }
        }
        return super.createInputStream(uri_p, options_p);
    }

    protected abstract IFileRevision getGitFileRevision(String var1);

    protected Repository getRepository() {
        return this._repository;
    }

    protected String getURIPathRepresentation(URI uri_p) {
        return uri_p.devicePath();
    }

    protected boolean isSupportedURI(URI uri_p) {
        return GitHelper.INSTANCE.getGitSchemes().contains(uri_p.scheme());
    }
}

